/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.OptionalType;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.types.multi.UnitType;
import info.openmods.calc.utils.MiscUtils;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetaObject {
    @SlotField(adapter=SlotBoolAdapter.class)
    public final SlotBool slotBool;
    @SlotField(adapter=SlotLengthAdapter.class)
    public final SlotLength slotLength;
    @SlotField(adapter=SlotAttrAdapter.class)
    public final SlotAttr slotAttr;
    @SlotField(adapter=SlotEqualsAdapter.class)
    public final SlotEquals slotEquals;
    private static final OptionalInt.IntFunction ADD_SELF_TO_COUNT = new OptionalInt.IntFunction(){

        @Override
        public int apply(int value) {
            return value + 1;
        }
    };
    @SlotField(adapter=SlotCallAdapter.class)
    public final SlotCall slotCall;
    @SlotField(adapter=SlotTypeAdapter.class)
    public final SlotType slotType;
    @SlotField(adapter=SlotSliceAdapter.class)
    public final SlotSlice slotSlice;
    @SlotField(adapter=SlotStrAdapter.class)
    public final SlotStr slotStr;
    @SlotField(adapter=SlotReprAdapter.class)
    public final SlotRepr slotRepr;
    @SlotField(adapter=SlotDecomposeAdapter.class)
    public final SlotDecompose slotDecompose;
    @SlotField(adapter=SlotDirAdapter.class)
    public final SlotDir slotDir;
    @SlotField(adapter=SlotUnaryOpAdapter.class)
    public final Map<String, SlotUnaryOp> slotsUnaryOps;
    @SlotField(adapter=SlotBinaryOpAdapter.class)
    public final Map<String, SlotBinaryOp> slotsBinaryOps;

    private MetaObject(Builder builder) {
        this.slotAttr = builder.slotAttr;
        this.slotBool = builder.slotBool;
        this.slotCall = builder.slotCall;
        this.slotEquals = builder.slotEquals;
        this.slotLength = builder.slotLength;
        this.slotRepr = builder.slotRepr;
        this.slotSlice = builder.slotSlice;
        this.slotStr = builder.slotStr;
        this.slotType = builder.slotType;
        this.slotDecompose = builder.slotDecompose;
        this.slotDir = builder.slotDir;
        this.slotsBinaryOps = ImmutableMap.copyOf((Map)builder.slotsBinaryOps);
        this.slotsUnaryOps = ImmutableMap.copyOf((Map)builder.slotsUnaryOps);
    }

    private static <T extends Slot> T update(T update, T original) {
        return update != null ? update : original;
    }

    private static <T extends Slot> Map<String, T> update(Map<String, T> update, Map<String, T> original) {
        HashMap mutableMap = Maps.newHashMap(original);
        mutableMap.putAll(update);
        return ImmutableMap.copyOf((Map)mutableMap);
    }

    private MetaObject(MetaObject prev, Builder builder) {
        this.slotAttr = MetaObject.update(builder.slotAttr, prev.slotAttr);
        this.slotBool = MetaObject.update(builder.slotBool, prev.slotBool);
        this.slotCall = MetaObject.update(builder.slotCall, prev.slotCall);
        this.slotEquals = MetaObject.update(builder.slotEquals, prev.slotEquals);
        this.slotLength = MetaObject.update(builder.slotLength, prev.slotLength);
        this.slotRepr = MetaObject.update(builder.slotRepr, prev.slotRepr);
        this.slotSlice = MetaObject.update(builder.slotSlice, prev.slotSlice);
        this.slotStr = MetaObject.update(builder.slotStr, prev.slotStr);
        this.slotType = MetaObject.update(builder.slotType, prev.slotType);
        this.slotDecompose = MetaObject.update(builder.slotDecompose, prev.slotDecompose);
        this.slotDir = MetaObject.update(builder.slotDir, prev.slotDir);
        this.slotsBinaryOps = MetaObject.update(builder.slotsBinaryOps, prev.slotsBinaryOps);
        this.slotsUnaryOps = MetaObject.update(builder.slotsUnaryOps, prev.slotsUnaryOps);
    }

    private static TypedValue callFunction(Frame<TypedValue> frame, TypedValue callable, TypedValue self, TypedValue arg) {
        Stack<TypedValue> substack = frame.stack().substack(0);
        substack.push(self);
        substack.push(arg);
        Frame<TypedValue> executionFrame = FrameFactory.newLocalFrame(frame, substack);
        MetaObjectUtils.call(executionFrame, callable, OptionalInt.TWO, OptionalInt.ONE);
        return substack.popAndExpectEmptyStack();
    }

    private static TypedValue callFunction(Frame<TypedValue> frame, TypedValue callable, TypedValue self) {
        Stack<TypedValue> substack = frame.stack().substack(0);
        substack.push(self);
        Frame<TypedValue> executionFrame = FrameFactory.newLocalFrame(frame, substack);
        MetaObjectUtils.call(executionFrame, callable, OptionalInt.ONE, OptionalInt.ONE);
        return substack.popAndExpectEmptyStack();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SlotBool slotBool;
        private SlotLength slotLength;
        private SlotAttr slotAttr;
        private SlotEquals slotEquals;
        private SlotCall slotCall;
        private SlotType slotType;
        private SlotSlice slotSlice;
        private SlotStr slotStr;
        private SlotRepr slotRepr;
        private SlotDecompose slotDecompose;
        private SlotDir slotDir;
        private Map<String, SlotBinaryOp> slotsBinaryOps = Maps.newHashMap();
        private Map<String, SlotUnaryOp> slotsUnaryOps = Maps.newHashMap();

        public Builder set(SlotBool slotBool) {
            Preconditions.checkState((this.slotBool == null ? 1 : 0) != 0);
            this.slotBool = slotBool;
            return this;
        }

        public Builder set(SlotLength slotLength) {
            Preconditions.checkState((this.slotLength == null ? 1 : 0) != 0);
            this.slotLength = slotLength;
            return this;
        }

        public Builder set(SlotAttr slotAttr) {
            Preconditions.checkState((this.slotAttr == null ? 1 : 0) != 0);
            this.slotAttr = slotAttr;
            return this;
        }

        public Builder set(SlotEquals slotEquals) {
            Preconditions.checkState((this.slotEquals == null ? 1 : 0) != 0);
            this.slotEquals = slotEquals;
            return this;
        }

        public Builder set(SlotCall slotCall) {
            Preconditions.checkState((this.slotCall == null ? 1 : 0) != 0);
            this.slotCall = slotCall;
            return this;
        }

        public Builder set(SlotType slotType) {
            Preconditions.checkState((this.slotType == null ? 1 : 0) != 0);
            this.slotType = slotType;
            return this;
        }

        public Builder set(SlotSlice slotSlice) {
            Preconditions.checkState((this.slotSlice == null ? 1 : 0) != 0);
            this.slotSlice = slotSlice;
            return this;
        }

        public Builder set(SlotStr slotStr) {
            Preconditions.checkState((this.slotStr == null ? 1 : 0) != 0);
            this.slotStr = slotStr;
            return this;
        }

        public Builder set(SlotRepr slotRepr) {
            Preconditions.checkState((this.slotRepr == null ? 1 : 0) != 0);
            this.slotRepr = slotRepr;
            return this;
        }

        public Builder set(SlotDecompose slotDecompose) {
            Preconditions.checkState((this.slotDecompose == null ? 1 : 0) != 0);
            this.slotDecompose = slotDecompose;
            return this;
        }

        public Builder set(SlotDir slotDir) {
            Preconditions.checkState((this.slotDir == null ? 1 : 0) != 0);
            this.slotDir = slotDir;
            return this;
        }

        public Builder set(String op, SlotBinaryOp slotBinaryOp) {
            MiscUtils.putOnce(this.slotsBinaryOps, op, slotBinaryOp);
            return this;
        }

        public Builder set(String op, SlotUnaryOp slotUnaryOp) {
            MiscUtils.putOnce(this.slotsUnaryOps, op, slotUnaryOp);
            return this;
        }

        public MetaObject build() {
            return new MetaObject(this);
        }

        public MetaObject update(MetaObject meta) {
            return new MetaObject(meta, this);
        }
    }

    public static class SlotBinaryOpAdapter
    implements SlotAdapter<SlotBinaryOp> {
        @Override
        public void call(SlotBinaryOp slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(2);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue other = stack.pop();
            TypedValue self = stack.pop();
            TypedValue result = slot.op(self, other, frame);
            stack.push(result);
        }

        @Override
        public SlotBinaryOp wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotBinaryOp,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public TypedValue op(TypedValue self, TypedValue other, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self, other);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotBinaryOp
    extends Slot {
        public TypedValue op(TypedValue var1, TypedValue var2, Frame<TypedValue> var3);
    }

    public static class SlotUnaryOpAdapter
    implements SlotAdapter<SlotUnaryOp> {
        @Override
        public void call(SlotUnaryOp slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            TypedValue result = slot.op(self, frame);
            stack.push(result);
        }

        @Override
        public SlotUnaryOp wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotUnaryOp,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public TypedValue op(TypedValue self, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotUnaryOp
    extends Slot {
        public TypedValue op(TypedValue var1, Frame<TypedValue> var2);
    }

    public static class SlotDirAdapter
    implements SlotAdapter<SlotDir> {
        @Override
        public void call(SlotDir slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            Iterable<String> result = slot.dir(self, frame);
            TypeDomain domain = self.domain;
            ImmutableList wrappedResults = ImmutableList.copyOf((Iterable)Iterables.transform(result, domain.createWrappingTransformer(String.class)));
            TypedValue nullValue = domain.getDefault(UnitType.class);
            stack.push(Cons.createList((List<TypedValue>)wrappedResults, nullValue));
        }

        @Override
        public SlotDir wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotDir,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public Iterable<String> dir(TypedValue self, Frame<TypedValue> frame) {
                    TypedValue result = MetaObject.callFunction(frame, callable, self);
                    TypeDomain domain = self.domain;
                    return Iterables.transform(Cons.toIterable(result, domain.getDefault(UnitType.class)), domain.createUnwrappingTransformer(String.class));
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotDir
    extends Slot {
        public Iterable<String> dir(TypedValue var1, Frame<TypedValue> var2);
    }

    public static class SlotDecomposeAdapter
    implements SlotAdapter<SlotDecompose> {
        @Override
        public void call(SlotDecompose slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            int count = stack.pop().as(BigInteger.class).intValue();
            TypedValue input = stack.pop();
            TypedValue self = stack.pop();
            Optional<List<TypedValue>> result = slot.tryDecompose(self, input, count, frame);
            TypeDomain domain = self.domain;
            if (result.isPresent()) {
                Iterator it = ((List)result.get()).iterator();
                TypedValue resultList = (TypedValue)it.next();
                while (it.hasNext()) {
                    TypedValue nextResult = (TypedValue)it.next();
                    resultList = domain.create(Cons.class, new Cons(nextResult, resultList));
                }
                stack.push(OptionalType.present(self.domain, resultList));
            } else {
                stack.push(OptionalType.absent(self.domain));
            }
        }

        @Override
        public SlotDecompose wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotDecompose,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                    Stack<TypedValue> stack = frame.stack().substack(0);
                    stack.push(self);
                    stack.push(input);
                    stack.push(self.domain.create(BigInteger.class, BigInteger.valueOf(variableCount)));
                    Frame<TypedValue> executionFrame = FrameFactory.newLocalFrame(frame, stack);
                    MetaObjectUtils.call(executionFrame, callable, OptionalInt.of(3), OptionalInt.of(1));
                    TypedValue result = stack.popAndExpectEmptyStack();
                    OptionalType.Value maybeResult = result.as(OptionalType.Value.class);
                    if (maybeResult.isPresent()) {
                        TypedValue currentResult = maybeResult.getValue();
                        ArrayList unpackedResults = Lists.newArrayList();
                        while (currentResult.is(Cons.class)) {
                            Cons pair = currentResult.as(Cons.class);
                            unpackedResults.add(pair.car);
                            currentResult = pair.cdr;
                        }
                        unpackedResults.add(currentResult);
                        return Optional.of((Object)unpackedResults);
                    }
                    return Optional.absent();
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotDecompose
    extends Slot {
        public Optional<List<TypedValue>> tryDecompose(TypedValue var1, TypedValue var2, int var3, Frame<TypedValue> var4);
    }

    public static class SlotReprAdapter
    implements SlotAdapter<SlotRepr> {
        @Override
        public void call(SlotRepr slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            String result = slot.repr(self, frame);
            stack.push(self.domain.create(String.class, result));
        }

        @Override
        public SlotRepr wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotRepr,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public String repr(TypedValue self, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self).as(String.class);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotRepr
    extends Slot {
        public String repr(TypedValue var1, Frame<TypedValue> var2);
    }

    public static class SlotStrAdapter
    implements SlotAdapter<SlotStr> {
        @Override
        public void call(SlotStr slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            String result = slot.str(self, frame);
            stack.push(self.domain.create(String.class, result));
        }

        @Override
        public SlotStr wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotStr,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public String str(TypedValue self, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self).as(String.class);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotStr
    extends Slot {
        public String str(TypedValue var1, Frame<TypedValue> var2);
    }

    public static class SlotSliceAdapter
    implements SlotAdapter<SlotSlice> {
        @Override
        public void call(SlotSlice slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(2);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue range = stack.pop();
            TypedValue self = stack.pop();
            TypedValue result = slot.slice(self, range, frame);
            stack.push(result);
        }

        @Override
        public SlotSlice wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotSlice,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public TypedValue slice(TypedValue self, TypedValue range, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self, range);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotSlice
    extends Slot {
        public TypedValue slice(TypedValue var1, TypedValue var2, Frame<TypedValue> var3);
    }

    public static class SlotTypeAdapter
    implements SlotAdapter<SlotType> {
        @Override
        public void call(SlotType slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            TypedValue result = slot.type(self, frame);
            stack.push(result);
        }

        @Override
        public SlotType wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotType,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public TypedValue type(TypedValue self, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotType
    extends Slot {
        public TypedValue type(TypedValue var1, Frame<TypedValue> var2);
    }

    public static class SlotCallAdapter
    implements SlotAdapter<SlotCall> {
        @Override
        public void call(SlotCall slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            int argCount = argumentsCount.get() - 1;
            TypedValue self = frame.stack().drop(argCount);
            slot.call(self, OptionalInt.of(argCount), returnsCount, frame);
        }

        @Override
        public SlotCall wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotCall,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                    Stack<TypedValue> substack = frame.stack().substack(argumentsCount.get());
                    ImmutableList args = ImmutableList.copyOf(substack);
                    substack.clear();
                    substack.push(self);
                    substack.pushAll((Collection<TypedValue>)args);
                    Frame<TypedValue> executionFrame = FrameFactory.newLocalFrame(frame, substack);
                    MetaObjectUtils.call(executionFrame, callable, argumentsCount.map(ADD_SELF_TO_COUNT), returnsCount);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotCall
    extends Slot {
        public void call(TypedValue var1, OptionalInt var2, OptionalInt var3, Frame<TypedValue> var4);
    }

    public static class SlotEqualsAdapter
    implements SlotAdapter<SlotEquals> {
        @Override
        public void call(SlotEquals slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(2);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue other = stack.pop();
            TypedValue self = stack.pop();
            boolean result = slot.equals(self, other, frame);
            stack.push(self.domain.create(Boolean.class, result));
        }

        @Override
        public SlotEquals wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotEquals,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public boolean equals(TypedValue self, TypedValue value, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self, value).as(Boolean.class);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotEquals
    extends Slot {
        public boolean equals(TypedValue var1, TypedValue var2, Frame<TypedValue> var3);
    }

    public static class SlotAttrAdapter
    implements SlotAdapter<SlotAttr> {
        @Override
        public void call(SlotAttr slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(2);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            String key = stack.pop().as(String.class);
            TypedValue self = stack.pop();
            Optional<TypedValue> result = slot.attr(self, key, frame);
            stack.push(OptionalType.fromOptional(self.domain, result));
        }

        @Override
        public SlotAttr wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotAttr,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                    Stack<TypedValue> substack = frame.stack().substack(0);
                    substack.push(self);
                    substack.push(self.domain.create(String.class, key));
                    Frame<TypedValue> executionFrame = FrameFactory.newLocalFrame(frame, substack);
                    MetaObjectUtils.call(executionFrame, callable, OptionalInt.TWO, OptionalInt.ONE);
                    TypedValue result = substack.pop();
                    return result.as(OptionalType.Value.class).asOptional();
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotAttr
    extends Slot {
        public Optional<TypedValue> attr(TypedValue var1, String var2, Frame<TypedValue> var3);
    }

    public static class SlotLengthAdapter
    implements SlotAdapter<SlotLength> {
        @Override
        public void call(SlotLength slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            int result = slot.length(self, frame);
            stack.push(self.domain.create(BigInteger.class, BigInteger.valueOf(result)));
        }

        @Override
        public SlotLength wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotLength,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public int length(TypedValue self, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self).as(BigInteger.class).intValue();
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotLength
    extends Slot {
        public int length(TypedValue var1, Frame<TypedValue> var2);
    }

    public static class SlotBoolAdapter
    implements SlotAdapter<SlotBool> {
        @Override
        public void call(SlotBool slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            argumentsCount.compareIfPresent(1);
            returnsCount.compareIfPresent(1);
            Stack<TypedValue> stack = frame.stack();
            TypedValue self = stack.pop();
            boolean result = slot.bool(self, frame);
            stack.push(self.domain.create(Boolean.class, result));
        }

        @Override
        public SlotBool wrap(final TypedValue callable) {
            class WrappedSlot
            implements SlotBool,
            SlotWithValue {
                WrappedSlot() {
                }

                @Override
                public boolean bool(TypedValue self, Frame<TypedValue> frame) {
                    return MetaObject.callFunction(frame, callable, self).as(Boolean.class);
                }

                @Override
                public TypedValue getValue() {
                    return callable;
                }
            }
            return new WrappedSlot();
        }
    }

    public static interface SlotBool
    extends Slot {
        public boolean bool(TypedValue var1, Frame<TypedValue> var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SlotField {
        public Class<? extends SlotAdapter<? extends Slot>> adapter();
    }

    public static interface SlotWithValue
    extends Slot {
        public TypedValue getValue();
    }

    public static interface SlotAdapter<T extends Slot> {
        public void call(T var1, Frame<TypedValue> var2, OptionalInt var3, OptionalInt var4);

        public T wrap(TypedValue var1);
    }

    public static interface Slot {
    }
}

