/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.entities;

import java.util.List;
import java.util.Objects;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGrapple
extends Entity
implements IProjectile {
    private static final DataParameter<Integer> PULLING_ENTITY_ID = EntityDataManager.func_187226_a(EntityGrapple.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_PULLING = EntityDataManager.func_187226_a(EntityGrapple.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> STRING_ITEM_STACK = EntityDataManager.func_187226_a(EntityGrapple.class, (DataSerializer)DataSerializers.field_187196_f);
    private BlockPos hitVec;
    private Block hitBlock;
    private int inData;
    private boolean inGround;
    public int canBePickedUp;
    public int arrowShake;
    public EntityPlayer shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    public float rotationRoll;
    public float prevRotationRoll;
    public boolean pullingPlayer;

    public EntityGrapple(World par1World) {
        super(par1World);
        this.field_70158_ak = false;
        this.func_70105_a(0.75f, 0.75f);
    }

    public EntityGrapple(World par1World, EntityPlayer shootingEntity, float par3, ItemStack stringStack) {
        super(par1World);
        this.shootingEntity = shootingEntity;
        this.func_70105_a(0.75f, 0.75f);
        if (shootingEntity != null) {
            this.canBePickedUp = 1;
            this.func_70012_b(shootingEntity.field_70165_t, shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e(), shootingEntity.field_70161_v, shootingEntity.field_70177_z, shootingEntity.field_70125_A);
        }
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 57.295776f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 57.295776f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 57.295776f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 57.295776f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 57.295776f));
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
        this.updateStringStack(stringStack);
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * 10.0) * d0;
    }

    public double func_70033_W() {
        return -1.5;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PULLING_ENTITY_ID, (Object)0);
        this.field_70180_af.func_187214_a(IS_PULLING, (Object)false);
        this.field_70180_af.func_187214_a(STRING_ITEM_STACK, (Object)new ItemStack(Items.field_151007_F));
    }

    public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)f2;
        par3 /= (double)f2;
        par5 /= (double)f2;
        par1 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)Math.atan2(par1, par5) * 57.295776f;
        this.field_70127_C = this.field_70125_A = (float)Math.atan2(par3, f3) * 57.295776f;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)Math.atan2(par1, par5) * 57.295776f;
            this.field_70127_C = this.field_70125_A = (float)Math.atan2(par3, f) * 57.295776f;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        IBlockState state;
        EntityPlayer shootingEntity;
        super.func_70071_h_();
        this.prevRotationRoll = this.rotationRoll;
        if (!this.field_70170_p.field_72995_K) {
            this.updateShootingEntity();
            if (this.getPullingEntity() && (shootingEntity = this.getShootingEntity()) != null) {
                double deltaPosition = this.func_70068_e((Entity)shootingEntity);
                Vector3 mot = new Vector3(shootingEntity.field_70159_w, shootingEntity.field_70181_x, shootingEntity.field_70179_y);
                if (mot.getMagnitudeSquared() < 0.01 && this.pullingPlayer) {
                    if (deltaPosition < 10.0) {
                        this.func_70100_b_(shootingEntity);
                    }
                    this.updatePullingEntity(false);
                    this.func_70106_y();
                }
                this.pullingPlayer = true;
            }
        } else if (this.getPullingEntity() && (shootingEntity = this.getShootingEntity()) != null) {
            GCPlayerStatsClient stats;
            shootingEntity.func_70016_h((this.field_70165_t - shootingEntity.field_70165_t) / 12.0, (this.field_70163_u - shootingEntity.field_70163_u) / 12.0, (this.field_70161_v - shootingEntity.field_70161_v) / 12.0);
            if (shootingEntity.field_70170_p.field_72995_K && shootingEntity.field_70170_p.field_73011_w instanceof IZeroGDimension && (stats = GCPlayerStatsClient.get((Entity)shootingEntity)) != null) {
                stats.getFreefallHandler().updateFreefall(shootingEntity);
            }
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)Math.atan2(this.field_70159_w, this.field_70179_y) * 57.295776f;
            this.field_70127_C = this.field_70125_A = (float)Math.atan2(this.field_70181_x, f) * 57.295776f;
        }
        if (this.hitVec != null && (state = this.field_70170_p.func_180495_p(this.hitVec)).func_185904_a() != Material.field_151579_a && (axisalignedbb = state.func_177230_c().func_180646_a(state, (IBlockAccess)this.field_70170_p, this.hitVec)) != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            if (this.hitVec != null) {
                state = this.field_70170_p.func_180495_p(this.hitVec);
                Block block = state.func_177230_c();
                int j = block.func_176201_c(state);
                if (block == this.hitBlock && j == this.inData) {
                    if (this.shootingEntity != null) {
                        this.shootingEntity.field_70159_w = (this.field_70165_t - this.shootingEntity.field_70165_t) / 16.0;
                        this.shootingEntity.field_70181_x = (this.field_70163_u - this.shootingEntity.field_70163_u) / 16.0;
                        this.shootingEntity.field_70179_y = (this.field_70161_v - this.shootingEntity.field_70161_v) / 16.0;
                        if (this.shootingEntity instanceof EntityPlayerMP) {
                            GalacticraftCore.handler.preventFlyingKicks((EntityPlayerMP)this.shootingEntity);
                        }
                    }
                    if (!this.field_70170_p.field_72995_K && this.ticksInGround < 5) {
                        this.updatePullingEntity(true);
                    }
                    ++this.ticksInGround;
                    if (this.ticksInGround == 1200) {
                        this.func_70106_y();
                    }
                } else {
                    this.inGround = false;
                    this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.ticksInGround = 0;
                    this.ticksInAir = 0;
                }
            }
        } else {
            this.rotationRoll += 5.0f;
            ++this.ticksInAir;
            if (!this.field_70170_p.field_72995_K) {
                this.updatePullingEntity(false);
            }
            if (this.shootingEntity != null && this.func_70068_e((Entity)this.shootingEntity) >= 1600.0) {
                this.func_70106_y();
            }
            Vec3d vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec3 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            double border = 0.3;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                AxisAlignedBB axisalignedbb1;
                RayTraceResult movingobjectposition1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.shootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.func_174813_aQ().func_72314_b(0.3, 0.3, 0.3)).func_72327_a(vec31, vec3)) == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity != null && !this.shootingEntity.func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g == null) {
                this.hitVec = movingobjectposition.func_178782_a();
                IBlockState state2 = this.field_70170_p.func_180495_p(this.hitVec);
                this.hitBlock = state2.func_177230_c();
                this.inData = state2.func_177230_c().func_176201_c(state2);
                this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
                this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
                this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
                float motion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                this.field_70165_t -= this.field_70159_w / (double)motion * (double)0.05f;
                this.field_70163_u -= this.field_70181_x / (double)motion * (double)0.05f;
                this.field_70161_v -= this.field_70179_y / (double)motion * (double)0.05f;
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.inGround = true;
                this.arrowShake = 7;
                if (this.hitBlock.func_149688_o(state2) != Material.field_151579_a) {
                    this.hitBlock.func_180634_a(this.field_70170_p, this.hitVec, state2, (Entity)this);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float motion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)Math.atan2(this.field_70159_w, this.field_70179_y) * 57.295776f;
            this.field_70125_A = (float)Math.atan2(this.field_70181_x, motion) * 57.295776f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            if (this.func_70090_H()) {
                float f4 = 0.25f;
                for (int l = 0; l < 4; ++l) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
        if (!this.field_70170_p.field_72995_K && (this.ticksInGround - 1) % 10 == 0) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimpleAsteroids(PacketSimpleAsteroids.EnumSimplePacketAsteroids.C_UPDATE_GRAPPLE_POS, GCCoreUtil.getDimensionID(this.field_70170_p), new Object[]{this.func_145782_y(), new Vector3(this)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        if (this.hitVec != null) {
            par1NBTTagCompound.func_74777_a("xTile", (short)this.hitVec.func_177958_n());
            par1NBTTagCompound.func_74777_a("yTile", (short)this.hitVec.func_177956_o());
            par1NBTTagCompound.func_74777_a("zTile", (short)this.hitVec.func_177952_p());
        }
        par1NBTTagCompound.func_74777_a("life", (short)this.ticksInGround);
        par1NBTTagCompound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.hitBlock));
        par1NBTTagCompound.func_74774_a("inData", (byte)this.inData);
        par1NBTTagCompound.func_74774_a("shake", (byte)this.arrowShake);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.func_74774_a("pickup", (byte)this.canBePickedUp);
        par1NBTTagCompound.func_74778_a("stringStack", Objects.requireNonNull(this.getStringItemStack().func_77973_b().getRegistryName()).toString());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound.func_74764_b("xTile")) {
            this.hitVec = new BlockPos((int)par1NBTTagCompound.func_74765_d("xTile"), (int)par1NBTTagCompound.func_74765_d("yTile"), (int)par1NBTTagCompound.func_74765_d("zTile"));
        }
        this.ticksInGround = par1NBTTagCompound.func_74765_d("life");
        this.hitBlock = Block.func_149729_e((int)(par1NBTTagCompound.func_74771_c("inTile") & 0xFF));
        this.inData = par1NBTTagCompound.func_74771_c("inData") & 0xFF;
        this.arrowShake = par1NBTTagCompound.func_74771_c("shake") & 0xFF;
        boolean bl = this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        if (par1NBTTagCompound.func_150297_b("pickup", 99)) {
            this.canBePickedUp = par1NBTTagCompound.func_74771_c("pickup");
        } else if (par1NBTTagCompound.func_150297_b("player", 99)) {
            int n = this.canBePickedUp = par1NBTTagCompound.func_74767_n("player") ? 1 : 0;
        }
        if (par1NBTTagCompound.func_74764_b("stringStack")) {
            this.updateStringStack(new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation(par1NBTTagCompound.func_74779_i("stringStack"))))));
        } else {
            this.updateStringStack(new ItemStack(Items.field_151007_F));
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && par1EntityPlayer.field_71075_bZ.field_75098_d;
            if (this.canBePickedUp == 1 && this.getStringItemStack() != ItemStack.field_190927_a && !par1EntityPlayer.field_71071_by.func_70441_a(this.getStringItemStack())) {
                flag = false;
            }
            if (flag) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    private void updateShootingEntity() {
        if (this.shootingEntity != null) {
            this.field_70180_af.func_187227_b(PULLING_ENTITY_ID, (Object)this.shootingEntity.func_145782_y());
        }
    }

    public EntityPlayer getShootingEntity() {
        Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY_ID)).intValue());
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        return null;
    }

    public void updatePullingEntity(boolean pulling) {
        this.field_70180_af.func_187227_b(IS_PULLING, (Object)pulling);
    }

    public void updateStringStack(ItemStack stringStack) {
        this.field_70180_af.func_187227_b(STRING_ITEM_STACK, (Object)stringStack);
    }

    public boolean getPullingEntity() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_PULLING);
    }

    public ItemStack getStringItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STRING_ITEM_STACK);
    }
}

