/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.event.celestial.RegisterEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialObject;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialType;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.util.stream.CelestialCollector;
import micdoodle8.mods.galacticraft.core.util.list.CelestialList;
import micdoodle8.mods.galacticraft.core.util.list.ImmutableCelestialList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GalaxyRegistry {
    static CelestialList<SolarSystem> solarSystems = CelestialList.create();
    static CelestialList<Planet> planets = CelestialList.create();
    static CelestialList<Moon> moons = CelestialList.create();
    static CelestialList<Satellite> satellites = CelestialList.create();
    static CelestialList<CelestialObject> objects = CelestialList.create();
    static Map<Planet, CelestialList<Moon>> moonList = new HashMap<Planet, CelestialList<Moon>>();
    static Map<CelestialBody, CelestialList<Satellite>> satelliteList = new HashMap<CelestialBody, CelestialList<Satellite>>();
    static Map<SolarSystem, CelestialList<Planet>> solarSystemList = new HashMap<SolarSystem, CelestialList<Planet>>();

    public static void refreshGalaxies() {
        CelestialList<CelestialBody> list;
        moonList.clear();
        satelliteList.clear();
        solarSystemList.clear();
        for (Moon moon : GalaxyRegistry.getMoons()) {
            Planet planet = moon.getParentPlanet();
            list = moonList.get(planet);
            if (list == null) {
                list = CelestialList.create();
            }
            list.add(moon);
            moonList.put(planet, list);
        }
        for (Satellite satellite : GalaxyRegistry.getSatellites()) {
            Planet celestialBody = satellite.getParentPlanet();
            list = satelliteList.get(celestialBody);
            if (list == null) {
                list = CelestialList.create();
            }
            list.add((Moon)((Object)satellite));
            satelliteList.put(celestialBody, list);
        }
        for (Planet planet : GalaxyRegistry.getPlanets()) {
            SolarSystem solarSystem = planet.getParentSolarSystem();
            list = solarSystemList.get(solarSystem);
            if (list == null) {
                list = CelestialList.create();
            }
            list.add((Moon)((Object)planet));
            solarSystemList.put(solarSystem, list);
        }
    }

    public static CelestialObject getCelestialObjectFromTranslationKey(String translationkey) {
        for (CelestialObject celestialObject : objects) {
            if (!celestialObject.getTranslationKey().equals(translationkey)) continue;
            return celestialObject;
        }
        return null;
    }

    public static CelestialBody getCelestialBodyFromDimensionID(int dimensionID) {
        for (Planet planet : planets) {
            if (planet.getDimensionID() != dimensionID) continue;
            return planet;
        }
        for (Moon moon : moons) {
            if (moon.getDimensionID() != dimensionID) continue;
            return moon;
        }
        for (Satellite satellite : satellites) {
            if (satellite.getDimensionID() != dimensionID) continue;
            return satellite;
        }
        return null;
    }

    public static List<Planet> getPlanetsForSolarSystem(SolarSystem solarSystem) {
        if (solarSystemList.get(solarSystem) == null) {
            return new ArrayList<Planet>();
        }
        return solarSystemList.get(solarSystem);
    }

    public static List<Moon> getMoonsForPlanet(Planet planet) {
        if (moonList.get(planet) == null) {
            return new ArrayList<Moon>();
        }
        return moonList.get(planet);
    }

    public static List<Satellite> getSatellitesForCelestialBody(CelestialBody celestialBody) {
        if (satelliteList.get(celestialBody) == null) {
            return new ArrayList<Satellite>();
        }
        return satelliteList.get(celestialBody);
    }

    public static CelestialBody getPlanetOrMoonFromTranslationkey(String translationKey) {
        for (Planet planet : planets) {
            if (!planet.getTranslationKey().equals(translationKey)) continue;
            return planet;
        }
        for (Moon moon : moons) {
            if (!moon.getTranslationKey().equals(translationKey)) continue;
            return moon;
        }
        return null;
    }

    public static void register(Object object) {
        RegisterEvent registerEvent;
        if (object instanceof SolarSystem) {
            SolarSystem solarSystem = (SolarSystem)object;
            registerEvent = new RegisterEvent(solarSystem, Loader.instance().activeModContainer());
            solarSystems.add(solarSystem);
            objects.add(solarSystem);
            MinecraftForge.EVENT_BUS.post((Event)registerEvent);
        }
        if (object instanceof Planet) {
            Planet planet = (Planet)object;
            registerEvent = new RegisterEvent(planet, Loader.instance().activeModContainer());
            planets.add(planet);
            objects.add(planet);
            MinecraftForge.EVENT_BUS.post((Event)registerEvent);
        }
        if (object instanceof Moon) {
            Moon moon = (Moon)object;
            registerEvent = new RegisterEvent(moon, Loader.instance().activeModContainer());
            moons.add(moon);
            objects.add(moon);
            MinecraftForge.EVENT_BUS.post((Event)registerEvent);
        }
        if (object instanceof Satellite) {
            Satellite satellite = (Satellite)object;
            registerEvent = new RegisterEvent(satellite, Loader.instance().activeModContainer());
            satellites.add(satellite);
            objects.add(satellite);
            MinecraftForge.EVENT_BUS.post((Event)registerEvent);
        }
        if (object instanceof CelestialBody) {
            CelestialBody celestialType = (CelestialBody)object;
            String unlocalizedPrefix = ((CelestialBody)object).getUnlocalizedNamePrefix();
            if (!unlocalizedPrefix.equals("unset")) {
                ((CelestialBody)object).setType(CelestialType.create(unlocalizedPrefix));
            }
            RegisterEvent registerEvent2 = new RegisterEvent(celestialType, Loader.instance().activeModContainer());
            objects.add(celestialType);
            MinecraftForge.EVENT_BUS.post((Event)registerEvent2);
        }
    }

    public static ImmutableCelestialList<CelestialObject> getAllRegisteredObjects() {
        return ImmutableCelestialList.of(objects);
    }

    public static ImmutableCelestialList<SolarSystem> getSolarSystems() {
        return ImmutableCelestialList.of(solarSystems);
    }

    public static ImmutableCelestialList<Planet> getPlanets() {
        return ImmutableCelestialList.of(planets);
    }

    public static ImmutableCelestialList<Moon> getMoons() {
        return ImmutableCelestialList.of(moons);
    }

    public static ImmutableCelestialList<Satellite> getSatellites() {
        return ImmutableCelestialList.of(satellites);
    }

    public static ImmutableCelestialList<CelestialBody> getAllReachableBodies() {
        return ImmutableCelestialList.from(planets.stream().filter(CelestialBody.filterReachable()).collect(CelestialCollector.toList()), moons.stream().filter(CelestialBody.filterReachable()).collect(CelestialCollector.toList()));
    }

    public static ImmutableCelestialList<CelestialObject> getCelestialObjectsFromMod(ModContainer modContainer) {
        return GalaxyRegistry.getCelestialObjectsFromMod(modContainer.getModId());
    }

    public static ImmutableCelestialList<CelestialObject> getCelestialObjectsFromMod(String modId) {
        return objects.stream().filter(CelestialObject.filter(modId)).collect(CelestialCollector.toList()).toUnmodifiableList();
    }

    public static String[] getAllTransltionKeys() {
        return objects.stream().map(key -> key.getTranslationKey()).collect(Collectors.toList()).toArray(new String[objects.size()]);
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.getPlanetOrMoonFromTranslationkey(String translationKey)")
    public static CelestialBody getCelestialBodyFromUnlocalizedName(String unlocalizedName) {
        return GalaxyRegistry.getPlanetOrMoonFromTranslationkey(unlocalizedName);
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.register(T object)")
    public static boolean registerSolarSystem(SolarSystem solarSystem) {
        GalaxyRegistry.register(solarSystem);
        return solarSystems.contains(solarSystem);
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.register(T object)")
    public static boolean registerPlanet(Planet planet) {
        GalaxyRegistry.register(planet);
        return planets.contains(planet);
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.register(T object)")
    public static boolean registerMoon(Moon moon) {
        GalaxyRegistry.register(moon);
        return moons.contains(moon);
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.register(T object)")
    public static boolean registerSatellite(Satellite satellite) {
        GalaxyRegistry.register(satellite);
        return satellites.contains(satellite);
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.getSolarSystems()")
    public static Map<String, SolarSystem> getRegisteredSolarSystems() {
        return solarSystems.getRegistered();
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.getPlanets()")
    public static Map<String, Planet> getRegisteredPlanets() {
        return planets.getRegistered();
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.getMoons()")
    public static Map<String, Moon> getRegisteredMoons() {
        return moons.getRegistered();
    }

    @Deprecated
    @ReplaceWith(value="GalaxyRegistry.getSatellites()")
    public static Map<String, Satellite> getRegisteredSatellites() {
        return satellites.getRegistered();
    }
}

