/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import java.util.BitSet;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import pregenerator.ChunkPregenerator;
import pregenerator.ConfigManager;
import pregenerator.base.impl.misc.PregenEvent;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.ProcessResult;
import pregenerator.impl.misc.TrackedRegionFile;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.retrogen.RetrogenHandler;
import pregenerator.impl.structure.StructureManager;

public class ChunkEntry {
    static final int[][] DATA3x3 = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};
    static final int[][] DATA2x2 = new int[][]{{1, 0}, {0, 1}, {1, 1}};
    GenerationType type;
    FilePos position;
    BitSet tasks;
    ChunkProcess process;
    int maxSize;
    long[] cache = null;
    int index = 0;
    int state = 0;

    public ChunkEntry(ChunkProcess process, Long pos, BitSet tasks, GenerationType type) {
        this.process = process;
        this.position = new FilePos(pos);
        this.tasks = tasks;
        this.type = type;
        this.state = process.memory.getState(pos);
    }

    public void init(ChunkProcess.RegionProvider provider) {
        BitSet file = provider.get(this.position.x << 5, this.position.z << 5);
        for (int i = 0; i < 1024; ++i) {
            if (!this.tasks.get(i)) continue;
            if (this.isChunkValid(i % 32, i / 32, file, false, provider) || this.state > 0) {
                ++this.maxSize;
                continue;
            }
            this.tasks.clear(i);
        }
    }

    public boolean isLighting() {
        return this.state >= 2;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public FilePos getPosition() {
        return this.position;
    }

    public long getPos() {
        this.generateCache();
        return this.cache[this.index];
    }

    public ProcessResult tick() {
        if (this.index == 0) {
            this.process.memory.setState(this.position.asLong(), (byte)1);
        }
        this.generateCache();
        return this.process(this.cache[this.index++]);
    }

    public void checkLight() {
        this.generateCache();
        int max = this.process.hasWork() ? 2 : 10;
        for (int i = 0; i < max && !this.isDone(); ++i) {
            Chunk chunk;
            long value;
            if (!this.prepaireLight(value = this.cache[this.index++]) || (chunk = this.process.getHelper().loadChunk(FilePos.getX(value), FilePos.getZ(value))) == null) continue;
            chunk.func_150809_p();
            MinecraftForge.EVENT_BUS.post((Event)new PregenEvent(chunk));
        }
    }

    public boolean isDone() {
        return this.index >= this.maxSize;
    }

    private boolean prepaireLight(long position) {
        for (int i = 0; i < DATA3x3.length; ++i) {
            if (this.prepaireChild(FilePos.add(position, DATA3x3[i][0], DATA3x3[i][1]))) continue;
            return false;
        }
        return true;
    }

    public void cleanup(boolean lighting) {
        this.index = 0;
        this.cache = null;
        this.process.unloadChunks();
        this.process.removeFiles();
        if (ConfigManager.autoClearMineshaft) {
            StructureManager manager = StructureManager.instance;
            manager.createSaveZone((this.position.x << 5) + 16, (this.position.z << 5) + 16, 16, "Mineshaft", this.process.world.field_73011_w.getDimension());
            manager.clearZoneLast(this.process.world.field_73011_w.getDimension(), "Mineshaft");
        }
        this.process.memory.setState(this.position.asLong(), (byte)(lighting ? 0 : 2));
    }

    private ProcessResult process(long position) {
        if (!this.isChunkCreated(position)) {
            if (!this.type.requiresChunkCreation()) {
                return ProcessResult.MISSING;
            }
            Chunk chunk = this.process.getHelper().createChunk(FilePos.getX(position), FilePos.getZ(position), this.type == GenerationType.BLOCK_POST, this.type.isPostGen());
            if (this.type.isPostGen()) {
                if (!this.prepaireChildren(position)) {
                    this.unloadChunk(chunk);
                    return ProcessResult.MISSING;
                }
                if (!this.populate(chunk)) {
                    chunk.func_177446_d(false);
                    this.unloadChunk(chunk);
                    return ProcessResult.CRASH;
                }
                this.unloadChunk(chunk);
                return chunk.func_177419_t() ? ProcessResult.SUCCESS : ProcessResult.MISSING;
            }
            this.unloadChunk(chunk);
            return ProcessResult.SUCCESS;
        }
        if (this.type.requiresChunkLoading() || this.type.isPostGen()) {
            if (!this.prepaireChildren(position)) {
                return ProcessResult.MISSING;
            }
            Chunk chunk = this.process.getHelper().loadChunk(FilePos.getX(position), FilePos.getZ(position));
            if (chunk == null) {
                return ProcessResult.CRASH;
            }
            if (chunk.func_177419_t()) {
                if (this.type == GenerationType.RETROGEN) {
                    boolean result = this.retrogen(chunk);
                    this.unloadChunk(chunk);
                    return result ? ProcessResult.SUCCESS : ProcessResult.MISSING;
                }
                this.unloadChunk(chunk);
                return this.type == GenerationType.POST_GEN ? ProcessResult.SUCCESS : ProcessResult.MISSING;
            }
            if (!this.populate(chunk)) {
                chunk.func_177446_d(false);
                this.unloadChunk(chunk);
                return ProcessResult.CRASH;
            }
            this.unloadChunk(chunk);
            return chunk.func_177419_t() ? ProcessResult.SUCCESS : ProcessResult.MISSING;
        }
        return ProcessResult.CRASH;
    }

    private boolean prepaireChildren(long position) {
        for (int i = 0; i < DATA2x2.length; ++i) {
            if (this.prepaireChild(FilePos.add(position, DATA2x2[i][0], DATA2x2[i][1]))) continue;
            return false;
        }
        return true;
    }

    private boolean prepaireChild(long position) {
        if (!this.process.getHelper().containsChunk(position)) {
            if (this.isChunkCreated(position)) {
                return this.process.getHelper().loadChunk(FilePos.getX(position), FilePos.getZ(position)) != null;
            }
            return this.process.getHelper().createChunk(FilePos.getX(position), FilePos.getZ(position), false, true) != null;
        }
        return true;
    }

    private boolean retrogen(Chunk chunk) {
        return RetrogenHandler.INSTANCE.retrogenChunk(chunk, this.process.getProvider().field_186029_c, (IChunkProvider)this.process.getProvider());
    }

    private boolean populate(Chunk chunk) {
        try {
            chunk.func_186030_a((IChunkProvider)this.process.getProvider(), this.process.getProvider().field_186029_c);
            return true;
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.info("Chunk Gen crash happend. No worry the Chunk gets skipped!", (Throwable)e);
            return false;
        }
    }

    private void unloadChunk(Chunk chunk) {
        if (this.process.task.isPreview()) {
            MinecraftForge.EVENT_BUS.post((Event)new PregenEvent(chunk));
        }
        this.process.getHelper().unloadChunk(chunk);
    }

    protected boolean isChunkValid(int x, int z, BitSet file, boolean spawn, ChunkProcess.RegionProvider region) {
        switch (this.type) {
            case TERRAIN_ONLY: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != ProcessResult.SUCCESS;
            }
            case FAST_CHECK_GEN: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != ProcessResult.SUCCESS;
            }
            case NORMAL_GEN: {
                return true;
            }
            case POST_GEN: {
                return this.isChunkGenerated(x, z, file, true, spawn, region) == ProcessResult.SUCCESS;
            }
            case BLOCK_POST: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != ProcessResult.SUCCESS;
            }
            case RETROGEN: {
                return this.isChunkGenerated(x, z, file, true, spawn, region) == ProcessResult.SUCCESS;
            }
        }
        return false;
    }

    protected ProcessResult isChunkGenerated(int x, int z, BitSet file, boolean full, boolean spawn, ChunkProcess.RegionProvider region) {
        int regionX = (this.position.x << 5) + x;
        int regionZ = (this.position.z << 5) + z;
        if (this.process.getProvider().func_73149_a(regionX, regionZ)) {
            return ProcessResult.SUCCESS;
        }
        if (file.isEmpty()) {
            return ProcessResult.CRASH;
        }
        if (file.get(z * 32 + x)) {
            if (!full && this.isUnfinished(regionX, regionZ, region)) {
                return ProcessResult.MISSING;
            }
            return ProcessResult.SUCCESS;
        }
        return ProcessResult.MISSING;
    }

    protected boolean isUnfinished(int x, int z, ChunkProcess.RegionProvider region) {
        for (int i = 1; i < 2; ++i) {
            if (region.getChunk(x + i, z) && region.getChunk(x - i, z) && region.getChunk(x, z + i) && region.getChunk(x, z - i)) continue;
            return true;
        }
        return false;
    }

    private boolean isChunkCreated(long pos) {
        int x = FilePos.getX(pos);
        int z = FilePos.getZ(pos);
        if (this.process.getProvider().func_73149_a(x, z)) {
            return true;
        }
        TrackedRegionFile file = this.process.getFile(x, z);
        return file != null && file.func_76709_c(x & 0x1F, z & 0x1F);
    }

    private void generateCache() {
        if (this.cache == null) {
            this.cache = new long[this.maxSize];
            int index = 0;
            for (int i = 0; i < 1024; ++i) {
                if (!this.tasks.get(i)) continue;
                this.cache[index++] = ChunkPos.func_77272_a((int)((this.position.x << 5) + i % 32), (int)((this.position.z << 5) + i / 32));
            }
        }
    }
}

