/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter;

import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pregenerator.impl.misc.DeltaTimer;
import pregenerator.impl.processor.PrepaireProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.storage.GlobalListeners;

public class DeleteProcessor {
    public static final DecimalFormat format = new DecimalFormat("#.#");
    public static DeleteProcessor INSTANCE = new DeleteProcessor();
    LinkedList<IDeletionTask> taskList = new LinkedList();
    PrepaireProgress progress = new PrepaireProgress();
    IDeletionTask task;
    Future<DeleteProcess> future;
    DeleteProcess process;
    DeltaTimer timer = new DeltaTimer();
    long start;
    int state = 0;
    int deleted = 0;
    int failed = 0;
    int ticker = 0;

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (this.task == null || this.isStopped()) {
            return;
        }
        if (this.future != null) {
            int newTime = (int)((System.currentTimeMillis() - this.start) / 1000L);
            if (this.ticker != newTime) {
                this.ticker = newTime;
                this.sendChatMessage("Prepaire Progress: " + this.progress.getCurrent() + " / " + this.progress.getMax());
            }
            if (this.future.isDone()) {
                try {
                    this.process = this.future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.sendChatMessage("Starting Task with " + this.process.getTotalWork() + " Chunks to delete");
                this.future = null;
            }
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.timer.start();
        } else {
            try {
                ThreadedFileIOBase.func_178779_a().func_75734_a();
                RegionFileCache.func_76551_a();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int max = ChunkProcessor.INSTANCE.getMaxTime();
            long deltaTime = this.timer.averageDelta();
            if (deltaTime >= (long)max) {
                return;
            }
            while (deltaTime + this.timer.getDeltaTime() < (long)max && this.process.hasWork()) {
                DeleteProcess.DeleteFile file = this.process.getEntry();
                file.update();
                this.deleted += file.getCount();
                this.sendChatMessage(this.deleted + "/" + this.process.getTotalWork() + " Chunks Deleted, Ram: " + format.format(this.getRamUsage()) + "MB");
            }
            if (!this.process.hasWork()) {
                this.onFinished();
                this.timer.reset();
            } else {
                this.timer.finishDeltaTime();
            }
        }
    }

    long getRamUsage() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return l / 1024L / 1024L;
    }

    public void startTasks(List<IDeletionTask> tasks) {
        if (this.startTask(tasks.remove(0))) {
            this.sendChatMessage("Stored the rest of the Task into the TaskList");
        }
        this.taskList.addAll(tasks);
    }

    public boolean startTask(IDeletionTask task) {
        if (this.state == 0) {
            this.state = 1;
            this.start = System.currentTimeMillis();
            this.task = task;
            this.future = task.createTask(this.progress);
            return true;
        }
        this.taskList.add(task);
        this.sendChatMessage("Stored the Task into the TaskList");
        return false;
    }

    public void interruptTask() {
        this.state = 0;
        this.process = null;
        this.task = null;
        this.cleanup();
        GlobalListeners.INSTANCE.clearListeners();
        this.taskList.clear();
    }

    public void onFinished() {
        this.sendChatMessage("Processed " + this.deleted + " Chunks. " + this.failed + " Chunks couldn't be deleted because they were loaded in " + this.formatIntoTime(this.getWorkTime()));
        this.state = 0;
        this.task = null;
        this.process = null;
        this.cleanup();
        if (this.taskList.size() > 0) {
            this.startTask(this.taskList.removeFirst());
        } else {
            GlobalListeners.INSTANCE.clearListeners();
        }
    }

    private void cleanup() {
        System.gc();
        this.deleted = 0;
        this.failed = 0;
    }

    public void sendChatMessage(String s) {
        GlobalListeners.INSTANCE.sendChatMessage(s);
    }

    public boolean isStopped() {
        return this.state == 0;
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    String formatIntoTime(long time) {
        int sec = (int)(time /= 1000L) % 60;
        int min = (int)(time /= 60L) % 60;
        int hour = (int)(time /= 60L) % 24;
        return String.format("%02d:%02d:%02d:%02d", time /= 24L, hour, min, sec);
    }

    private long getWorkTime() {
        return System.currentTimeMillis() - this.start;
    }
}

