/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepaireProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;

public class DeleteExpansionSubCommand
extends BasePregenCommand {
    public DeleteExpansionSubCommand() {
        super(7);
        this.addDescription(0, "Deletion Type: Which shape the Generation should have");
        this.addDescription(1, "X Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "Z Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(3, "Min Radius: The Radius the Deletion should start at. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(4, "Max Radius: The Radius the Deletion should end at. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(5, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addSuggestion("deleteExpansion square 0 0 100 200 -1", "Deletes a area from 100 Chunks to 200 Chunks in the Nether");
    }

    @Override
    public String getName() {
        return "deleteExpansion";
    }

    @Override
    public String getDescription() {
        return "Deletes a Area of Unloaded Chunks around an Existing Area";
    }

    @Override
    public int getRequiredParameterCount() {
        return 5;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (container.processorRunning()) {
            container.sendChatMessage("While the Pregenerator or Deleter is running you are not allowed to start Deletion Task!");
            return;
        }
        if (args.length >= 5) {
            int type = DeleteExpansionSubCommand.getGenType(args[0]);
            FilePos center = DeleteExpansionSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int minRadius = DeleteExpansionSubCommand.getNumber(DeleteExpansionSubCommand.getArg(args, 3), 0);
            int maxRadius = DeleteExpansionSubCommand.getNumber(DeleteExpansionSubCommand.getArg(args, 4), 0);
            int dimension = DeleteExpansionSubCommand.getDimension(container, DeleteExpansionSubCommand.getArg(args, 5));
            if (!DeleteExpansionSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            long ringCount = DeleteExpansionSubCommand.getRingCount(minRadius, maxRadius, type == 1);
            if (ringCount > 2500000000L) {
                container.sendChatMessage("Expansion uses more then 2.5 Billion Chunks. That is to big. Please make it smaller. (Your Expansion Amount: " + ringCount + ")");
                return;
            }
            container.onProcessStarted();
            container.getDeleter().startTask(new ExpansionTask(type, dimension, center, minRadius, maxRadius));
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_TYPE);
        }
        if (commandIndex == 1 || commandIndex == 2) {
            return DeleteExpansionSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 3 || commandIndex == 4) {
            if (args[argLayer].startsWith("b")) {
                return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_BLOCK);
            }
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_CHUNK);
        }
        if (commandIndex == 5) {
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }

    public static class ExpansionTask
    extends IDeletionTask {
        int type;
        int dim;
        FilePos center;
        int minRadius;
        int maxRadius;

        public ExpansionTask(int type, int dim, FilePos center, int minRadius, int maxRadius) {
            this.type = type;
            this.dim = dim;
            this.center = center;
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
        }

        @Override
        public Future<DeleteProcess> createTask(final PrepaireProgress progress) {
            long max = this.maxRadius * 2;
            long min = this.minRadius * 2;
            progress.setMax(max * max - min * min);
            final boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            final WorldServer world = this.getWorld(this.dim);
            final File file = world.getChunkSaveLocation();
            if (!loaded) {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return ChunkPregenerator.SERVICE.submit(new Callable<DeleteProcess>(){

                @Override
                public DeleteProcess call() throws Exception {
                    DeleteProcess process = new DeleteProcess(file, type == 1 ? ChunkCalculator.createCircleExt(center.x, center.z, minRadius, maxRadius, progress) : ChunkCalculator.createSquareExt(center.x, center.z, minRadius, maxRadius, progress));
                    if (loaded) {
                        process.setChunkHost(world);
                    }
                    return process;
                }
            });
        }
    }
}

