/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.multiblock.container.ContainerExoticContainmentController;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberController;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import nc.block.property.BlockProperties;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.recipe.BasicRecipeHandler;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.NBTHelper;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileExoticContainmentController
extends TileVacuumChamberPart
implements IVacuumChamberController<TileExoticContainmentController>,
ITileInventory {
    @Nonnull
    private final String inventoryName = "qmd.container.neutral_containment_controller";
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll((List)Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.IN, ItemSorption.OUT}));
    public BasicRecipeHandler recipe_handler = QMDRecipes.cell_filling;
    public boolean isRenderer = false;

    public TileExoticContainmentController() {
        super(CuboidalPartPositionType.WALL);
    }

    public String getLogicID() {
        return "neutral_containment";
    }

    public void onMachineAssembled(VacuumChamber controller) {
        super.onMachineAssembled((CuboidalMultiblock)controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        if (this.getMultiblock() != null) {
            ((VacuumChamber)this.getMultiblock()).updateActivity();
        }
    }

    public BasicRecipeHandler getRecipeHandler() {
        return this.recipe_handler;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    public String func_70005_c_() {
        return "qmd.container.neutral_containment_controller";
    }

    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public int func_70297_j_() {
        return 1;
    }

    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
        return nbt;
    }

    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.getRecipeHandler() == null) {
            return true;
        }
        if (stack == ItemStack.field_190927_a || slot >= this.getRecipeHandler().getItemInputSize()) {
            return false;
        }
        return this.getRecipeHandler().isValidItemInput(stack);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.getRecipeHandler() == null || this.func_94041_b(slot, stack);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public ContainerMultiblockController getContainer(EntityPlayer player) {
        return new ContainerExoticContainmentController(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isRenderer || !this.isMultiblockAssembled()) {
            return Block.field_185505_j.func_186670_a(this.field_174879_c);
        }
        return new AxisAlignedBB(((VacuumChamber)this.getMultiblock()).getMinimumCoord(), ((VacuumChamber)this.getMultiblock()).getMaximumCoord());
    }

    public double func_145835_a(double x, double y, double z) {
        double dZ;
        double dY;
        double dX;
        if (!this.isRenderer || !this.isMultiblockAssembled()) {
            dX = (double)this.field_174879_c.func_177958_n() + 0.5 - x;
            dY = (double)this.field_174879_c.func_177956_o() + 0.5 - y;
            dZ = (double)this.field_174879_c.func_177952_p() + 0.5 - z;
        } else {
            dX = (double)((VacuumChamber)this.getMultiblock()).getMiddleX() + 0.5 - x;
            dY = (double)((VacuumChamber)this.getMultiblock()).getMiddleY() + 0.5 - y;
            dZ = (double)((VacuumChamber)this.getMultiblock()).getMiddleZ() + 0.5 - z;
        }
        return dX * dX + dY * dY + dZ * dZ;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        double defaultDistSq = super.func_145833_n();
        if (!this.isRenderer || !this.isMultiblockAssembled()) {
            return defaultDistSq;
        }
        return defaultDistSq + (double)(NCMath.sq((int)((VacuumChamber)this.getMultiblock()).getExteriorLengthX()) + NCMath.sq((int)((VacuumChamber)this.getMultiblock()).getExteriorLengthY()) + NCMath.sq((int)((VacuumChamber)this.getMultiblock()).getExteriorLengthZ())) / 4.0;
    }

    public boolean isRenderer() {
        return this.isRenderer;
    }

    public void setIsRenderer(boolean isRenderer) {
        this.isRenderer = isRenderer;
    }
}

