/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.ContainmentRenderPacket;
import lach_01298.qmd.multiblock.network.VacuumChamberUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberComponent;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberController;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberBeamPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberEnergyPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberRedstonePort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberVent;
import nc.block.property.BlockProperties;
import nc.multiblock.IPacketMultiblockLogic;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import nc.util.MaterialHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class VacuumChamberLogic
extends MultiblockLogic<VacuumChamber, VacuumChamberLogic, IVacuumChamberPart>
implements IPacketMultiblockLogic<VacuumChamber, VacuumChamberLogic, IVacuumChamberPart, VacuumChamberUpdatePacket> {
    public static final int maxSize = 7;
    public static final int minSize = 5;
    private int excessCoolant = 0;
    protected boolean operational = false;

    public VacuumChamberLogic(VacuumChamber multiblock) {
        super((Multiblock)multiblock);
    }

    public VacuumChamberLogic(VacuumChamberLogic oldLogic) {
        super((MultiblockLogic)oldLogic);
    }

    public String getID() {
        return "";
    }

    protected VacuumChamber getMultiblock() {
        return (VacuumChamber)this.multiblock;
    }

    public int getMinimumInteriorLength() {
        return 5;
    }

    public int getMaximumInteriorLength() {
        return 7;
    }

    public void onMachineAssembled() {
        this.onVacuumChamberFormed();
    }

    public void onMachineRestored() {
        this.onVacuumChamberFormed();
    }

    public void onVacuumChamberFormed() {
        ObjectIterator objectIterator = this.getPartMap(IVacuumChamberController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IVacuumChamberController contr;
            this.getMultiblock().controller = contr = (IVacuumChamberController)objectIterator.next();
        }
        this.getMultiblock().energyStorage.setStorageCapacity((long)(QMDConfig.vacuum_chamber_base_energy_capacity * this.getCapacityMultiplier()));
        this.getMultiblock().energyStorage.setMaxTransfer(QMDConfig.vacuum_chamber_base_energy_capacity * this.getCapacityMultiplier());
        this.getMultiblock().heatBuffer.setHeatCapacity((long)(QMDConfig.accelerator_base_heat_capacity * this.getCapacityMultiplier()));
        this.getMultiblock().ambientTemp = 273 + (int)(this.getWorld().func_180494_b(this.getMultiblock().getMiddleCoord()).func_180626_a(this.getMultiblock().getMiddleCoord()) * 20.0f);
        this.getMultiblock().tanks.get(0).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * this.getCapacityMultiplier());
        this.getMultiblock().tanks.get(1).setCapacity(QMDConfig.accelerator_base_output_tank_capacity * this.getCapacityMultiplier());
        if (!this.getMultiblock().cold) {
            HeatBuffer heatBuffer = this.getMultiblock().heatBuffer;
            long l = (long)this.getMultiblock().ambientTemp * this.getMultiblock().heatBuffer.getHeatCapacity();
            this.getMultiblock();
            heatBuffer.setHeatStored(l / 400L);
        }
        this.getMultiblock().cold = true;
        this.getMultiblock().currentHeating = 0L;
        if (!this.getWorld().field_72995_K) {
            int energy = 0;
            long heat = 0L;
            int maxTemp = 400;
            for (IVacuumChamberComponent part : this.getMultiblock().getPartMap(IVacuumChamberComponent.class).values()) {
                heat += (long)part.getHeating();
                energy += part.getPower();
                if (part.getMaxOperatingTemp() >= maxTemp) continue;
                maxTemp = part.getMaxOperatingTemp();
            }
            this.getMultiblock().requiredEnergy = energy;
            this.getMultiblock().heating = heat;
            this.getMultiblock().maxOperatingTemp = maxTemp;
            this.getMultiblock().updateActivity();
        }
    }

    public int getCapacityMultiplier() {
        return this.getMultiblock().getExteriorVolume();
    }

    public void onMachinePaused() {
        this.onContainmentBroken();
    }

    public void onMachineDisassembled() {
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            port.setRedstoneLevel(0);
        }
        this.operational = false;
        this.onContainmentBroken();
    }

    public void onContainmentBroken() {
        if (this.getMultiblock().controller != null) {
            this.getMultiblock().controller.setActivity(false);
        }
    }

    public boolean isMachineWhole() {
        boolean inlet = false;
        boolean outlet = false;
        for (TileVacuumChamberVent vent : this.getPartMap(TileVacuumChamberVent.class).values()) {
            if (!((Boolean)vent.getBlockState(vent.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                inlet = true;
                continue;
            }
            outlet = true;
        }
        if (!inlet) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.no_inlet", null, new Object[0]);
            return false;
        }
        if (!outlet) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.no_outlet", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileVacuumChamberEnergyPort.class).size() < 1) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return true;
    }

    public List<Pair<Class<? extends IVacuumChamberPart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends IVacuumChamberPart>, String>>();
    }

    public void onAssimilate(VacuumChamber assimilated) {
        if (assimilated instanceof VacuumChamber) {
            VacuumChamber assimilatedAccelerator = assimilated;
            this.getMultiblock().heatBuffer.mergeHeatBuffers(assimilatedAccelerator.heatBuffer);
            this.getMultiblock().energyStorage.mergeEnergyStorage(assimilatedAccelerator.energyStorage);
        }
        if (this.getMultiblock().isAssembled()) {
            this.onVacuumChamberFormed();
        } else {
            this.onContainmentBroken();
        }
    }

    public void onAssimilated(VacuumChamber assimilator) {
    }

    public boolean onUpdateServer() {
        this.externalHeating();
        this.refreshFluidRecipe();
        if (this.canProcessFluidInputs()) {
            this.produceFluidProducts();
        }
        return true;
    }

    protected void pull() {
        for (TileVacuumChamberBeamPort port : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            if (port.getIOType() != EnumTypes.IOType.INPUT) continue;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                TileEntity tile = port.func_145831_w().func_175625_s(port.func_174877_v().func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                this.getMultiblock().beams.get(port.getIONumber()).setParticleStack(otherStorage.extractParticle(face.func_176734_d()));
            }
        }
    }

    protected void push() {
        for (TileVacuumChamberBeamPort port : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                TileEntity tile = port.func_145831_w().func_175625_s(port.func_174877_v().func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                otherStorage.reciveParticle(face.func_176734_d(), this.getMultiblock().beams.get(port.getIONumber()).getParticleStack());
            }
        }
    }

    @Nonnull
    public List<Tank> getVentTanks(List<Tank> backupTanks) {
        return this.getMultiblock().isAssembled() ? this.getMultiblock().tanks.subList(0, 2) : backupTanks;
    }

    protected void externalHeating() {
        this.getMultiblock().heatBuffer.addHeat(this.getMultiblock().getExternalHeating(), false);
        this.getMultiblock().currentHeating += this.getMultiblock().getExternalHeating();
    }

    protected void internalHeating() {
        this.getMultiblock().heatBuffer.addHeat(this.getMultiblock().heating, false);
        this.getMultiblock().currentHeating += this.getMultiblock().heating;
    }

    public boolean isMultiblockOn() {
        return this.operational;
    }

    protected void refreshFluidRecipe() {
        this.getMultiblock().coolingRecipeInfo = QMDRecipes.accelerator_cooling.getRecipeInfoFromInputs(new ArrayList(), this.getMultiblock().tanks.subList(0, 1));
        if (this.getMultiblock().coolingRecipeInfo != null) {
            this.getMultiblock().maxCoolantIn = 1000 / ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (int)(2L * this.getMultiblock().heating * (long)((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getMaxStackSize(0));
            this.getMultiblock().maxCoolantOut = 1000 / ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (int)(2L * this.getMultiblock().heating * (long)((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0)).getMaxStackSize(0));
        }
    }

    protected boolean canProcessFluidInputs() {
        if (this.getMultiblock().coolingRecipeInfo == null) {
            return false;
        }
        if (this.getMultiblock().getTemperature() <= ((FluidStack)((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getStack()).getFluid().getTemperature()) {
            return false;
        }
        IFluidIngredient fluidProduct = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        if (fluidProduct.getMaxStackSize(0) <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        if (!this.getMultiblock().tanks.get(1).isEmpty()) {
            if (!this.getMultiblock().tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getMultiblock().tanks.get(1).getFluidAmount() + (this.getMultiblock().maxCoolantIn / 1000 + 1) * fluidProduct.getNextStack((int)0).amount > this.getMultiblock().tanks.get(1).getCapacity()) {
                return false;
            }
            if (this.getMultiblock().heatBuffer.getHeatStored() < 1L) {
                return false;
            }
        }
        return true;
    }

    private void produceFluidProducts() {
        int uBConsumed = this.getMultiblock().maxCoolantIn;
        if (uBConsumed > this.getMultiblock().tanks.get(0).getFluidAmount() * 1000) {
            uBConsumed = this.getMultiblock().tanks.get(0).getFluidAmount() * 1000;
        }
        if ((long)uBConsumed > this.getMultiblock().heatBuffer.getHeatStored()) {
            uBConsumed = (int)this.getMultiblock().heatBuffer.getHeatStored();
        }
        int mBConsumed = 0;
        if (uBConsumed % 1000 != 0) {
            mBConsumed = (uBConsumed + (1000 - uBConsumed % 1000)) / 1000;
            this.excessCoolant += 1000 - uBConsumed % 1000;
        } else {
            mBConsumed = uBConsumed / 1000;
        }
        if (this.excessCoolant > 1000) {
            mBConsumed -= this.excessCoolant / 1000;
            this.excessCoolant %= 1000;
        }
        this.getMultiblock().tanks.get(0).changeFluidAmount(-mBConsumed);
        if (this.getMultiblock().tanks.get(0).getFluidAmount() <= 0) {
            this.getMultiblock().tanks.get(0).setFluidStored(null);
        }
        this.getMultiblock().heatBuffer.changeHeatStored((long)(-mBConsumed * ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB()));
        IFluidIngredient fluidProduct = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        int producedCoolant = mBConsumed * fluidProduct.getNextStack((int)0).amount;
        if (this.getMultiblock().tanks.get(1).isEmpty()) {
            this.getMultiblock().tanks.get(1).changeFluidStored(fluidProduct.getNextStack(0).getFluid(), producedCoolant);
        } else {
            this.getMultiblock().tanks.get(1).changeFluidAmount(producedCoolant);
        }
    }

    protected boolean isRedstonePowered() {
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || !port.checkIsRedstonePowered(this.getWorld(), port.func_174877_v())) continue;
            return true;
        }
        return false;
    }

    protected int getRedstoneLevel() {
        int level = 0;
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || this.getWorld().func_175687_A(port.func_174877_v()) <= level) continue;
            level = this.getWorld().func_175687_A(port.func_174877_v());
        }
        return level;
    }

    protected void updateRedstone() {
    }

    public void onUpdateClient() {
    }

    public void writeToLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        data.func_74768_a("excessCoolant", this.excessCoolant);
    }

    public void readFromLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.excessCoolant = data.func_74762_e("excessCoolant");
    }

    public VacuumChamberUpdatePacket getMultiblockUpdatePacket() {
        return null;
    }

    public void onMultiblockUpdatePacket(VacuumChamberUpdatePacket message) {
    }

    public ContainmentRenderPacket getRenderPacket() {
        return null;
    }

    public void onRenderPacket(ContainmentRenderPacket message) {
    }

    public void clearAllMaterial() {
        for (Tank tank : this.getMultiblock().tanks) {
            tank.setFluidStored(null);
        }
    }

    public boolean isBlockGoodForInterior(World world, BlockPos pos) {
        if (MaterialHelper.isReplaceable((Material)world.func_180495_p(pos).func_185904_a()) || world.func_175625_s(pos) instanceof TileVacuumChamberPart) {
            return true;
        }
        return this.getMultiblock().standardLastError(pos);
    }
}

