/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipe.ingredient;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientOr;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import net.minecraftforge.fml.common.Optional;

public class ParticleArrayIngredient
implements IParticleIngredient {
    public List<IParticleIngredient> ingredientList;
    public List<ParticleStack> cachedStackList = new ArrayList<ParticleStack>();

    public ParticleArrayIngredient(IParticleIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public ParticleArrayIngredient(List<IParticleIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add((ParticleStack)input.getStack()));
    }

    public ParticleStack getStack() {
        return this.isValid() ? this.cachedStackList.get(0).copy() : null;
    }

    public List<ParticleStack> getInputStackList() {
        ArrayList<ParticleStack> stacks = new ArrayList<ParticleStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((ParticleStack)obj)));
        return stacks;
    }

    public List<ParticleStack> getOutputStackList() {
        return this.isValid() ? Lists.newArrayList((Object[])new ParticleStack[]{this.getStack()}) : new ArrayList();
    }

    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredientList.get(ingredientNumber).getMaxStackSize(0);
    }

    public void setMaxStackSize(int stackSize) {
        for (IParticleIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (ParticleStack stack : this.cachedStackList) {
            stack.setAmount(stackSize);
        }
    }

    public String getIngredientName() {
        return this.getIngredientNamesConcat();
    }

    public String getIngredientNamesConcat() {
        String names = "";
        for (IParticleIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    public String getIngredientRecipeString() {
        String names = "";
        for (IParticleIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    public IntList getFactors() {
        IntArrayList list = new IntArrayList();
        for (IParticleIngredient ingredient : this.ingredientList) {
            list.addAll(ingredient.getFactors());
        }
        return new IntArrayList((IntList)list);
    }

    @Override
    public IParticleIngredient getFactoredIngredient(int factor) {
        ArrayList<IParticleIngredient> list = new ArrayList<IParticleIngredient>();
        for (IParticleIngredient ingredient : this.ingredientList) {
            list.add(ingredient.getFactoredIngredient(factor));
        }
        return new ParticleArrayIngredient(list);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (!this.ingredientList.get(i).match(object, sorption).matches()) continue;
            return new IngredientMatchResult(true, i);
        }
        return IngredientMatchResult.FAIL;
    }

    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty();
    }

    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        IIngredient[] array = new IIngredient[this.ingredientList.size()];
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            array[i] = this.ingredientList.get(i).ct();
        }
        return new IngredientOr(array);
    }

    @Override
    public IngredientMatchResult matchWithData(Object object, IngredientSorption type, List extras) {
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (!this.ingredientList.get(i).matchWithData(object, type, extras).matches()) continue;
            return new IngredientMatchResult(true, i);
        }
        return IngredientMatchResult.FAIL;
    }
}

