/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipe;

import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.particle.ParticleStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;

public class QMDRecipeTupleGenerator {
    public static final QMDRecipeTupleGenerator INSTANCE = new QMDRecipeTupleGenerator();
    private boolean itemEnd;
    private boolean fluidEnd;
    private boolean particleEnd;

    private QMDRecipeTupleGenerator() {
    }

    public void generateMaterialListTuples(List<Triple<List<ItemStack>, List<FluidStack>, List<ParticleStack>>> tuples, int[] maxNumbers, int[] inputNumbers, List<List<ItemStack>> itemInputLists, List<List<FluidStack>> fluidInputLists, List<List<ParticleStack>> particleInputLists) {
        do {
            this.generateNextMaterialListTuple(tuples, maxNumbers, inputNumbers, itemInputLists, fluidInputLists, particleInputLists);
        } while (!this.itemEnd || !this.fluidEnd || !this.particleEnd);
    }

    private void generateNextMaterialListTuple(List<Triple<List<ItemStack>, List<FluidStack>, List<ParticleStack>>> tuples, int[] maxNumbers, int[] inputNumbers, List<List<ItemStack>> itemInputLists, List<List<FluidStack>> fluidInputLists, List<List<ParticleStack>> particleInputLists) {
        block18: {
            int i;
            int particleInputSize;
            int fluidInputSize;
            int itemInputSize;
            block21: {
                block20: {
                    block19: {
                        itemInputSize = itemInputLists.size();
                        fluidInputSize = fluidInputLists.size();
                        particleInputSize = particleInputLists.size();
                        ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
                        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
                        ArrayList<ParticleStack> particleInputs = new ArrayList<ParticleStack>();
                        for (i = 0; i < itemInputSize; ++i) {
                            itemInputs.add(itemInputLists.get(i).get(inputNumbers[i]));
                        }
                        for (i = 0; i < fluidInputSize; ++i) {
                            fluidInputs.add(fluidInputLists.get(i).get(inputNumbers[i + itemInputSize]));
                        }
                        for (i = 0; i < particleInputSize; ++i) {
                            particleInputs.add(particleInputLists.get(i).get(inputNumbers[i + itemInputSize + fluidInputSize]));
                        }
                        tuples.add((Triple<List<ItemStack>, List<FluidStack>, List<ParticleStack>>)Triple.of(itemInputs, fluidInputs, particleInputs));
                        this.itemEnd = false;
                        if (itemInputSize == 0) {
                            this.itemEnd = true;
                        } else {
                            for (i = 0; i < itemInputSize; ++i) {
                                if (inputNumbers[i] < maxNumbers[i]) {
                                    int n = i;
                                    inputNumbers[n] = inputNumbers[n] + 1;
                                    break;
                                }
                                inputNumbers[i] = 0;
                                if (i != itemInputSize - 1) continue;
                                this.itemEnd = true;
                            }
                        }
                        this.fluidEnd = false;
                        if (fluidInputSize == 0) {
                            this.fluidEnd = true;
                        } else if (this.itemEnd) {
                            for (i = 0; i < fluidInputSize; ++i) {
                                if (inputNumbers[i + itemInputSize] < maxNumbers[i + itemInputSize]) {
                                    int n = i + itemInputSize;
                                    inputNumbers[n] = inputNumbers[n] + 1;
                                    break;
                                }
                                inputNumbers[i + itemInputSize] = 0;
                                if (i != fluidInputSize - 1) continue;
                                this.fluidEnd = true;
                            }
                        }
                        this.particleEnd = false;
                        if (particleInputSize != 0) break block19;
                        this.particleEnd = true;
                        break block18;
                    }
                    if (!this.itemEnd || !this.fluidEnd) break block20;
                    for (i = 0; i < particleInputSize; ++i) {
                        if (inputNumbers[i + itemInputSize + fluidInputSize] < maxNumbers[i + itemInputSize + fluidInputSize]) {
                            int n = i + itemInputSize + fluidInputSize;
                            inputNumbers[n] = inputNumbers[n] + 1;
                            break block18;
                        }
                        inputNumbers[i + itemInputSize] = 0;
                        if (i != particleInputSize - 1) continue;
                        this.particleEnd = true;
                    }
                    break block18;
                }
                if (!this.itemEnd || this.fluidEnd) break block21;
                for (i = 0; i < particleInputSize; ++i) {
                    if (inputNumbers[i + itemInputSize + fluidInputSize] < maxNumbers[i + itemInputSize + fluidInputSize]) {
                        int n = i + itemInputSize + fluidInputSize;
                        inputNumbers[n] = inputNumbers[n] + 1;
                        break block18;
                    }
                    inputNumbers[i + itemInputSize + fluidInputSize] = 0;
                    if (i != particleInputSize - 1) continue;
                    this.particleEnd = true;
                }
                break block18;
            }
            if (this.itemEnd || !this.fluidEnd) break block18;
            for (i = 0; i < particleInputSize; ++i) {
                if (inputNumbers[i + itemInputSize + fluidInputSize] < maxNumbers[i + itemInputSize + fluidInputSize]) {
                    int n = i + itemInputSize + fluidInputSize;
                    inputNumbers[n] = inputNumbers[n] + 1;
                    break;
                }
                inputNumbers[i + itemInputSize + fluidInputSize] = 0;
                if (i != particleInputSize - 1) continue;
                this.particleEnd = true;
            }
        }
    }
}

