/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.multiblock.IMultiBlockTank;
import lach_01298.qmd.multiblock.IQMDPacketMultiblock;
import lach_01298.qmd.multiblock.network.ParticleChamberUpdatePacket;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.particleChamber.ParticleChamberLogic;
import lach_01298.qmd.particleChamber.tile.IParticleChamberController;
import lach_01298.qmd.particleChamber.tile.IParticleChamberPart;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.tile.ITileLogicMultiblockPart;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ParticleChamber
extends CuboidalMultiblock<ParticleChamber, IParticleChamberPart>
implements ILogicMultiblock<ParticleChamber, ParticleChamberLogic, IParticleChamberPart>,
IQMDPacketMultiblock<ParticleChamber, IParticleChamberPart, ParticleChamberUpdatePacket>,
IMultiBlockTank {
    public static final ObjectSet<Class<? extends IParticleChamberPart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends ParticleChamberLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    @Nonnull
    protected ParticleChamberLogic logic = new ParticleChamberLogic(this);
    @Nonnull
    protected NBTTagCompound cachedData = new NBTTagCompound();
    protected final Multiblock.PartSuperMap<ParticleChamber, IParticleChamberPart> partSuperMap = new Multiblock.PartSuperMap();
    public boolean refreshFlag = true;
    public boolean isChamberOn = false;
    public int requiredEnergy;
    public double efficiency = 1.0;
    public IParticleChamberController controller;
    public final EnergyStorage energyStorage = new EnergyStorage((long)QMDConfig.particle_chamber_base_energy_capacity);
    public List<ParticleStorageAccelerator> beams = Lists.newArrayList((Object[])new ParticleStorageAccelerator[]{new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator()});
    public List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(QMDConfig.particle_chamber_input_tank_capacity, null), new Tank(QMDConfig.particle_chamber_output_tank_capacity, null)});
    protected final Set<EntityPlayer> updatePacketListeners;

    public ParticleChamber(World world) {
        super(world, ParticleChamber.class, IParticleChamberPart.class);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
        this.updatePacketListeners = new ObjectOpenHashSet();
    }

    public ParticleChamberLogic getLogic() {
        return this.logic;
    }

    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (ParticleChamberLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
    }

    public Multiblock.PartSuperMap<ParticleChamber, IParticleChamberPart> getPartSuperMap() {
        return this.partSuperMap;
    }

    protected int getMinimumInteriorLength() {
        return this.logic.getMinimumInteriorLength();
    }

    protected int getMaximumInteriorLength() {
        return this.logic.getMaximumInteriorLength();
    }

    public void onAttachedPartWithMultiblockData(IParticleChamberPart part, NBTTagCompound data) {
        this.logic.onAttachedPartWithMultiblockData((ITileLogicMultiblockPart)part, data);
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    protected void onBlockAdded(IParticleChamberPart newPart) {
        this.onPartAdded((ITileMultiblockPart)newPart);
        this.logic.onBlockAdded((ITileLogicMultiblockPart)newPart);
    }

    protected void onBlockRemoved(IParticleChamberPart oldPart) {
        this.onPartRemoved((ITileMultiblockPart)oldPart);
        this.logic.onBlockRemoved((ITileLogicMultiblockPart)oldPart);
    }

    protected void onMachineAssembled() {
        this.logic.onMachineAssembled();
    }

    protected void onMachineRestored() {
        this.logic.onMachineRestored();
    }

    protected void onMachinePaused() {
        this.logic.onMachinePaused();
    }

    protected void onMachineDisassembled() {
        this.logic.onMachineDisassembled();
    }

    protected void onAssimilate(ParticleChamber assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    protected void onAssimilated(ParticleChamber assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    protected boolean isMachineWhole() {
        return this.setLogic((Multiblock)this) && super.isMachineWhole() && this.logic.isMachineWhole();
    }

    public boolean setLogic(Multiblock multiblock) {
        if (this.getPartMap(IParticleChamberController.class).isEmpty()) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(IParticleChamberController.class).size() > 1) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        ObjectIterator objectIterator = this.getPartMap(IParticleChamberController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IParticleChamberController contr;
            this.controller = contr = (IParticleChamberController)objectIterator.next();
        }
        this.setLogic(this.controller.getLogicID());
        return true;
    }

    public void resetStats() {
        this.logic.refreshChamberStats();
    }

    protected boolean updateServer() {
        boolean flag = this.refreshFlag;
        if (this.refreshFlag) {
            this.logic.refreshChamber();
        }
        this.updateActivity();
        if (this.logic.onUpdateServer()) {
            flag = true;
        }
        if (this.controller != null) {
            this.sendMultiblockUpdatePacketToListeners();
        }
        return flag;
    }

    public void updateActivity() {
        boolean wasChamberOn = this.isChamberOn;
        boolean bl = this.isChamberOn = this.isAssembled() && this.logic.isChamberOn();
        if (this.isChamberOn != wasChamberOn && this.controller != null) {
            this.controller.setActivity(this.isChamberOn);
            this.sendMultiblockUpdatePacketToAll();
        }
    }

    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.energyStorage.writeToNBT(data, "energyStorage");
        this.writeTanks(this.tanks, data, "tanks");
        this.writeBeams(this.beams, data);
        data.func_74757_a("isChamberOn", this.isChamberOn);
        data.func_74768_a("requiredEnergy", this.requiredEnergy);
        data.func_74780_a("efficiency", this.efficiency);
        this.writeLogicNBT(data, syncReason);
    }

    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.energyStorage.readFromNBT(data, "energyStorage");
        this.readTanks(this.tanks, data, "tanks");
        this.readBeams(this.beams, data);
        this.isChamberOn = data.func_74767_n("isChamberOn");
        this.requiredEnergy = data.func_74762_e("requiredEnergy");
        this.efficiency = data.func_74769_h("efficiency");
        this.readLogicNBT(data, syncReason);
    }

    public Set<EntityPlayer> getMultiblockUpdatePacketListeners() {
        return this.updatePacketListeners;
    }

    public ParticleChamberUpdatePacket getMultiblockUpdatePacket() {
        return this.logic.getMultiblockUpdatePacket();
    }

    public void onMultiblockUpdatePacket(ParticleChamberUpdatePacket message) {
        this.energyStorage.setStorageCapacity((long)message.energyStorage.getMaxEnergyStored());
        this.energyStorage.setEnergyStored((long)message.energyStorage.getEnergyStored());
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).readInfo(message.tanksInfo.get(i));
        }
        this.beams = message.beams;
        this.isChamberOn = message.isChamberOn;
        this.efficiency = message.efficiency;
        this.requiredEnergy = message.requiredEnergy;
        this.logic.onMultiblockUpdatePacket(message);
    }

    public NBTTagCompound writeBeams(List<ParticleStorageAccelerator> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).writeToNBT(data, i);
        }
        return data;
    }

    public void readBeams(List<ParticleStorageAccelerator> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).readFromNBT(data, i);
        }
        beams.get(0).readFromNBT(data);
    }

    public boolean toggleSetting(BlockPos pos, int ioNumber) {
        return this.logic.toggleSetting(pos, ioNumber);
    }

    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return this.logic.isBlockGoodForInterior(world, pos);
    }

    @Override
    public List<Tank> getTanks() {
        return this.tanks;
    }
}

