/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.recipe;

import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.config.QMDConfig;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.JEIMachineRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class QMDRecipeWrapper {

    public static class VacuumChamberHeating
    extends JEIBasicRecipeWrapper<VacuumChamberHeating> {
        private static int arrowX = 90;
        private static int arrowY = 0;
        private static int arrowWidth = 36;
        private static int arrowHeight = 15;
        private static int arrowPosX = 27;
        private static int arrowPosY = 6;
        private static int backX = 0;
        private static int backY = 0;
        public final IDrawable arrow;
        public final int arrowDrawPosX;
        public final int arrowDrawPosY;
        private static final String HEAT_PER_MB = Lang.localise((String)"jei.nuclearcraft.fission_heating_heat_per_mb");

        public VacuumChamberHeating(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY);
            ResourceLocation location = new ResourceLocation("qmd:textures/gui/jei/accelerator_cooling.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
            this.arrow = this.staticArrow() ? arrowDrawable : guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.LEFT, false);
            this.arrowDrawPosX = arrowPosX - backX;
            this.arrowDrawPosY = arrowPosY - backY;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }

        protected int getProgressArrowTime() {
            return this.getFissionHeatingHeatPerInputMB() / 100;
        }

        protected int getFissionHeatingHeatPerInputMB() {
            if (this.recipe == null) {
                return 64;
            }
            return this.recipe.getFissionHeatingHeatPerInputMB();
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.YELLOW + HEAT_PER_MB + " " + TextFormatting.WHITE + this.getFissionHeatingHeatPerInputMB() + " H/mB");
            }
            return tooltip;
        }
    }

    public static class CellFilling
    extends JEIMachineRecipeWrapper<CellFilling> {
        public CellFilling(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        }

        protected double getBaseProcessTime() {
            return 0.0;
        }

        protected double getBaseProcessPower() {
            return 0.0;
        }
    }

    public static class AcceleratorCooling
    extends JEIBasicRecipeWrapper<AcceleratorCooling> {
        private static int arrowX = 90;
        private static int arrowY = 0;
        private static int arrowWidth = 36;
        private static int arrowHeight = 15;
        private static int arrowPosX = 27;
        private static int arrowPosY = 6;
        private static int backX = 0;
        private static int backY = 0;
        public final IDrawable arrow;
        public final int arrowDrawPosX;
        public final int arrowDrawPosY;
        private static final String HEAT_PER_MB = Lang.localise((String)"jei.nuclearcraft.fission_heating_heat_per_mb");

        public AcceleratorCooling(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY);
            ResourceLocation location = new ResourceLocation("qmd:textures/gui/jei/accelerator_cooling.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
            this.arrow = this.staticArrow() ? arrowDrawable : guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.LEFT, false);
            this.arrowDrawPosX = arrowPosX - backX;
            this.arrowDrawPosY = arrowPosY - backY;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }

        protected int getProgressArrowTime() {
            return this.getFissionHeatingHeatPerInputMB() / 100;
        }

        protected int getFissionHeatingHeatPerInputMB() {
            if (this.recipe == null) {
                return 64;
            }
            return this.recipe.getFissionHeatingHeatPerInputMB();
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.YELLOW + HEAT_PER_MB + " " + TextFormatting.WHITE + this.getFissionHeatingHeatPerInputMB() + " H/mB");
            }
            return tooltip;
        }
    }

    public static class IrradiatorFuel
    extends JEIBasicRecipeWrapper<IrradiatorFuel> {
        private static int arrowX = 176;
        private static int arrowY = 10;
        private static int arrowWidth = 40;
        private static int arrowHeight = 19;
        private static int arrowPosX = 68;
        private static int arrowPosY = 38;
        private static int backX = 62;
        private static int backY = 5;
        public final IDrawable arrow;
        public final int arrowDrawPosX;
        public final int arrowDrawPosY;
        private static final String SPEED = Lang.localise((String)"gui.nc.container.speed_multiplier");

        public IrradiatorFuel(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY);
            ResourceLocation location = new ResourceLocation("qmd:textures/gui/irradiator.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
            this.arrow = this.staticArrow() ? arrowDrawable : guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.TOP, false);
            this.arrowDrawPosX = arrowPosX - backX;
            this.arrowDrawPosY = arrowPosY - backY;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }

        protected int getProgressArrowTime() {
            return (int)(100.0 / this.getIrradatorSpeed());
        }

        protected double getIrradatorSpeed() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getBaseProcessTime(1.0);
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 5 && mouseY >= 30 && mouseX < 45 && mouseY < 50) {
                tooltip.add(TextFormatting.AQUA + SPEED + " " + TextFormatting.WHITE + "x" + this.getIrradatorSpeed());
            }
            return tooltip;
        }
    }

    public static class Irradiator
    extends JEIMachineRecipeWrapper<Irradiator> {
        private static int arrowX = 176;
        private static int arrowY = 0;
        private static int arrowWidth = 52;
        private static int arrowHeight = 10;
        private static int arrowPosX = 62;
        private static int arrowPosY = 57;
        private static int backX = 41;
        private static int backY = 38;
        public final IDrawable arrow;
        public final int arrowDrawPosX;
        public final int arrowDrawPosY;

        public Irradiator(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY, 62, 57, 52, 10);
            ResourceLocation location = new ResourceLocation("qmd:textures/gui/irradiator.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
            this.arrow = this.staticArrow() ? arrowDrawable : guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.LEFT, false);
            this.arrowDrawPosX = arrowPosX - backX;
            this.arrowDrawPosY = arrowPosY - backY;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }

        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return QMDConfig.processor_time[0];
            }
            return this.recipe.getBaseProcessTime((double)QMDConfig.processor_time[0]);
        }

        protected double getBaseProcessPower() {
            return 0.0;
        }
    }

    public static class OreLeacher
    extends JEIMachineRecipeWrapper<OreLeacher> {
        private static int arrowX = 176;
        private static int arrowY = 12;
        private static int arrowWidth = 16;
        private static int arrowHeight = 8;
        private static int arrowPosX = 94;
        private static int arrowPosY = 46;
        private static int backX = 30;
        private static int backY = 7;
        public final IDrawable arrow;
        public final int arrowDrawPosX;
        public final int arrowDrawPosY;

        public OreLeacher(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY, 94, 42, 16, 16);
            ResourceLocation location = new ResourceLocation("qmd:textures/gui/ore_leacher.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
            this.arrow = this.staticArrow() ? arrowDrawable : guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.LEFT, false);
            this.arrowDrawPosX = arrowPosX - backX;
            this.arrowDrawPosY = arrowPosY - backY;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }

        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return QMDConfig.processor_time[0];
            }
            return this.recipe.getBaseProcessTime((double)QMDConfig.processor_time[0]);
        }

        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return QMDConfig.processor_power[0];
            }
            return this.recipe.getBaseProcessPower((double)QMDConfig.processor_power[0]);
        }
    }
}

