/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityGammaFlash;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.item.QMDItems;
import lach_01298.qmd.util.Units;
import nc.capability.radiation.entity.IEntityRads;
import nc.item.NCItem;
import nc.radiation.RadiationHelper;
import nc.util.DamageSources;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.StackHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCell
extends NCItem
implements IItemParticleAmount {
    public ItemCell() {
        super(new String[0]);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            for (int i = 1; i < MaterialTypes.CellType.values().length; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                IItemParticleAmount.fullItem(stack);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public int getItemCapacity(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            switch (stack.func_77960_j()) {
                case 0: {
                    return MaterialTypes.CellType.EMPTY.getCapacity();
                }
                case 1: {
                    return MaterialTypes.CellType.ANTIHYDROGEN.getCapacity();
                }
                case 2: {
                    return MaterialTypes.CellType.ANTIDEUTERIUM.getCapacity();
                }
                case 3: {
                    return MaterialTypes.CellType.ANTITRITIUM.getCapacity();
                }
                case 4: {
                    return MaterialTypes.CellType.ANTIHELIUM3.getCapacity();
                }
                case 5: {
                    return MaterialTypes.CellType.ANTIHELIUM.getCapacity();
                }
                case 6: {
                    return MaterialTypes.CellType.POSITRONIUM.getCapacity();
                }
                case 7: {
                    return MaterialTypes.CellType.MUONIUM.getCapacity();
                }
                case 8: {
                    return MaterialTypes.CellType.TAUONIUM.getCapacity();
                }
                case 9: {
                    return MaterialTypes.CellType.GLUEBALLS.getCapacity();
                }
            }
        }
        return 0;
    }

    public String func_77667_c(ItemStack stack) {
        for (int i = 0; i < MaterialTypes.CellType.values().length; ++i) {
            if (StackHelper.getMetadata((ItemStack)stack) != i) continue;
            return this.func_77658_a() + "." + MaterialTypes.CellType.values()[i].func_176610_l();
        }
        return this.func_77658_a() + "." + MaterialTypes.CellType.values()[0].func_176610_l();
    }

    @Override
    public ItemStack fill(ItemStack stack, int amount, String type) {
        if (stack.func_77960_j() == MaterialTypes.CellType.EMPTY.getID()) {
            int meta = 0;
            for (MaterialTypes.CellType cellType : MaterialTypes.CellType.values()) {
                if (!cellType.func_176610_l().equals(type)) continue;
                meta = cellType.getID();
            }
            ItemStack newStack = new ItemStack(QMDItems.cell, 1, meta);
            this.setAmountStored(newStack, amount);
            return newStack;
        }
        if (this.getAmountStored(stack) + amount <= this.getItemCapacity(stack)) {
            this.setAmountStored(stack, this.getAmountStored(stack) + amount);
        }
        return stack;
    }

    @Override
    public ItemStack getEmptyItem() {
        return new ItemStack(QMDItems.cell, 1, MaterialTypes.CellType.EMPTY.getID());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getAmountStored(stack) / (double)this.getItemCapacity(stack)), (double)0.0, (double)1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getAmountStored(stack) > 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.DARK_GREEN, (String)Lang.localise((String)"info.qmd.item.amount", (Object[])new Object[]{Units.getSIFormat(this.getAmountStored(stack), "pu"), Units.getSIFormat(this.getItemCapacity(stack), "pu")}));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack stack;
        if (QMDConfig.cell_lifetime > 0 && (stack = entityItem.func_92059_d()).func_77960_j() != 0 && (entityItem.field_70173_aa > QMDConfig.cell_lifetime || entityItem.func_180799_ab() || entityItem.func_70027_ad() || entityItem.field_70128_L)) {
            this.explode(entityItem.field_70170_p, entityItem.func_180425_c(), stack);
            stack.func_190918_g(stack.func_190916_E());
        }
        return false;
    }

    public void explode(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K) {
            double size = 1.0;
            switch (stack.func_77960_j()) {
                case 1: {
                    size = 1.0;
                    break;
                }
                case 2: {
                    size = 2.0;
                    break;
                }
                case 3: 
                case 4: {
                    size = 3.0;
                    break;
                }
                case 5: {
                    size = 4.0;
                    break;
                }
                case 6: {
                    size = 5.4E-4;
                    break;
                }
                case 7: {
                    size = 0.11;
                    break;
                }
                case 8: {
                    size = 1.9;
                    break;
                }
                case 9: {
                    size = 1.8;
                }
            }
            if (IItemParticleAmount.getCapacity(stack) > 0) {
                size *= (double)this.getAmountStored(stack) / (double)IItemParticleAmount.getCapacity(stack);
            }
            world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)(size * QMDConfig.cell_explosion_size), true);
            world.func_72838_d((Entity)new EntityGammaFlash(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size));
            HashSet entitylist = new HashSet();
            double radius = 128.0 * Math.sqrt(size);
            entitylist.addAll(world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)pos.func_177958_n() - radius, (double)pos.func_177956_o() - radius, (double)pos.func_177952_p() - radius, (double)pos.func_177958_n() + radius, (double)pos.func_177956_o() + radius, (double)pos.func_177952_p() + radius)));
            for (EntityLivingBase entity : entitylist) {
                IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)entity);
                if (entityRads == null) continue;
                double rads = Math.min(QMDConfig.cell_radiation * size, QMDConfig.cell_radiation * size / pos.func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)entity, (double)rads, (boolean)false, (boolean)false, (int)1));
                if (!(rads >= entityRads.getMaxRads())) continue;
                entity.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
            }
        }
    }
}

