/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Units;
import nc.util.Lang;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class GuiParticle {
    private int width = 16;
    private int height = 16;
    private final GuiContainer screen;

    public GuiParticle(GuiContainer screen) {
        this.screen = screen;
    }

    public void drawParticleStack(ParticleStack particleStack, int x, int y) {
        if (particleStack == null) {
            return;
        }
        if (particleStack.getParticle() == null) {
            return;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.field_146297_k.func_110434_K().func_110577_a(particleStack.getParticle().getTexture());
        GuiContainer.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
    }

    private void drawToolTip(ParticleStack stack, int mouseX, int mouseY, boolean showFocus) {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.WHITE + Lang.localise((String)stack.getParticle().getUnlocalizedName()));
        text.add(TextFormatting.GRAY + Lang.localise((String)"gui.qmd.particlestack.mean_energy", (Object[])new Object[]{Units.getParticleEnergy(stack.getMeanEnergy())}));
        text.add(TextFormatting.GRAY + Lang.localise((String)"gui.qmd.particlestack.amount", (Object[])new Object[]{Units.getSIFormat(stack.getAmount(), "pu")}));
        if (showFocus) {
            DecimalFormat df = new DecimalFormat("#.####");
            text.add(TextFormatting.GRAY + Lang.localise((String)"gui.qmd.particlestack.focus", (Object[])new Object[]{df.format(stack.getFocus())}));
        }
        this.screen.func_146283_a(text, mouseX, mouseY);
    }

    public void drawToolTipBox(ParticleStack particleStack, int x, int y, int mouseX, int mouseY) {
        if (mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height) {
            this.drawToolTip(particleStack, mouseX, mouseY, false);
        }
    }

    public void drawToolTipBoxwithFocus(ParticleStack particleStack, int x, int y, int mouseX, int mouseY) {
        if (particleStack != null && particleStack.getParticle() != null && mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height) {
            this.drawToolTip(particleStack, mouseX, mouseY, true);
        }
    }
}

