/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.QMDDamageSources;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityGammaFlash;
import lach_01298.qmd.network.AntimatterProjectileUpdatePacket;
import lach_01298.qmd.network.QMDPacketHandler;
import nc.capability.radiation.entity.IEntityRads;
import nc.radiation.RadiationHelper;
import nc.util.DamageSources;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAntimatterProjectile
extends Entity
implements IProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private Color color;
    public Entity shootingEntity;
    private int ticksInAir;
    private double damage = 1.0;

    public EntityAntimatterProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityAntimatterProjectile(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityAntimatterProjectile(World worldIn, EntityLivingBase shooter, double damage, int color) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shootingEntity = shooter;
        this.damage = damage;
        this.color = new Color(color);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = new Color(color);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityAntimatterProjectile.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        Entity entity;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            this.explode(this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
        ++this.ticksInAir;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = 0.05f;
        if (this.func_70090_H()) {
            this.explode(this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.05f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getColor() != null) {
                this.sendUpdatePacket();
            } else {
                this.func_70106_y();
            }
            if (this.ticksInAir > 2000) {
                this.func_70106_y();
            }
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        if (this.field_70173_aa > 1) {
            Entity entity = raytraceResultIn.field_72308_g;
            if (entity != null) {
                DamageSource damagesource = this.shootingEntity == null ? QMDDamageSources.causeAntimatterLauncherDamage(this, this) : QMDDamageSources.causeAntimatterLauncherDamage(this, this.shootingEntity);
                if (entity.func_70097_a(damagesource, 10.0f)) {
                    if (entity instanceof EntityLivingBase) {
                        EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                        this.arrowHit(entitylivingbase);
                        if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                        }
                    }
                    this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                }
            } else {
                BlockPos blockpos = raytraceResultIn.func_178782_a();
                this.xTile = blockpos.func_177958_n();
                this.yTile = blockpos.func_177956_o();
                this.zTile = blockpos.func_177952_p();
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                this.inTile = iblockstate.func_177230_c();
                this.inData = this.inTile.func_176201_c(iblockstate);
                this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
                this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
                this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
                float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                if (iblockstate.func_185904_a() != Material.field_151579_a) {
                    this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
                }
            }
            this.explode(this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
    }

    protected void arrowHit(EntityLivingBase living) {
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public static void registerFixesArrow(DataFixer fixer, String name) {
    }

    public static void registerFixesArrow(DataFixer fixer) {
        EntityAntimatterProjectile.registerFixesArrow(fixer, "Arrow");
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        compound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74780_a("damage", this.damage);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            double size = this.damage;
            world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)(size * QMDConfig.antimatter_launcher_explosion_size), true);
            world.func_72838_d((Entity)new EntityGammaFlash(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size));
            HashSet entitylist = new HashSet();
            double radius = 128.0 * Math.sqrt(size);
            entitylist.addAll(world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)pos.func_177958_n() - radius, (double)pos.func_177956_o() - radius, (double)pos.func_177952_p() - radius, (double)pos.func_177958_n() + radius, (double)pos.func_177956_o() + radius, (double)pos.func_177952_p() + radius)));
            for (EntityLivingBase entity : entitylist) {
                IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)entity);
                if (entityRads == null) continue;
                double rads = Math.min(QMDConfig.cell_radiation * size, QMDConfig.antimatter_launcher_radiation * size / pos.func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)entity, (double)rads, (boolean)false, (boolean)false, (int)1));
                if (!(rads >= entityRads.getMaxRads())) continue;
                entity.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
            }
        }
    }

    protected void sendUpdatePacket() {
        if (!this.field_70170_p.field_72995_K) {
            QMDPacketHandler.instance.sendToAllAround((IMessage)new AntimatterProjectileUpdatePacket(this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
        }
    }
}

