/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.crafttweaker.QMDCTHelper;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeHandler;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;

public class RemoveQMDRecipe
implements IAction {
    public static boolean hasErrored = false;
    public List<IItemIngredient> itemIngredients;
    public List<IFluidIngredient> fluidIngredients;
    public List<IParticleIngredient> particleIngredients;
    public IngredientSorption type;
    public QMDRecipe recipe;
    public boolean ingredientError;
    public boolean wasNull;
    public boolean wrongSize;
    public final QMDRecipeHandler recipeHandler;

    public RemoveQMDRecipe(QMDRecipeHandler recipeHandler, IngredientSorption type, List<IIngredient> ctIngredients) {
        Object ingredient;
        int i;
        int particleSize;
        this.recipeHandler = recipeHandler;
        this.type = type;
        int itemSize = type == IngredientSorption.INPUT ? recipeHandler.getItemInputSize() : recipeHandler.getItemOutputSize();
        int fluidSize = type == IngredientSorption.INPUT ? recipeHandler.getFluidInputSize() : recipeHandler.getFluidOutputSize();
        int n = particleSize = type == IngredientSorption.INPUT ? recipeHandler.getParticleInputSize() : recipeHandler.getParticleOutputSize();
        if (ctIngredients.size() != itemSize + fluidSize + particleSize) {
            CraftTweakerAPI.logError((String)("A " + recipeHandler.getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IParticleIngredient> particleIngredients = new ArrayList<IParticleIngredient>();
        for (i = 0; i < itemSize; ++i) {
            ingredient = CTHelper.buildRemovalItemIngredient((IIngredient)ctIngredients.get(i));
            if (ingredient == null) {
                this.ingredientError = true;
                return;
            }
            itemIngredients.add((IItemIngredient)ingredient);
        }
        for (i = itemSize; i < itemSize + fluidSize; ++i) {
            ingredient = CTHelper.buildRemovalFluidIngredient((IIngredient)ctIngredients.get(i));
            if (ingredient == null) {
                this.ingredientError = true;
                return;
            }
            fluidIngredients.add((IFluidIngredient)ingredient);
        }
        for (i = itemSize + fluidSize; i < itemSize + fluidSize + particleSize; ++i) {
            ingredient = QMDCTHelper.buildRemovalParticleIngredient(ctIngredients.get(i));
            if (ingredient == null) {
                this.ingredientError = true;
                return;
            }
            particleIngredients.add((IParticleIngredient)ingredient);
        }
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        this.particleIngredients = particleIngredients;
        QMDRecipe qMDRecipe = this.recipe = type == IngredientSorption.INPUT ? (QMDRecipe)recipeHandler.getRecipeFromIngredients(itemIngredients, fluidIngredients, particleIngredients) : null;
        if (this.recipe == null) {
            this.wasNull = true;
        }
    }

    public void apply() {
        if (!(this.ingredientError || this.wasNull || this.wrongSize)) {
            boolean removed = this.recipeHandler.removeRecipe(this.recipe);
            while (removed) {
                this.recipe = this.type == IngredientSorption.INPUT ? (QMDRecipe)this.recipeHandler.getRecipeFromIngredients(this.itemIngredients, this.fluidIngredients, this.particleIngredients) : null;
                removed = this.recipeHandler.removeRecipe(this.recipe);
            }
        }
    }

    public String describe() {
        if (this.ingredientError || this.wasNull || this.wrongSize) {
            if (this.ingredientError || this.wrongSize) {
                RemoveQMDRecipe.callError();
            }
            return String.format("Error: Failed to remove %s recipe with %s as the " + (this.type == IngredientSorption.INPUT ? "input" : "output"), this.recipeHandler.getRecipeName(), QMDRecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients, this.particleIngredients));
        }
        if (this.type == IngredientSorption.INPUT) {
            return String.format("Removing %s recipe: %s", this.recipeHandler.getRecipeName(), QMDRecipeHelper.getRecipeString(this.recipe));
        }
        return String.format("Removing %s recipes for: %s", this.recipeHandler.getRecipeName(), QMDRecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients, this.particleIngredients));
    }

    public static void callError() {
        if (!hasErrored) {
            CraftTweakerAPI.logError((String)"At least one QMD CraftTweaker recipe removal method has errored - check the CraftTweaker log for more details");
        }
        hasErrored = true;
    }
}

