/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.crafttweaker.QMDCTHelper;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeHandler;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;

public class AddQMDRecipe
implements IAction {
    public static boolean hasErrored = false;
    public List<IItemIngredient> itemIngredients;
    public List<IFluidIngredient> fluidIngredients;
    public List<IItemIngredient> itemProducts;
    public List<IFluidIngredient> fluidProducts;
    public List<IParticleIngredient> particleIngredients;
    public List<IParticleIngredient> particleProducts;
    public List extras;
    public QMDRecipe recipe;
    public boolean inputsAllNull = true;
    public boolean ingredientError;
    public boolean wasNull;
    public boolean wrongSize;
    public final QMDRecipeHandler recipeHandler;

    public AddQMDRecipe(QMDRecipeHandler recipeHandler, List objects) {
        this.recipeHandler = recipeHandler;
        int listCount = 0;
        int ingredientCount = 0;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        ArrayList<IParticleIngredient> particleIngredients = new ArrayList<IParticleIngredient>();
        ArrayList<IParticleIngredient> particleProducts = new ArrayList<IParticleIngredient>();
        ArrayList extras = new ArrayList();
        while (listCount < objects.size()) {
            Object ingredient;
            Object object = objects.get(listCount);
            if (ingredientCount < recipeHandler.getItemInputSize()) {
                if (object != null) {
                    if (!(object instanceof IIngredient)) {
                        this.ingredientError = true;
                        return;
                    }
                    this.inputsAllNull = false;
                }
                if ((ingredient = CTHelper.buildAdditionItemIngredient((IIngredient)((IIngredient)object))) == null) {
                    this.ingredientError = true;
                    return;
                }
                itemIngredients.add((IItemIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize()) {
                if (object != null) {
                    if (!(object instanceof IIngredient)) {
                        this.ingredientError = true;
                        return;
                    }
                    this.inputsAllNull = false;
                }
                if ((ingredient = CTHelper.buildAdditionFluidIngredient((IIngredient)((IIngredient)object))) == null) {
                    this.ingredientError = true;
                    return;
                }
                fluidIngredients.add((IFluidIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize() + recipeHandler.getParticleInputSize()) {
                if (object != null) {
                    if (!(object instanceof IIngredient)) {
                        this.ingredientError = true;
                        return;
                    }
                    this.inputsAllNull = false;
                }
                if ((ingredient = QMDCTHelper.buildAdditionParticleIngredient((IIngredient)object)) == null) {
                    this.ingredientError = true;
                    return;
                }
                particleIngredients.add((IParticleIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize() + recipeHandler.getParticleInputSize() + recipeHandler.getItemOutputSize()) {
                if (object != null && !(object instanceof IIngredient)) {
                    this.ingredientError = true;
                    return;
                }
                ingredient = CTHelper.buildAdditionItemIngredient((IIngredient)((IIngredient)object));
                if (ingredient == null) {
                    this.ingredientError = true;
                    return;
                }
                itemProducts.add((IItemIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize() + recipeHandler.getParticleInputSize() + recipeHandler.getItemOutputSize() + recipeHandler.getFluidOutputSize()) {
                if (object != null && !(object instanceof IIngredient)) {
                    this.ingredientError = true;
                    return;
                }
                ingredient = CTHelper.buildAdditionFluidIngredient((IIngredient)((IIngredient)object));
                if (ingredient == null) {
                    this.ingredientError = true;
                    return;
                }
                fluidProducts.add((IFluidIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize() + recipeHandler.getParticleInputSize() + recipeHandler.getItemOutputSize() + recipeHandler.getFluidOutputSize() + recipeHandler.getParticleOutputSize()) {
                if (object != null && !(object instanceof IIngredient)) {
                    this.ingredientError = true;
                    return;
                }
                ingredient = QMDCTHelper.buildAdditionParticleIngredient((IIngredient)object);
                if (ingredient == null) {
                    this.ingredientError = true;
                    return;
                }
                particleProducts.add((IParticleIngredient)ingredient);
            } else {
                extras.add(object);
            }
            ++listCount;
            ++ingredientCount;
        }
        if (itemIngredients.size() != recipeHandler.getItemInputSize() || fluidIngredients.size() != recipeHandler.getFluidInputSize() || particleIngredients.size() != recipeHandler.getParticleInputSize() || itemProducts.size() != recipeHandler.getItemOutputSize() || fluidProducts.size() != recipeHandler.getFluidOutputSize() || particleProducts.size() != recipeHandler.getParticleOutputSize()) {
            CraftTweakerAPI.logError((String)("A " + recipeHandler.getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        this.particleIngredients = particleIngredients;
        this.itemProducts = itemProducts;
        this.fluidProducts = fluidProducts;
        this.particleProducts = particleProducts;
        this.extras = extras;
        this.recipe = recipeHandler.buildRecipe(itemIngredients, fluidIngredients, particleIngredients, itemProducts, fluidProducts, particleProducts, extras, recipeHandler.isShapeless());
        if (this.recipe == null) {
            this.wasNull = true;
        }
    }

    public void apply() {
        if (!(this.inputsAllNull || this.ingredientError || this.wasNull || this.wrongSize)) {
            this.recipeHandler.addRecipe(this.recipe);
        }
    }

    public String describe() {
        if (this.inputsAllNull || this.ingredientError || this.wasNull || this.wrongSize) {
            if (this.ingredientError || this.wrongSize) {
                AddQMDRecipe.callError();
            }
            return String.format("Error: Failed to add %s recipe: %s", this.recipeHandler.getRecipeName(), QMDRecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.particleIngredients, this.itemProducts, this.fluidProducts, this.particleProducts));
        }
        return String.format("Adding %s recipe: %s", this.recipeHandler.getRecipeName(), QMDRecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.particleIngredients, this.itemProducts, this.fluidProducts, this.particleProducts));
    }

    public static void callError() {
        if (!hasErrored) {
            CraftTweakerAPI.logError((String)"At least one QMD CraftTweaker recipe addition method has errored - check the CraftTweaker log for more details");
        }
        hasErrored = true;
    }
}

