/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.network.QMDTileUpdatePacket;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.ITileGui;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.Lang;
import nc.util.NBTHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAcceleratorSource
extends TileAcceleratorPart
implements ITileInventory,
ITileGui<QMDTileUpdatePacket> {
    @Nonnull
    private final String inventoryName = "qmd.container.accelerator_source";
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(Arrays.asList(ItemSorption.BOTH, ItemSorption.BOTH));
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    protected Set<EntityPlayer> playersToUpdate = new ObjectOpenHashSet();

    public TileAcceleratorSource() {
        super(CuboidalPartPositionType.WALL);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onMachineAssembled(Accelerator controller) {
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    public String func_70005_c_() {
        return Lang.localise((String)"gui.qmd.container.accelerator_source");
    }

    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public int func_70297_j_() {
        return 1;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
    }

    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
        return nbt;
    }

    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public int getGuiID() {
        return 3;
    }

    public Set<EntityPlayer> getTileUpdatePacketListeners() {
        return this.playersToUpdate;
    }

    public QMDTileUpdatePacket getTileUpdatePacket() {
        return new QMDTileUpdatePacket();
    }

    public void onTileUpdatePacket(QMDTileUpdatePacket message) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return QMDRecipes.accelerator_source.isValidItemInput(IItemParticleAmount.cleanNBT(stack));
    }
}

