/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.LinearAcceleratorLogic;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSource;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAcceleratorPort
extends TileAcceleratorPart
implements ITileInventory {
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private TileAcceleratorSource source;
    @Nonnull
    private final String inventoryName = "qmd.container.accelerator_port";
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll((List)Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.BOTH, ItemSorption.BOTH}));

    public TileAcceleratorPort() {
        super(CuboidalPartPositionType.WALL);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onMachineAssembled(Accelerator accelerator) {
        super.onMachineAssembled(accelerator);
    }

    public void setSource(LinearAcceleratorLogic logic) {
        this.source = logic.getSource();
    }

    @Override
    public void onMachineBroken() {
        this.source = null;
        super.onMachineBroken();
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        return this.source == null ? this.inventoryStacks : this.source.getInventoryStacks();
    }

    public String func_70005_c_() {
        return "qmd.container.accelerator_port";
    }

    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return QMDRecipes.accelerator_source.isValidItemInput(IItemParticleAmount.cleanNBT(stack));
    }
}

