/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.CoolerPlacement;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.enums.BlockTypes;
import nc.multiblock.PlacementRule;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.tile.ITileMultiblockPart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileAcceleratorCooler
extends TileAcceleratorPart
implements IAcceleratorComponent {
    public String name;
    public int coolingRate;
    public String ruleID;
    public PlacementRule<Accelerator, IAcceleratorPart> placementRule;
    public boolean isSearched = false;
    public boolean isInValidPosition = false;

    public TileAcceleratorCooler() {
        super(CuboidalPartPositionType.INTERIOR);
    }

    public TileAcceleratorCooler(String name, int coolingRate, String ruleID) {
        this();
        this.name = name;
        this.coolingRate = coolingRate;
        this.ruleID = ruleID;
        this.placementRule = (PlacementRule)CoolerPlacement.RULE_MAP.get((Object)ruleID);
    }

    protected TileAcceleratorCooler(String name, int coolingRate) {
        this(name, coolingRate, name + "_cooler");
    }

    @Override
    public void onMachineAssembled(Accelerator controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    public boolean isFunctional() {
        return this.isInValidPosition;
    }

    @Override
    public void setFunctional(boolean functional) {
        this.isInValidPosition = false;
    }

    @Override
    public int getMaxOperatingTemp() {
        return 400;
    }

    public void coolerSearch(ObjectSet<TileAcceleratorCooler> validCache, ObjectSet<TileAcceleratorCooler> searchCache, Long2ObjectMap<TileAcceleratorCooler> partFailCache, Long2ObjectMap<TileAcceleratorCooler> assumedValidCache) {
        if (!this.isCoolerValid(partFailCache, assumedValidCache)) {
            return;
        }
        if (this.isSearched) {
            return;
        }
        this.isSearched = true;
        validCache.add((Object)this);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileAcceleratorCooler part = (TileAcceleratorCooler)((Accelerator)this.getMultiblock()).getPartMap(TileAcceleratorCooler.class).get(this.getTilePos().func_177972_a(dir).func_177986_g());
            if (part == null) continue;
            searchCache.add((Object)part);
        }
    }

    public boolean isCoolerValid(Long2ObjectMap<TileAcceleratorCooler> partFailCache, Long2ObjectMap<TileAcceleratorCooler> assumedValidCache) {
        if (partFailCache.containsKey(this.field_174879_c.func_177986_g())) {
            this.isInValidPosition = false;
            return false;
        }
        if (this.placementRule.requiresRecheck()) {
            this.isInValidPosition = this.placementRule.satisfied((ITileMultiblockPart)this);
            if (this.isInValidPosition) {
                assumedValidCache.put(this.field_174879_c.func_177986_g(), (Object)this);
            }
            return this.isInValidPosition;
        }
        if (this.isInValidPosition) {
            return true;
        }
        this.isInValidPosition = this.placementRule.satisfied((ITileMultiblockPart)this);
        return this.isInValidPosition;
    }

    public boolean isSearchRoot() {
        for (String dep : this.placementRule.getDependencies()) {
            if (!dep.equals("magnet") && !dep.equals("cavity") && !dep.equals("yoke") && !dep.equals("beam")) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("coolingRate", this.coolingRate);
        nbt.func_74778_a("ruleID", this.ruleID);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("coolingRate")) {
            this.coolingRate = nbt.func_74762_e("coolingRate");
        }
        if (nbt.func_74764_b("ruleID")) {
            this.ruleID = nbt.func_74779_i("ruleID");
            this.placementRule = (PlacementRule)CoolerPlacement.RULE_MAP.get((Object)this.ruleID);
        }
    }

    public static class Cryotheum
    extends TileAcceleratorCooler {
        public Cryotheum() {
            super("cryotheum", BlockTypes.CoolerType2.CRYOTHEUM.getHeatRemoved());
        }
    }

    public static class Enderium
    extends TileAcceleratorCooler {
        public Enderium() {
            super("enderium", BlockTypes.CoolerType2.ENDERIUM.getHeatRemoved());
        }
    }

    public static class LiquidHelium
    extends TileAcceleratorCooler {
        public LiquidHelium() {
            super("liquid_helium", BlockTypes.CoolerType2.LIQUID_HELIUM.getHeatRemoved());
        }
    }

    public static class LiquidNitrogen
    extends TileAcceleratorCooler {
        public LiquidNitrogen() {
            super("liquid_nitrogen", BlockTypes.CoolerType2.LIQUID_NITROGEN.getHeatRemoved());
        }
    }

    public static class Arsenic
    extends TileAcceleratorCooler {
        public Arsenic() {
            super("arsenic", BlockTypes.CoolerType2.ARSENIC.getHeatRemoved());
        }
    }

    public static class Carobbiite
    extends TileAcceleratorCooler {
        public Carobbiite() {
            super("carobbiite", BlockTypes.CoolerType2.CAROBBIITE.getHeatRemoved());
        }
    }

    public static class Villiaumite
    extends TileAcceleratorCooler {
        public Villiaumite() {
            super("villiaumite", BlockTypes.CoolerType2.VILLIAUMITE.getHeatRemoved());
        }
    }

    public static class Fluorite
    extends TileAcceleratorCooler {
        public Fluorite() {
            super("fluorite", BlockTypes.CoolerType2.FLUORITE.getHeatRemoved());
        }
    }

    public static class Silver
    extends TileAcceleratorCooler {
        public Silver() {
            super("silver", BlockTypes.CoolerType2.SILVER.getHeatRemoved());
        }
    }

    public static class Aluminum
    extends TileAcceleratorCooler {
        public Aluminum() {
            super("aluminum", BlockTypes.CoolerType2.ALUMINUM.getHeatRemoved());
        }
    }

    public static class Manganese
    extends TileAcceleratorCooler {
        public Manganese() {
            super("manganese", BlockTypes.CoolerType2.MANGANESE.getHeatRemoved());
        }
    }

    public static class Magnesium
    extends TileAcceleratorCooler {
        public Magnesium() {
            super("magnesium", BlockTypes.CoolerType2.MAGNESIUM.getHeatRemoved());
        }
    }

    public static class Lithium
    extends TileAcceleratorCooler {
        public Lithium() {
            super("lithium", BlockTypes.CoolerType2.LITHIUM.getHeatRemoved());
        }
    }

    public static class Boron
    extends TileAcceleratorCooler {
        public Boron() {
            super("boron", BlockTypes.CoolerType2.BORON.getHeatRemoved());
        }
    }

    public static class Lead
    extends TileAcceleratorCooler {
        public Lead() {
            super("lead", BlockTypes.CoolerType2.LEAD.getHeatRemoved());
        }
    }

    public static class Tin
    extends TileAcceleratorCooler {
        public Tin() {
            super("tin", BlockTypes.CoolerType2.TIN.getHeatRemoved());
        }
    }

    public static class Copper
    extends TileAcceleratorCooler {
        public Copper() {
            super("copper", BlockTypes.CoolerType1.COPPER.getHeatRemoved());
        }
    }

    public static class Emerald
    extends TileAcceleratorCooler {
        public Emerald() {
            super("emerald", BlockTypes.CoolerType1.EMERALD.getHeatRemoved());
        }
    }

    public static class Diamond
    extends TileAcceleratorCooler {
        public Diamond() {
            super("diamond", BlockTypes.CoolerType1.DIAMOND.getHeatRemoved());
        }
    }

    public static class Purpur
    extends TileAcceleratorCooler {
        public Purpur() {
            super("purpur", BlockTypes.CoolerType1.PURPUR.getHeatRemoved());
        }
    }

    public static class EndStone
    extends TileAcceleratorCooler {
        public EndStone() {
            super("end_stone", BlockTypes.CoolerType1.END_STONE.getHeatRemoved());
        }
    }

    public static class Slime
    extends TileAcceleratorCooler {
        public Slime() {
            super("slime", BlockTypes.CoolerType1.SLIME.getHeatRemoved());
        }
    }

    public static class Prismarine
    extends TileAcceleratorCooler {
        public Prismarine() {
            super("prismarine", BlockTypes.CoolerType1.PRISMARINE.getHeatRemoved());
        }
    }

    public static class Gold
    extends TileAcceleratorCooler {
        public Gold() {
            super("gold", BlockTypes.CoolerType1.GOLD.getHeatRemoved());
        }
    }

    public static class Lapis
    extends TileAcceleratorCooler {
        public Lapis() {
            super("lapis", BlockTypes.CoolerType1.LAPIS.getHeatRemoved());
        }
    }

    public static class Glowstone
    extends TileAcceleratorCooler {
        public Glowstone() {
            super("glowstone", BlockTypes.CoolerType1.GLOWSTONE.getHeatRemoved());
        }
    }

    public static class NetherBrick
    extends TileAcceleratorCooler {
        public NetherBrick() {
            super("nether_brick", BlockTypes.CoolerType1.NETHER_BRICK.getHeatRemoved());
        }
    }

    public static class Obsidian
    extends TileAcceleratorCooler {
        public Obsidian() {
            super("obsidian", BlockTypes.CoolerType1.OBSIDIAN.getHeatRemoved());
        }
    }

    public static class Quartz
    extends TileAcceleratorCooler {
        public Quartz() {
            super("quartz", BlockTypes.CoolerType1.QUARTZ.getHeatRemoved());
        }
    }

    public static class Redstone
    extends TileAcceleratorCooler {
        public Redstone() {
            super("redstone", BlockTypes.CoolerType1.REDSTONE.getHeatRemoved());
        }
    }

    public static class Iron
    extends TileAcceleratorCooler {
        public Iron() {
            super("iron", BlockTypes.CoolerType1.IRON.getHeatRemoved());
        }
    }

    public static class Water
    extends TileAcceleratorCooler {
        public Water() {
            super("water", BlockTypes.CoolerType1.WATER.getHeatRemoved());
        }
    }
}

