/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.block.BlockProperties;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.io.IIOType;
import lach_01298.qmd.particle.ITileParticleStorage;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.util.Lang;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileAcceleratorBeamPort
extends TileAcceleratorPart
implements IIOType,
ITileParticleStorage,
ITickable {
    @Nonnull
    private final List<ParticleStorageAccelerator> backupTanks = Lists.newArrayList((Object[])new ParticleStorageAccelerator[]{new ParticleStorageAccelerator()});
    private EnumTypes.IOType mode = EnumTypes.IOType.DISABLED;
    private EnumTypes.IOType setting = EnumTypes.IOType.INPUT;
    private boolean triggered = false;
    private boolean powered = false;

    public TileAcceleratorBeamPort() {
        super(CuboidalPartPositionType.WALL);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public EnumTypes.IOType getIOType() {
        return this.mode;
    }

    @Override
    public void setIOType(EnumTypes.IOType type) {
        this.mode = type;
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a(BlockProperties.IO, (Comparable)((Object)type)));
        this.markDirtyAndNotify(true);
        ((Accelerator)this.getMultiblock()).checkIfMachineIsWhole();
    }

    public void cycleMode() {
        this.setIOType(this.mode.getNextIO());
    }

    public EnumTypes.IOType getSetting() {
        return this.setting;
    }

    public void toggleSetting() {
        if (this.setting == EnumTypes.IOType.INPUT) {
            this.setSettingType(EnumTypes.IOType.OUTPUT);
        } else {
            this.setSettingType(EnumTypes.IOType.INPUT);
        }
    }

    public void switchMode() {
        if (this.mode == this.setting) {
            this.setIOType(EnumTypes.IOType.DISABLED);
        } else {
            this.setIOType(this.setting);
        }
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a(BlockProperties.IO, (Comparable)((Object)this.mode)));
        this.markDirtyAndNotify(true);
        ((Accelerator)this.getMultiblock()).checkIfMachineIsWhole();
    }

    public void setSettingType(EnumTypes.IOType setting) {
        this.setting = setting;
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a(BlockProperties.IO, (Comparable)((Object)this.mode)));
        this.markDirtyAndNotify(true);
        ((Accelerator)this.getMultiblock()).checkIfMachineIsWhole();
    }

    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            TextFormatting format;
            this.toggleSetting();
            switch (this.getSetting()) {
                case INPUT: {
                    format = TextFormatting.DARK_AQUA;
                    break;
                }
                case OUTPUT: {
                    format = TextFormatting.RED;
                    break;
                }
                default: {
                    format = TextFormatting.GRAY;
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"qmd.block.accelerator_port_setting_toggle") + " " + format + Lang.localise((String)("qmd.block.port_mode." + this.getSetting().name())) + " " + TextFormatting.WHITE + Lang.localise((String)"qmd.block.port.mode")));
        } else {
            TextFormatting format;
            this.cycleMode();
            switch (this.getIOType()) {
                case INPUT: {
                    format = TextFormatting.DARK_AQUA;
                    break;
                }
                case OUTPUT: {
                    format = TextFormatting.RED;
                    break;
                }
                default: {
                    format = TextFormatting.GRAY;
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"qmd.block.port_mode_toggle") + " " + format + Lang.localise((String)("qmd.block.port_mode." + this.getIOType().name())) + " " + TextFormatting.WHITE + Lang.localise((String)"qmd.block.port.mode")));
        }
        return true;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("mode", this.mode.getID());
        nbt.func_74768_a("setting", this.setting.getID());
        nbt.func_74757_a("triggered", this.triggered);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.mode = EnumTypes.IOType.getTypeFromID(nbt.func_74762_e("mode"));
        this.setting = EnumTypes.IOType.getTypeFromID(nbt.func_74762_e("setting"));
        this.triggered = nbt.func_74767_n("triggered");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return this.mode != EnumTypes.IOType.DISABLED;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            if (!this.getParticleBeams().isEmpty()) {
                if (this.mode == EnumTypes.IOType.OUTPUT && this.getParticleBeams().size() >= 2) {
                    return (T)this.getParticleBeams().get(1);
                }
                return (T)this.getParticleBeams().get(0);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    @Override
    public List<? extends ParticleStorage> getParticleBeams() {
        if (!this.isMultiblockAssembled()) {
            return this.backupTanks;
        }
        return ((Accelerator)this.getMultiblock()).beams;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public void resetTrigger() {
        this.triggered = false;
    }

    public void setTrigger() {
        this.triggered = true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getMultiblock() != null && this.getIsRedstonePowered() && !this.powered) {
                this.setTrigger();
                ((Accelerator)this.getMultiblock()).switchIO();
            }
            this.powered = this.getIsRedstonePowered();
        }
    }
}

