/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.QuadrupoleMagnet;
import lach_01298.qmd.accelerator.RFCavity;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSynchrotronPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorYoke;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.LinearAcceleratorUpdatePacket;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.util.Equations;
import nc.block.property.BlockProperties;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.fluid.Tank;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class LinearAcceleratorLogic
extends AcceleratorLogic {
    protected TileAcceleratorSource source;
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public static final List<Pair<Class<? extends IAcceleratorPart>, String>> PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileAcceleratorYoke.class, (Object)"qmd.multiblock_validation.accelerator.no_yokes"), Pair.of(TileAcceleratorSynchrotronPort.class, (Object)"qmd.multiblock_validation.accelerator.no_synch_ports")});

    public LinearAcceleratorLogic(AcceleratorLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "linear_accelerator";
    }

    @Override
    public boolean isMachineWhole() {
        int outputs;
        int inputs;
        ArrayList<TileAcceleratorBeamPort> ports;
        ObjectIterator end2;
        BlockPos end1;
        EnumFacing.Axis axis;
        Accelerator acc = this.getAccelerator();
        if (acc.getExteriorLengthY() != 5) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.wrong_height", null, new Object[0]);
            return false;
        }
        if (acc.getExteriorLengthX() > acc.getExteriorLengthZ()) {
            axis = EnumFacing.Axis.X;
            if (acc.getExteriorLengthX() < QMDConfig.accelerator_linear_min_size) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.to_short", null, new Object[0]);
                return false;
            }
            if (acc.getExteriorLengthZ() != 5) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_be_5_wide", null, new Object[0]);
                return false;
            }
        } else {
            axis = EnumFacing.Axis.Z;
            if (acc.getExteriorLengthZ() < QMDConfig.accelerator_linear_min_size) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.to_short", null, new Object[0]);
                return false;
            }
            if (acc.getExteriorLengthX() != 5) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_be_5_wide", null, new Object[0]);
                return false;
            }
        }
        for (BlockPos pos : this.getinteriorAxisPositions(axis)) {
            if (acc.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_be_beam", pos, new Object[0]);
            return false;
        }
        if (axis == EnumFacing.Axis.X) {
            end1 = acc.getExtremeCoord(false, false, false).func_177982_a(0, 2, 2);
            end2 = acc.getExtremeCoord(true, false, false).func_177982_a(0, 2, 2);
            if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort) {
                ports = new ArrayList<TileAcceleratorBeamPort>();
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s(end1));
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s((BlockPos)end2));
                inputs = 0;
                outputs = 0;
                for (TileAcceleratorBeamPort port : ports) {
                    if (port.getIOType() == EnumTypes.IOType.INPUT) {
                        ++inputs;
                    }
                    if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                    ++outputs;
                }
                if (inputs != 1 || outputs != 1) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_have_io", null, new Object[0]);
                    return false;
                }
            } else {
                if (!(acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorSource && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort || acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorSource)) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.have_source_and_beam_port", null, new Object[0]);
                    return false;
                }
                if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorSource) {
                    if (acc.WORLD.func_180495_p(end1).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.EAST) {
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", end1, new Object[0]);
                        return false;
                    }
                } else if (acc.WORLD.func_180495_p((BlockPos)end2).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.WEST) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", (BlockPos)end2, new Object[0]);
                    return false;
                }
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            end1 = acc.getExtremeCoord(false, false, false).func_177982_a(2, 2, 0);
            end2 = acc.getExtremeCoord(false, false, true).func_177982_a(2, 2, 0);
            if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort) {
                ports = new ArrayList();
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s(end1));
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s((BlockPos)end2));
                inputs = 0;
                outputs = 0;
                for (TileAcceleratorBeamPort port : ports) {
                    if (port.getIOType() == EnumTypes.IOType.INPUT) {
                        ++inputs;
                    }
                    if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                    ++outputs;
                }
                if (inputs != 1 || outputs != 1) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_have_io", null, new Object[0]);
                    return false;
                }
            } else {
                if (!(acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorSource && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort || acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorSource)) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.have_source_and_beam_port", null, new Object[0]);
                    return false;
                }
                if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorSource) {
                    if (acc.WORLD.func_180495_p(end1).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.SOUTH) {
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", end1, new Object[0]);
                        return false;
                    }
                } else if (acc.WORLD.func_180495_p((BlockPos)end2).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.NORTH) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", (BlockPos)end2, new Object[0]);
                    return false;
                }
            }
        }
        int sources = 0;
        for (TileAcceleratorSource port : this.getPartMap(TileAcceleratorSource.class).values()) {
            ++sources;
        }
        if (sources > 1) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.only_one_source", null, new Object[0]);
            return false;
        }
        int ports2 = 0;
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            ++ports2;
        }
        if (ports2 > 2 - sources) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.to_many_beam_ports", null, new Object[0]);
            return false;
        }
        if (this.containsBlacklistedPart()) {
            return false;
        }
        return super.isMachineWhole();
    }

    public Set<BlockPos> getinteriorAxisPositions(EnumFacing.Axis axis) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        Accelerator acc = this.getAccelerator();
        if (axis == EnumFacing.Axis.X) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, false).func_177982_a(0, acc.getInteriorLengthY() / 2, acc.getInteriorLengthZ() / 2), (BlockPos)acc.getExtremeInteriorCoord(true, false, false).func_177982_a(0, acc.getInteriorLengthY() / 2, acc.getInteriorLengthZ() / 2))) {
                postions.add(pos.func_185334_h());
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, false).func_177982_a(acc.getInteriorLengthX() / 2, acc.getInteriorLengthY() / 2, 0), (BlockPos)acc.getExtremeInteriorCoord(false, false, true).func_177982_a(acc.getInteriorLengthX() / 2, acc.getInteriorLengthY() / 2, 0))) {
                postions.add(pos.func_185334_h());
            }
        }
        return postions;
    }

    public void updateNumbers() {
        this.getAccelerator().RFCavityNumber = this.getAccelerator().getRFCavityMap().size();
        this.getAccelerator().quadrupoleNumber = this.getAccelerator().getQuadrupoleMap().size();
        this.getAccelerator().dipoleNumber = this.getAccelerator().getDipoleMap().size();
    }

    @Override
    public void onAcceleratorFormed() {
        EnumFacing.Axis axis = ((Accelerator)this.multiblock).getExteriorLengthX() > ((Accelerator)this.multiblock).getExteriorLengthZ() ? EnumFacing.Axis.X : EnumFacing.Axis.Z;
        Accelerator acc = this.getAccelerator();
        if (!this.getWorld().field_72995_K) {
            acc.beams.get(0).setMinEnergy(0L);
            for (BlockPos pos : this.getinteriorAxisPositions(axis)) {
                if (!(acc.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam)) continue;
                TileAcceleratorBeam beam = (TileAcceleratorBeam)this.getWorld().func_175625_s(pos);
                beam.setFunctional(true);
            }
            for (TileAcceleratorBeam beam : acc.getPartMap(TileAcceleratorBeam.class).values()) {
                if (!beam.isFunctional()) continue;
                if (acc.isValidRFCavity(beam.func_174877_v(), EnumFacing.Axis.X)) {
                    acc.getRFCavityMap().put(beam.func_174877_v().func_177986_g(), (Object)new RFCavity(acc, beam.func_174877_v(), EnumFacing.Axis.X));
                    continue;
                }
                if (acc.isValidRFCavity(beam.func_174877_v(), EnumFacing.Axis.Z)) {
                    acc.getRFCavityMap().put(beam.func_174877_v().func_177986_g(), (Object)new RFCavity(acc, beam.func_174877_v(), EnumFacing.Axis.Z));
                    continue;
                }
                if (acc.isValidQuadrupole(beam.func_174877_v(), EnumFacing.Axis.X)) {
                    acc.getQuadrupoleMap().put(beam.func_174877_v().func_177986_g(), (Object)new QuadrupoleMagnet(acc, beam.func_174877_v(), EnumFacing.Axis.X));
                    continue;
                }
                if (!acc.isValidQuadrupole(beam.func_174877_v(), EnumFacing.Axis.Z)) continue;
                acc.getQuadrupoleMap().put(beam.func_174877_v().func_177986_g(), (Object)new QuadrupoleMagnet(acc, beam.func_174877_v(), EnumFacing.Axis.Z));
            }
            this.updateNumbers();
            for (RFCavity cavity : acc.getRFCavityMap().values()) {
                for (IAcceleratorComponent componet : cavity.getComponents().values()) {
                    componet.setFunctional(true);
                }
            }
            for (QuadrupoleMagnet quad : acc.getQuadrupoleMap().values()) {
                for (IAcceleratorComponent componet : quad.getComponents().values()) {
                    componet.setFunctional(true);
                }
            }
            for (TileAcceleratorPart port : acc.getPartMap(TileAcceleratorBeamPort.class).values()) {
                if (((TileAcceleratorBeamPort)port).getIOType() == EnumTypes.IOType.INPUT) {
                    acc.input = port;
                }
                if (((TileAcceleratorBeamPort)port).getIOType() != EnumTypes.IOType.OUTPUT) continue;
                acc.output = port;
            }
            ObjectIterator objectIterator = acc.getPartMap(TileAcceleratorSource.class).values().iterator();
            while (objectIterator.hasNext()) {
                TileAcceleratorSource source;
                this.source = source = (TileAcceleratorSource)objectIterator.next();
            }
            for (TileAcceleratorPart port : acc.getPartMap(TileAcceleratorPort.class).values()) {
                ((TileAcceleratorPort)port).setSource(this);
            }
        }
        this.refreshStats();
        super.onAcceleratorFormed();
    }

    @Override
    public void onMachineDisassembled() {
        this.source = null;
        super.onMachineDisassembled();
    }

    @Override
    public boolean onUpdateServer() {
        super.onUpdateServer();
        if (this.getAccelerator().isControllorOn) {
            if (this.source != null) {
                if (this.recipeInfo != null) {
                    this.produceSourceBeam();
                } else {
                    this.resetBeam();
                }
            } else {
                this.produceBeam();
            }
        } else {
            this.resetBeam();
        }
        this.push();
        this.getAccelerator().sendMultiblockUpdatePacketToListeners();
        return true;
    }

    @Override
    protected void refreshBeams() {
        this.getAccelerator().beams.get(0).setParticleStack(null);
        this.getAccelerator().beams.get(1).setParticleStack(null);
        this.pull();
    }

    @Override
    protected boolean shouldUseEnergy() {
        if (this.source != null) {
            this.refreshRecipe();
            if (this.recipeInfo != null) {
                return true;
            }
        } else if (this.getAccelerator().beams.get(0).getParticleStack() != null) {
            return true;
        }
        return false;
    }

    private void resetBeam() {
        this.getAccelerator().beams.get(1).setParticleStack(null);
    }

    private void produceSourceBeam() {
        if (((ItemStack)this.source.getInventoryStacks().get(0)).func_77973_b() instanceof IItemParticleAmount) {
            IItemParticleAmount item = (IItemParticleAmount)((ItemStack)this.source.getInventoryStacks().get(0)).func_77973_b();
            IParticleIngredient particleProduct = this.recipeInfo.getRecipe().getParticleProducts().get(0);
            if (particleProduct.getStack() != null) {
                int outputAmount = ((ParticleStack)particleProduct.getStack()).getAmount();
                if (item.getAmountStored((ItemStack)this.source.getInventoryStacks().get(0)) < outputAmount) {
                    outputAmount = item.getAmountStored((ItemStack)this.source.getInventoryStacks().get(0));
                }
                ParticleStack outputStack = (ParticleStack)particleProduct.getStack();
                outputStack.setAmount(outputAmount);
                this.getAccelerator().beams.get(1).setParticleStack(outputStack);
                ParticleStack beam = this.getAccelerator().beams.get(1).getParticleStack();
                if (this.getAccelerator().computerControlled) {
                    beam.addMeanEnergy((long)((double)Equations.linacEnergyGain(this.getAccelerator().acceleratingVoltage, beam) * ((double)this.getAccelerator().energyPercentage / 100.0)));
                } else {
                    beam.addMeanEnergy((long)((double)(Equations.linacEnergyGain(this.getAccelerator().acceleratingVoltage, beam) * (long)this.getRedstoneLevel()) / 15.0));
                }
                beam.addFocus(Equations.focusGain(this.getAccelerator().quadrupoleStrength, beam) - Equations.focusLoss(this.getBeamLength(), beam));
                if (beam.getFocus() <= 0.0) {
                    this.getAccelerator().errorCode = 3;
                }
                this.source.getInventoryStacks().set(0, (Object)item.use((ItemStack)this.source.getInventoryStacks().get(0), outputAmount));
                if (item.isEmptyItem((ItemStack)this.source.getInventoryStacks().get(0)) && !((ItemStack)this.source.getInventoryStacks().get(1)).func_190926_b()) {
                    ItemStack stack = ((ItemStack)this.source.getInventoryStacks().get(1)).func_77946_l();
                    this.source.getInventoryStacks().set(1, (Object)((ItemStack)this.source.getInventoryStacks().get(0)).func_77946_l());
                    this.source.getInventoryStacks().set(0, (Object)stack);
                }
            }
        }
    }

    private void produceBeam() {
        ParticleStack inputBeam = this.getAccelerator().beams.get(0).getParticleStack();
        if (inputBeam != null) {
            this.getAccelerator().beams.get(1).setParticleStack(inputBeam.copy());
            ParticleStack outputBeam = this.getAccelerator().beams.get(1).getParticleStack();
            if (outputBeam != null) {
                outputBeam.addFocus(Equations.focusGain(this.getAccelerator().quadrupoleStrength, outputBeam) - Equations.focusLoss(this.getBeamLength(), outputBeam));
                if (this.getAccelerator().computerControlled) {
                    outputBeam.addMeanEnergy((long)((double)Equations.linacEnergyGain(this.getAccelerator().acceleratingVoltage, outputBeam) * ((double)this.getAccelerator().energyPercentage / 100.0)));
                } else {
                    outputBeam.addMeanEnergy((long)((double)(Equations.linacEnergyGain(this.getAccelerator().acceleratingVoltage, outputBeam) * (long)this.getRedstoneLevel()) / 15.0));
                }
                if (outputBeam.getFocus() <= 0.0) {
                    outputBeam = null;
                    this.getAccelerator().errorCode = 3;
                }
            }
        }
    }

    protected void refreshRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack item = IItemParticleAmount.cleanNBT((ItemStack)this.source.getInventoryStacks().get(0));
        items.add(item);
        this.recipeInfo = QMDRecipes.accelerator_source.getRecipeInfoFromInputs(items, new ArrayList<Tank>(), new ArrayList<ParticleStack>());
    }

    @Override
    public AcceleratorUpdatePacket getMultiblockUpdatePacket() {
        return new LinearAcceleratorUpdatePacket(this.getAccelerator().controller.getTilePos(), this.getAccelerator().isControllorOn, this.getAccelerator().cooling, this.getAccelerator().rawHeating, this.getAccelerator().currentHeating, this.getAccelerator().maxCoolantIn, this.getAccelerator().maxCoolantOut, this.getAccelerator().maxOperatingTemp, this.getAccelerator().requiredEnergy, this.getAccelerator().efficiency, this.getAccelerator().acceleratingVoltage, this.getAccelerator().RFCavityNumber, this.getAccelerator().quadrupoleNumber, this.getAccelerator().quadrupoleStrength, this.getAccelerator().dipoleNumber, this.getAccelerator().dipoleStrength, this.getAccelerator().errorCode, this.getAccelerator().heatBuffer, this.getAccelerator().energyStorage, this.getAccelerator().tanks, this.getAccelerator().beams);
    }

    @Override
    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof LinearAcceleratorUpdatePacket) {
            LinearAcceleratorUpdatePacket linearAcceleratorUpdatePacket = (LinearAcceleratorUpdatePacket)message;
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
    }

    @Override
    public int getBeamLength() {
        return this.getAccelerator().getExteriorLengthX() > this.getAccelerator().getExteriorLengthZ() ? this.getAccelerator().getExteriorLengthX() : this.getAccelerator().getExteriorLengthZ();
    }

    @Override
    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }

    public TileAcceleratorSource getSource() {
        return this.source;
    }
}

