/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.generator;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGCraft;
import gcewing.sg.util.SGChunkData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NaquadahOreWorldGen
implements IWorldGenerator {
    static int genUnderLavaOdds = 1;
    static int maxNodesUnderLava = 16;
    static int genIsolatedOdds = 1;
    static int maxIsolatedNodes = 4;
    static boolean debugLava = false;
    static boolean debugRandom = false;
    static int debugLevel = 0;
    static String dimensionIDs = "0";
    Random random;
    World world;
    Chunk chunk;
    int x0;
    int z0;
    Block stone = Blocks.field_150348_b;
    Block lava = Blocks.field_150353_l;
    IBlockState naquadah = SGCraft.naquadahOre.func_176223_P();
    String[] dimensions = dimensionIDs.split(",");

    public static void configure(BaseConfiguration cfg) {
        genUnderLavaOdds = cfg.getInteger("naquadah", "genUnderLavaOdds", genUnderLavaOdds);
        maxNodesUnderLava = cfg.getInteger("naquadah", "maxNodesUnderLava", maxNodesUnderLava);
        genIsolatedOdds = cfg.getInteger("naquadah", "genIsolatedOdds", genIsolatedOdds);
        maxIsolatedNodes = cfg.getInteger("naquadah", "maxIsolatedNodes", maxIsolatedNodes);
        debugLava = cfg.getBoolean("naquadah", "debugLava", debugLava);
        debugRandom = cfg.getBoolean("naquadah", "debugRandom", debugRandom);
        debugLevel = cfg.getInteger("naquadah", "debugLevel", debugLevel);
        dimensionIDs = cfg.getString("naquadah", "dimensionIDs", dimensionIDs);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.random = random;
        this.world = world;
        this.x0 = chunkX * 16;
        this.z0 = chunkZ * 16;
        this.chunk = world.func_72964_e(chunkX, chunkZ);
        for (String dimension : this.dimensions) {
            try {
                if (world.field_73011_w.getDimension() != Integer.parseInt(dimension.replace(" ", ""))) continue;
                this.generateChunk();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void regenerate(Chunk chunk) {
        this.chunk = chunk;
        this.world = chunk.func_177412_p();
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        long worldSeed = this.world.func_72905_C();
        this.random = new Random(worldSeed);
        long xSeed = this.random.nextLong() >> 3;
        long zSeed = this.random.nextLong() >> 3;
        this.random.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        this.x0 = chunkX * 16;
        this.z0 = chunkZ * 16;
        for (String dimension : this.dimensions) {
            try {
                if (this.world.field_73011_w.getDimension() != Integer.parseInt(dimension.replace(" ", ""))) continue;
                this.generateChunk();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    Block getBlock(int x, int y, int z) {
        return this.getBlock(new BlockPos(x, y, z));
    }

    Block getBlock(BlockPos pos) {
        return this.chunk.func_177435_g(pos).func_177230_c();
    }

    boolean isSolidBlock(int x, int y, int z) {
        return this.isSolidBlock(new BlockPos(x, y, z));
    }

    boolean isSolidBlock(BlockPos pos) {
        IBlockState state = this.chunk.func_177435_g(pos);
        return state.func_185904_a().func_76220_a();
    }

    void setBlockState(BlockPos pos, IBlockState state) {
        this.chunk.func_177436_a(pos, state);
    }

    void generateNode(IBlockState id, int x, int y, int z, int sx, int sy, int sz) {
        int dx = this.random.nextInt(sx);
        int dy = this.random.nextInt(sy);
        int dz = this.random.nextInt(sz);
        int h = this.world.func_72800_K();
        if (debugRandom && debugLevel >= 1) {
            System.out.printf("NaquadahOreWorldGen: %d x %d x %d node at (%d, %d, %d)\n", dx + 1, dy + 1, dz + 1, this.x0 + x, y, this.z0 + z);
        }
        for (int i = x; i <= x + dx; ++i) {
            for (int j = y; j <= y + dy; ++j) {
                for (int k = z; k <= z + dz; ++k) {
                    BlockPos pos;
                    if (i >= 16 || j >= h || k >= 16 || !this.isSolidBlock(pos = new BlockPos(i, j, k))) continue;
                    if (debugRandom && debugLevel >= 2) {
                        System.out.printf("NaquadahOreWorldGen: block at (%d, %d, %d)\n", this.x0 + i, j, this.z0 + k);
                    }
                    this.setBlockState(pos, id);
                }
            }
        }
    }

    boolean odds(int n) {
        return this.random.nextInt(n) == 0;
    }

    void generateChunk() {
        int x;
        int i;
        int n;
        SGChunkData.forChunk((Chunk)this.chunk).oresGenerated = true;
        if (this.odds(genUnderLavaOdds)) {
            n = this.random.nextInt(maxNodesUnderLava) + 1;
            for (i = 0; i < n; ++i) {
                x = this.random.nextInt(16);
                int z = this.random.nextInt(16);
                for (int y = 1; y < 64; ++y) {
                    if (!this.isSolidBlock(x, y, z) || this.getBlock(x, y + 1, z) != this.lava) continue;
                    if (debugLava) {
                        System.out.printf("NaquadahOreWorldGen: generating under lava at (%d, %d, %d)\n", this.x0 + x, y, this.z0 + z);
                    }
                    this.generateNode(this.naquadah, x, y, z, 3, 1, 3);
                }
            }
        }
        if (genIsolatedOdds > 0 && this.odds(genIsolatedOdds)) {
            n = this.random.nextInt(maxIsolatedNodes) + 1;
            for (i = 0; i < n; ++i) {
                int z;
                int y;
                x = this.random.nextInt(16);
                if (!this.isSolidBlock(x, y = this.random.nextInt(16) + 16, z = this.random.nextInt(16))) continue;
                if (debugRandom) {
                    System.out.printf("NaquadahOreWorldGen: generating randomly at (%d, %d, %d)\n", this.x0 + x, y, this.z0 + z);
                }
                this.generateNode(this.naquadah, x, y, z, 2, 2, 2);
            }
        }
    }
}

