/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.biome;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeNibiru;
import stevekung.mods.stevekunglib.world.gen.EnumOreGen;
import stevekung.mods.stevekunglib.world.gen.WorldGenMinableBase;

public class BiomeInfectedBadlands
extends BiomeNibiru {
    private IBlockState[] clayBands;
    private long seed;
    private NoiseGeneratorPerlin pillarNoise;
    private NoiseGeneratorPerlin pillarRoofNoise;
    private NoiseGeneratorPerlin clayBandsOffsetNoise;
    private final boolean brycePillars;
    private final boolean hasForest;
    private final WorldGenerator goldGen;

    public BiomeInfectedBadlands(Biome.BiomeProperties prop, boolean brycePillars, boolean hasForest) {
        super(prop);
        this.brycePillars = brycePillars;
        this.hasForest = hasForest;
        this.field_76752_A = MPBlocks.INFECTED_SAND.func_176223_P();
        this.field_76753_B = Blocks.field_150406_ce.func_176223_P();
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76804_C = 20;
        this.field_76760_I.field_76799_E = 3;
        this.field_76760_I.field_76800_F = 5;
        this.field_76760_I.field_76802_A = 0;
        this.goldGen = new WorldGenMinableBase(MPBlocks.INFECTED_GOLD_ORE.func_176223_P(), MPBlocks.NIBIRU_ROCK.func_176223_P(), EnumOreGen.GOLD);
        if (hasForest) {
            this.field_76760_I.field_76832_z = 5;
        }
    }

    @Override
    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        this.field_76760_I.generateOre(this.goldGen, 20, 32, 80, world, rand);
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random rand) {
        return rand.nextInt(20) == 0 ? BiomeNibiru.TREE_NO_LEAVES : BiomeNibiru.TREE;
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int chunkX, int chunkZ, double noiseVal) {
        if (this.clayBands == null || this.seed != world.func_72905_C()) {
            this.generateBands(world.func_72905_C());
        }
        if (this.pillarNoise == null || this.pillarRoofNoise == null || this.seed != world.func_72905_C()) {
            Random random = new Random(this.seed);
            this.pillarNoise = new NoiseGeneratorPerlin(random, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlin(random, 1);
        }
        this.seed = world.func_72905_C();
        double d4 = 0.0;
        if (this.brycePillars) {
            int i = (chunkX & 0xFFFFFFF0) + (chunkZ & 0xF);
            int j = (chunkZ & 0xFFFFFFF0) + (chunkX & 0xF);
            double d0 = Math.min(Math.abs(noiseVal), this.pillarNoise.func_151601_a((double)i * 0.25, (double)j * 0.25));
            if (d0 > 0.0) {
                d4 = d0 * d0 * 2.5;
                double d2 = Math.abs(this.pillarRoofNoise.func_151601_a((double)i * 0.001953125, (double)j * 0.001953125));
                double d3 = Math.ceil(d2 * 50.0) + 14.0;
                if (d4 > d3) {
                    d4 = d3;
                }
                d4 += 64.0;
            }
        }
        int k1 = chunkX & 0xF;
        int l1 = chunkZ & 0xF;
        int i2 = world.func_181545_F();
        IBlockState iblockstate = Blocks.field_150406_ce.func_176223_P();
        IBlockState iblockstate3 = this.field_76753_B;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        boolean flag = Math.cos(noiseVal / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (primer.func_177856_a(l1, j1, k1).func_185904_a() == Material.field_151579_a && j1 < (int)d4) {
                primer.func_177855_a(l1, j1, k1, MPBlocks.NIBIRU_ROCK.func_176223_P());
            }
            if (j1 <= rand.nextInt(5)) {
                primer.func_177855_a(l1, j1, k1, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (i1 >= 15 && !this.brycePillars) continue;
            IBlockState iblockstate1 = primer.func_177856_a(l1, j1, k1);
            if (iblockstate1.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (iblockstate1.func_177230_c() != MPBlocks.NIBIRU_ROCK) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    iblockstate = Blocks.field_150350_a.func_176223_P();
                    iblockstate3 = MPBlocks.NIBIRU_ROCK.func_176223_P();
                } else if (j1 >= i2 - 4 && j1 <= i2 + 1) {
                    iblockstate = Blocks.field_150406_ce.func_176223_P();
                    iblockstate3 = this.field_76753_B;
                }
                if (j1 < i2 && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = MPBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P();
                }
                l = k + Math.max(0, j1 - i2);
                if (j1 >= i2 - 1) {
                    if (this.hasForest && j1 > 86 + k * 2) {
                        if (flag) {
                            primer.func_177855_a(l1, j1, k1, MPBlocks.INFECTED_COARSE_DIRT.func_176223_P());
                        } else {
                            primer.func_177855_a(l1, j1, k1, MPBlocks.INFECTED_GRASS_BLOCK.func_176223_P());
                        }
                    } else if (j1 > i2 + 3 + k) {
                        IBlockState iblockstate2 = j1 >= 64 && j1 <= 127 ? (flag ? Blocks.field_150405_ch.func_176223_P() : this.getBand(chunkX, j1, chunkZ)) : Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE);
                        primer.func_177855_a(l1, j1, k1, iblockstate2);
                    } else {
                        primer.func_177855_a(l1, j1, k1, this.field_76752_A);
                        flag1 = true;
                    }
                } else {
                    primer.func_177855_a(l1, j1, k1, iblockstate3);
                    if (iblockstate3.func_177230_c() == Blocks.field_150406_ce) {
                        primer.func_177855_a(l1, j1, k1, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE));
                    }
                }
            } else if (l > 0) {
                --l;
                if (flag1) {
                    primer.func_177855_a(l1, j1, k1, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE));
                } else {
                    primer.func_177855_a(l1, j1, k1, this.getBand(chunkX, j1, chunkZ));
                }
            }
            ++i1;
        }
    }

    private void generateBands(long seed) {
        this.clayBands = new IBlockState[64];
        Arrays.fill(this.clayBands, Blocks.field_150405_ch.func_176223_P());
        Random random = new Random(seed);
        this.clayBandsOffsetNoise = new NoiseGeneratorPerlin(random, 1);
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += random.nextInt(5) + 1) >= 64) continue;
            this.clayBands[l1] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE);
        }
        int i2 = random.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = random.nextInt(3) + 1;
            int k = random.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.clayBands[k + l] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
        }
        int j2 = random.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = random.nextInt(3) + 2;
            int l3 = random.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.clayBands[l3 + i1] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN);
            }
        }
        int l2 = random.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = random.nextInt(3) + 1;
            int k4 = random.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.clayBands[k4 + j1] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
            }
        }
        int k3 = random.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            j4 += random.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.clayBands[j4 + k1] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE);
                if (j4 + k1 > 1 && random.nextBoolean()) {
                    this.clayBands[j4 + k1 - 1] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
                }
                if (j4 + k1 >= 63 || !random.nextBoolean()) continue;
                this.clayBands[j4 + k1 + 1] = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
            }
        }
    }

    private IBlockState getBand(int x, int y, int z) {
        int i = (int)Math.round(this.clayBandsOffsetNoise.func_151601_a((double)x / 512.0, (double)z / 512.0) * 2.0);
        return this.clayBands[(y + i + 64) % 64];
    }
}

