/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import bq_standard.client.theme.BQSTextures;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.TaskInteractItem;
import java.util.UUID;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public class PanelTaskInteractItem
extends CanvasEmpty {
    private final TaskInteractItem task;

    public PanelTaskInteractItem(IGuiRect rect, TaskInteractItem task) {
        super(rect);
        this.task = task;
    }

    public void initPanel() {
        super.initPanel();
        PanelItemSlot itemSlot = new PanelItemSlot((IGuiRect)new GuiTransform(GuiAlign.MID_LEFT, 0, -48, 32, 32, 0), -1, this.task.targetItem, false, true);
        this.addPanel((IGuiPanel)itemSlot);
        PanelItemSlot targetSlot = new PanelItemSlot((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, 16, -32, 32, 32, 0), -1, this.task.targetBlock.getItemStack(), false, true);
        this.addPanel((IGuiPanel)targetSlot);
        if (BQ_Standard.hasJEI) {
            itemSlot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
            targetSlot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
        }
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -8, -32, 16, 16, 0), PresetIcon.ICON_RIGHT.getTexture()));
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int prog = this.task.getUsersProgress(playerID);
        this.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -16, -14, 32, 14, 0), prog + "/" + this.task.required).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor()));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -48, 8, 24, 24, 0), BQSTextures.HAND_LEFT.getTexture()));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -24, 8, 24, 24, 0), BQSTextures.HAND_RIGHT.getTexture()));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, 0, 8, 24, 24, 0), BQSTextures.ATK_SYMB.getTexture()));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, 24, 8, 24, 24, 0), BQSTextures.USE_SYMB.getTexture()));
        GuiTextureColored txTick = new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), (IGuiColor)new GuiColorStatic(-16711936));
        GuiTextureColored txCross = new GuiTextureColored(PresetIcon.ICON_CROSS.getTexture(), (IGuiColor)new GuiColorStatic(-65536));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -32, 24, 8, 8, 0), (IGuiTexture)(this.task.useOffHand ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -8, 24, 8, 8, 0), (IGuiTexture)(this.task.useMainHand ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, 16, 24, 8, 8, 0), (IGuiTexture)(this.task.onHit ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, 40, 24, 8, 8, 0), (IGuiTexture)(this.task.onInteract ? txTick : txCross)));
    }

    @Optional.Method(modid="jei")
    private void lookupRecipe(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || Internal.getRuntime() == null) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(IFocus.Mode.OUTPUT, (Object)stack));
    }
}

