/*
 * Decompiled with CFR 0.152.
 */
package bq_msi.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_msi.MultiblockInventory;
import bq_msi.NbtBlockType;
import bq_msi.client.gui.PanelTaskMultiblock;
import bq_msi.tasks.factory.FactoryTaskMultiblock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TaskMultiblock
implements ITask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final HashMap<UUID, Integer> userProgress = new HashMap();
    public static HashMap<String, MultiblockInventory> multiblockHash = new HashMap();
    public BigItemStack targetItem = new BigItemStack(Items.field_190931_a);
    public final NbtBlockType targetBlock = new NbtBlockType(Blocks.field_150350_a);
    public boolean render = false;
    public String fileNames = "";
    public int length = 0;
    public int width = 0;
    public int height = 0;
    public boolean wildcardOptimization = false;
    public String name = "New Multiblock Name";
    public boolean gameStageCompat = false;
    public String gameStageName = "";
    public boolean useImage = false;
    public String imageLocation = "";

    public static String clearHashmap() {
        if (multiblockHash.size() == 0) {
            return "No cached files.";
        }
        String returnable = "Cleared cached files:";
        for (String key : multiblockHash.keySet()) {
            returnable = returnable + " " + key;
        }
        multiblockHash.clear();
        return returnable;
    }

    public static String getHashmapContents() {
        if (multiblockHash.size() == 0) {
            return "No cached files.";
        }
        String returnable = "Cached files:";
        for (String key : multiblockHash.keySet()) {
            returnable = returnable + " " + key;
        }
        return returnable;
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskMultiblock.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_msi.task.multiblock";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Tuple<UUID, Integer>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if ((Integer)value.func_76340_b() >= 1) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    @Nullable
    public MultiblockInventory fileData(String fileName, int length, int width, int height) {
        File file = new File(Loader.instance().getConfigDir() + File.separator + "betterquesting" + File.separator + "resources" + File.separator + fileName);
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String[][][] fileArray = new String[length][width][height];
            int[] keyCoords = new int[3];
            String separator = ".";
            String keyBlock = "keyBlock";
            int heightCount = 0;
            int lengthCount = 0;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.trim().contentEquals(separator.trim())) {
                    ++heightCount;
                    lengthCount = 0;
                    continue;
                }
                if (line.trim().contentEquals("")) continue;
                String[] blocks = line.split(",");
                for (int i = 0; i < blocks.length; ++i) {
                    if (blocks[i].trim().contentEquals("")) continue;
                    fileArray[lengthCount][i][heightCount] = blocks[i].trim();
                    if (!blocks[i].trim().contentEquals(keyBlock)) continue;
                    fileArray[lengthCount][i][heightCount] = "wildcard";
                    keyCoords[0] = lengthCount;
                    keyCoords[1] = i;
                    keyCoords[2] = heightCount;
                }
                ++lengthCount;
            }
            bufferedReader.close();
            return new MultiblockInventory(fileArray, keyCoords);
        }
        catch (IOException ex) {
            if (ex instanceof FileNotFoundException) {
                System.out.println("TaskMultiblock tried to access non-existant file" + ex);
                return null;
            }
            System.out.println(ex);
            return null;
        }
    }

    public boolean matchData(World world, IBlockState state, BlockPos pos, int length, int width, int height, boolean wildcardOptimization, MultiblockInventory inventory) {
        String[][][] fileArray = inventory.getFileArray();
        int[] keyCoords = inventory.getKeyCoords();
        int keyLength = keyCoords[0];
        int keyWidth = keyCoords[1];
        int keyHeight = keyCoords[2];
        boolean rot0 = true;
        boolean rot1 = true;
        boolean rot2 = true;
        boolean rot3 = true;
        if (wildcardOptimization) {
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    for (int l = 0; l < length; ++l) {
                        if (fileArray[l][w][h].contentEquals("wildcard")) continue;
                        for (int rot = 0; rot < 4; ++rot) {
                            String fileBlock;
                            String targetBlock;
                            IBlockState targetState;
                            int z;
                            int y;
                            int x;
                            if (rot == 0 && rot0) {
                                x = -keyLength + l + pos.func_177958_n();
                                y = -keyHeight + h + pos.func_177956_o();
                                z = keyWidth + -w + pos.func_177952_p();
                                targetState = world.func_180495_p(new BlockPos(x, y, z));
                                targetBlock = targetState.func_177230_c().getRegistryName().toString();
                                targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                                if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                    rot0 = false;
                                }
                            }
                            if (rot == 1 && rot1) {
                                x = keyLength + -l + pos.func_177958_n();
                                y = -keyHeight + h + pos.func_177956_o();
                                z = -keyWidth + w + pos.func_177952_p();
                                targetState = world.func_180495_p(new BlockPos(x, y, z));
                                targetBlock = targetState.func_177230_c().getRegistryName().toString();
                                targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                                if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                    rot1 = false;
                                }
                            }
                            if (rot == 2 && rot2) {
                                x = -keyWidth + w + pos.func_177958_n();
                                y = -keyHeight + h + pos.func_177956_o();
                                z = -keyLength + l + pos.func_177952_p();
                                targetState = world.func_180495_p(new BlockPos(x, y, z));
                                targetBlock = targetState.func_177230_c().getRegistryName().toString();
                                targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                                if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                    rot2 = false;
                                }
                            }
                            if (rot == 3 && rot3) {
                                x = keyWidth + -w + pos.func_177958_n();
                                y = -keyHeight + h + pos.func_177956_o();
                                z = keyLength + -l + pos.func_177952_p();
                                targetState = world.func_180495_p(new BlockPos(x, y, z));
                                targetBlock = targetState.func_177230_c().getRegistryName().toString();
                                targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                                if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                    rot3 = false;
                                }
                            }
                            if (rot0 || rot1 || rot2 || rot3) continue;
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                for (int l = 0; l < length; ++l) {
                    for (int rot = 0; rot < 4; ++rot) {
                        String fileBlock;
                        String targetBlock;
                        IBlockState targetState;
                        int z;
                        int y;
                        int x;
                        if (rot == 0 && rot0) {
                            x = -keyLength + l + pos.func_177958_n();
                            y = -keyHeight + h + pos.func_177956_o();
                            z = keyWidth + -w + pos.func_177952_p();
                            targetState = world.func_180495_p(new BlockPos(x, y, z));
                            targetBlock = targetState.func_177230_c().getRegistryName().toString();
                            targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                            if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                rot0 = false;
                            }
                        }
                        if (rot == 1 && rot1) {
                            x = keyLength + -l + pos.func_177958_n();
                            y = -keyHeight + h + pos.func_177956_o();
                            z = -keyWidth + w + pos.func_177952_p();
                            targetState = world.func_180495_p(new BlockPos(x, y, z));
                            targetBlock = targetState.func_177230_c().getRegistryName().toString();
                            targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                            if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                rot1 = false;
                            }
                        }
                        if (rot == 2 && rot2) {
                            x = -keyWidth + w + pos.func_177958_n();
                            y = -keyHeight + h + pos.func_177956_o();
                            z = -keyLength + l + pos.func_177952_p();
                            targetState = world.func_180495_p(new BlockPos(x, y, z));
                            targetBlock = targetState.func_177230_c().getRegistryName().toString();
                            targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                            if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                rot2 = false;
                            }
                        }
                        if (rot == 3 && rot3) {
                            x = keyWidth + -w + pos.func_177958_n();
                            y = -keyHeight + h + pos.func_177956_o();
                            z = keyLength + -l + pos.func_177952_p();
                            targetState = world.func_180495_p(new BlockPos(x, y, z));
                            targetBlock = targetState.func_177230_c().getRegistryName().toString();
                            targetBlock = (fileBlock = fileArray[l][w][h]).substring(fileBlock.length() - 1).equalsIgnoreCase("*") ? targetBlock + ":*" : targetBlock + ":" + targetState.func_177230_c().func_176201_c(targetState);
                            if (!fileBlock.contentEquals(targetBlock) && !fileBlock.contentEquals("wildcard")) {
                                rot3 = false;
                            }
                        }
                        if (rot0 || rot1 || rot2 || rot3) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void onInteract(ParticipantInfo pInfo, DBEntry<IQuest> quest, EnumHand hand, ItemStack item, IBlockState state, BlockPos pos) {
        if (!pInfo.PLAYER.func_70089_S() || !(pInfo.PLAYER instanceof EntityPlayerMP)) {
            return;
        }
        World world = pInfo.PLAYER.field_70170_p;
        if (this.targetBlock.b != Blocks.field_150350_a && this.targetBlock.b == state.func_177230_c() && ItemComparison.StackMatch((ItemStack)this.targetItem.getBaseStack(), (ItemStack)item, (boolean)false, (boolean)false)) {
            if (state.func_177230_c() == Blocks.field_150350_a) {
                return;
            }
            if (hand != EnumHand.MAIN_HAND) {
                return;
            }
            String[] nameList = this.fileNames.split(",");
            if (this.gameStageCompat && Loader.isModLoaded((String)"gamestages") && !GameStageHelper.hasStage((EntityPlayer)pInfo.PLAYER, (String)this.gameStageName)) {
                return;
            }
            for (String name : nameList) {
                if (multiblockHash.get(name.trim()) == null) {
                    MultiblockInventory invenToCache = this.fileData(name.trim(), this.length, this.width, this.height);
                    if (invenToCache == null) {
                        System.out.println("Multiblock task attempted to cache broken file " + name);
                        return;
                    }
                    System.out.println("Multiblock " + name + " has been cached!");
                    multiblockHash.put(name, invenToCache);
                }
                if (!this.matchData(world, state, pos, this.length, this.width, this.height, this.wildcardOptimization, multiblockHash.get(name))) continue;
                List<Tuple<UUID, Integer>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
                progress.forEach(value -> {
                    if (this.isComplete((UUID)value.func_76341_a())) {
                        return;
                    }
                    int np = Math.min(1, (Integer)value.func_76340_b() + 1);
                    this.setUserProgress((UUID)value.func_76341_a(), np);
                    if (np >= 1) {
                        this.setComplete((UUID)value.func_76341_a());
                    }
                });
                pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
                return;
            }
        }
    }

    public synchronized NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)this.targetItem.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("block", (NBTBase)this.targetBlock.writeToNBT(new NBTTagCompound()));
        nbt.func_74778_a("fileNames", this.fileNames);
        nbt.func_74768_a("length", this.length);
        nbt.func_74768_a("width", this.width);
        nbt.func_74768_a("height", this.height);
        nbt.func_74757_a("wildcardOptimization", this.wildcardOptimization);
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("gameStageCompat", this.gameStageCompat);
        nbt.func_74778_a("gameStageName", this.gameStageName);
        nbt.func_74757_a("useImage", this.useImage);
        nbt.func_74778_a("imageLocation", this.imageLocation);
        return nbt;
    }

    public synchronized void readFromNBT(NBTTagCompound nbt) {
        this.targetItem = new BigItemStack(nbt.func_74775_l("item"));
        this.targetBlock.readFromNBT(nbt.func_74775_l("block"));
        this.fileNames = nbt.func_74779_i("fileNames");
        this.length = nbt.func_74762_e("length");
        this.width = nbt.func_74762_e("width");
        this.height = nbt.func_74762_e("height");
        this.wildcardOptimization = nbt.func_74767_n("wildcardOptimization");
        this.name = nbt.func_74779_i("name");
        this.gameStageCompat = nbt.func_74767_n("gameStageCompat");
        this.gameStageName = nbt.func_74779_i("gameStageName");
        this.useImage = nbt.func_74767_n("useImage");
        this.imageLocation = nbt.func_74779_i("imageLocation");
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Integer data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74768_a("value", data.intValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74768_a("value", data.intValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74762_e("value"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setUserProgress(UUID uuid, Integer progress) {
        this.userProgress.put(uuid, progress);
    }

    public int getUsersProgress(UUID uuid) {
        Integer n = this.userProgress.get(uuid);
        return n == null ? 0 : n;
    }

    private List<Tuple<UUID, Integer>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<UUID, Integer>> list = new ArrayList<Tuple<UUID, Integer>>();
        uuids.forEach(key -> list.add(new Tuple(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskMultiblock(rect, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }
}

