/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world;

import com.google.common.collect.ListMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadingCallback
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static HashMap<String, HashMap<Integer, HashSet<BlockPos>>> chunkLoaderList = new HashMap();
    private static boolean loadOnLogin;

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int tileZ;
            int tileY;
            int tileX;
            TileEntity tile;
            NBTTagCompound nbt = ticket.getModData();
            if (nbt == null || !((tile = world.func_175625_s(new BlockPos(tileX = nbt.func_74762_e("ChunkLoaderTileX"), tileY = nbt.func_74762_e("ChunkLoaderTileY"), tileZ = nbt.func_74762_e("ChunkLoaderTileZ")))) instanceof IChunkLoader)) continue;
            ((IChunkLoader)tile).onTicketLoaded(ticket, false);
        }
    }

    public static void addToList(World world, int x, int y, int z, String playerName) {
        HashSet<Object> chunkLoaders;
        HashMap<Integer, HashSet<Object>> dimensionMap = chunkLoaderList.get(playerName);
        if (dimensionMap == null) {
            dimensionMap = new HashMap();
            chunkLoaderList.put(playerName, dimensionMap);
        }
        if ((chunkLoaders = dimensionMap.get(world.field_73011_w.getDimension())) == null) {
            chunkLoaders = new HashSet();
        }
        chunkLoaders.add(new BlockPos(x, y, z));
        dimensionMap.put(GCCoreUtil.getDimensionID(world), chunkLoaders);
        chunkLoaderList.put(playerName, dimensionMap);
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket, World world, int x, int y, int z, String playerName) {
        ChunkLoadingCallback.addToList(world, x, y, z, playerName);
        ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
    }

    public static void onPlayerLogin(EntityPlayer player) {
        for (Map.Entry<String, HashMap<Integer, HashSet<BlockPos>>> playerEntry : chunkLoaderList.entrySet()) {
            if (!PlayerUtil.getName(player).equals(playerEntry.getKey())) continue;
            for (Map.Entry<Integer, HashSet<BlockPos>> dimensionEntry : playerEntry.getValue().entrySet()) {
                int dimID = dimensionEntry.getKey();
                if (!loadOnLogin) continue;
                player.field_70170_p.func_73046_m().func_71218_a(dimID);
            }
        }
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }
}

