/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlabGC
extends BlockSlab
implements ISortableBlock {
    public static final PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockSlabGC(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.field_149783_u = true;
    }

    public BlockSlabGC(Material material) {
        super(material);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < (GalacticraftCore.isPlanetsLoaded ? 7 : 4); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 7;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)GCBlocks.slabGCHalf);
    }

    public int func_149745_a(Random rand) {
        return this.func_176552_j() ? 2 : 1;
    }

    public CreativeTabs func_149708_J() {
        return this.func_176552_j() ? null : GalacticraftCore.galacticraftBlocksTab;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (!(block instanceof BlockSlabGC)) {
            return 0.0f;
        }
        switch (this.func_176201_c(blockState)) {
            case 2: 
            case 3: {
                return 1.5f;
            }
        }
        return 2.0f;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state) & 7);
    }

    public String func_150002_b(int meta) {
        BlockType type = (BlockType)((Object)this.func_176203_a(meta).func_177229_b(VARIANT));
        return type.getLangName();
    }

    public boolean func_176552_j() {
        return false;
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return BlockType.byMetadata(stack.func_77960_j() & 7);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.byMetadata(meta & 7)));
        if (!this.func_176552_j()) {
            state = state.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((BlockType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.SLABS;
    }

    public static final class BlockType
    extends Enum<BlockType>
    implements IStringSerializable {
        public static final /* enum */ BlockType TIN_SLAB_1;
        public static final /* enum */ BlockType TIN_SLAB_2;
        public static final /* enum */ BlockType MOON_STONE_SLAB;
        public static final /* enum */ BlockType MOON_DUNGEON_BRICK_SLAB;
        public static final /* enum */ BlockType MARS_COBBLESTONE_SLAB;
        public static final /* enum */ BlockType MARS_DUNGEON_SLAB;
        public static final /* enum */ BlockType ASTEROIDS_DECO;
        private int meta;
        private String langName;
        private static BlockType[] META_LOOKUP;
        private static final /* synthetic */ BlockType[] $VALUES;

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String name) {
            return Enum.valueOf(BlockType.class, name);
        }

        private BlockType(int meta, String langName) {
            this.meta = meta;
            this.langName = langName;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.langName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static BlockType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String getLangName() {
            return this.langName;
        }

        static {
            BlockType[] var0;
            TIN_SLAB_1 = new BlockType(0, "tin_slab_1");
            TIN_SLAB_2 = new BlockType(1, "tin_slab_2");
            MOON_STONE_SLAB = new BlockType(2, "moon_slab");
            MOON_DUNGEON_BRICK_SLAB = new BlockType(3, "moon_bricks_slab");
            MARS_COBBLESTONE_SLAB = new BlockType(4, "mars_slab");
            MARS_DUNGEON_SLAB = new BlockType(5, "mars_bricks_slab");
            ASTEROIDS_DECO = new BlockType(6, "asteroids_slab");
            $VALUES = new BlockType[]{TIN_SLAB_1, TIN_SLAB_2, MOON_STONE_SLAB, MOON_DUNGEON_BRICK_SLAB, MARS_COBBLESTONE_SLAB, MARS_DUNGEON_SLAB, ASTEROIDS_DECO};
            META_LOOKUP = new BlockType[BlockType.values().length];
            BlockType[] blockTypeArray = var0 = BlockType.values();
            int n = blockTypeArray.length;
            for (int i = 0; i < n; ++i) {
                BlockType var3;
                BlockType.META_LOOKUP[var3.getMetadata()] = var3 = blockTypeArray[i];
            }
        }
    }
}

