/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import java.util.function.Predicate;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialType;
import micdoodle8.mods.galacticraft.api.galaxies.ICelestial;
import net.minecraft.util.text.translation.I18n;

public abstract class CelestialObject
implements ICelestial {
    protected final String bodyName;
    private CelestialType type;
    public String ownerId;

    public CelestialObject(CelestialType type, String bodyName) {
        this(bodyName);
        this.type = type;
    }

    public CelestialObject(String bodyName) {
        this.bodyName = bodyName;
    }

    @Override
    public String getName() {
        return this.bodyName;
    }

    public String getTranslationKey() {
        return this.getCelestialType().toString() + "." + this.bodyName;
    }

    public CelestialType getCelestialType() {
        return this.type;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getTranslatedName() {
        return I18n.func_74838_a((String)this.getTranslationKey());
    }

    public static Predicate<CelestialObject> filter(final String modId) {
        return new Predicate<CelestialObject>(){

            @Override
            public boolean test(CelestialObject celestialObject) {
                return celestialObject.getOwnerId().equals(modId);
            }
        };
    }

    public void setType(CelestialType type) {
        this.type = type;
    }

    @Override
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }
}

