/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.tuple;

import io.github.phantamanta44.libnine.util.function.IQuadConsumer;
import io.github.phantamanta44.libnine.util.function.IQuadFunction;
import io.github.phantamanta44.libnine.util.tuple.ITriple;

public interface IQuadruple<A, B, C, D> {
    public A getA();

    public B getB();

    public C getC();

    public D getD();

    default public ITriple<B, C, D> truncateA() {
        return ITriple.of(this.getB(), this.getC(), this.getD());
    }

    default public ITriple<A, C, D> truncateB() {
        return ITriple.of(this.getA(), this.getC(), this.getD());
    }

    default public ITriple<A, B, D> truncateC() {
        return ITriple.of(this.getA(), this.getB(), this.getD());
    }

    default public ITriple<A, B, C> truncateD() {
        return ITriple.of(this.getA(), this.getB(), this.getC());
    }

    default public void sprexec(IQuadConsumer<A, B, C, D> executor) {
        executor.accept(this.getA(), this.getB(), this.getC(), this.getD());
    }

    default public <T> T sprcall(IQuadFunction<A, B, C, D, T> executor) {
        return executor.apply(this.getA(), this.getB(), this.getC(), this.getD());
    }

    public static <A, B, C, D> IQuadruple<A, B, C, D> of(A a, B b, C c, D d) {
        return new Impl(a, b, c, d);
    }

    public static class Impl<A, B, C, D>
    implements IQuadruple<A, B, C, D> {
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        private Impl(A a, B b, C c, D d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        @Override
        public A getA() {
            return this.a;
        }

        @Override
        public B getB() {
            return this.b;
        }

        @Override
        public C getC() {
            return this.c;
        }

        @Override
        public D getD() {
            return this.d;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IQuadruple)) {
                return false;
            }
            IQuadruple quad = (IQuadruple)o;
            return quad.getA().equals(this.a) && quad.getB().equals(this.b) && quad.getC().equals(this.c) && quad.getD().equals(this.d);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode() & this.d.hashCode();
        }
    }
}

