/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render.shader;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.util.helper.ResourceUtils;
import io.github.phantamanta44.libnine.util.render.RenderUtils;
import io.github.phantamanta44.libnine.util.render.shader.IShader;
import io.github.phantamanta44.libnine.util.render.shader.IShaderProgram;
import io.github.phantamanta44.libnine.util.render.shader.ShaderType;
import io.github.phantamanta44.libnine.util.render.shader.Uniform;
import io.github.phantamanta44.libnine.util.render.shader.UniformType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ShaderUtils {
    private static final Set<ShaderProgramImpl> validShaders = new HashSet<ShaderProgramImpl>();

    public static void registerReloadHook() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(manager -> ShaderUtils.reloadShaders());
    }

    public static IShader newShader(ShaderType type, Supplier<String> src) {
        return RenderUtils.checkOptifine() ? NoopShader.INSTANCE : new ShaderImpl(type, src);
    }

    public static IShader newShader(ShaderType type, String src) {
        return ShaderUtils.newShader(type, () -> src);
    }

    public static IShader newShader(ShaderType type, ResourceLocation resource) {
        return ShaderUtils.newShader(type, () -> {
            try {
                return ResourceUtils.getAsString(resource);
            }
            catch (IOException e) {
                LibNine.LOGGER.error("Could not retrieve shader {}!", (Object)resource);
                LibNine.LOGGER.error((Object)e);
                return "";
            }
        });
    }

    public static IShaderProgram.Source newShaderProgram() {
        return RenderUtils.checkOptifine() ? NoopShaderProgramSource.INSTANCE : new ShaderProgramSourceImpl();
    }

    public static void clearShaderProgram() {
        if (RenderUtils.checkOptifine()) {
            return;
        }
        GL20.glUseProgram((int)0);
    }

    public static void reloadShaders() {
        validShaders.forEach(s -> {
            s.clean();
            s.compile();
        });
    }

    private static class NoopUniform
    extends Uniform {
        private static final UniformType DUMMY_TYPE = new UniformType<Object, Object>((l, v, c) -> {});
        static final NoopUniform INSTANCE = new NoopUniform();

        private NoopUniform() {
            super(DUMMY_TYPE, "<noop>");
        }
    }

    private static class NoopShaderProgramSource
    implements IShaderProgram.Source {
        static final NoopShaderProgramSource INSTANCE = new NoopShaderProgramSource();

        private NoopShaderProgramSource() {
        }

        @Override
        public IShaderProgram.Source withShader(IShader shader) {
            return INSTANCE;
        }

        @Override
        public <T> Uniform<T, ?> getUniform(UniformType<T, ?> type, String name) {
            return NoopUniform.INSTANCE;
        }

        @Override
        public IShaderProgram compile() {
            return NoopShaderProgram.INSTANCE;
        }
    }

    private static class NoopShaderProgram
    implements IShaderProgram {
        static final NoopShaderProgram INSTANCE = new NoopShaderProgram();

        private NoopShaderProgram() {
        }

        @Override
        public <T> IShaderProgram setUniform(Uniform<T, ?> uniform, T value) {
            return this;
        }

        @Override
        public IShaderProgram use() {
            return this;
        }
    }

    private static class ShaderProgramSourceImpl
    implements IShaderProgram.Source {
        private final List<IShader> shaderSources = new ArrayList<IShader>();
        private final List<Uniform<?, ?>> uniforms = new ArrayList();

        private ShaderProgramSourceImpl() {
        }

        @Override
        public IShaderProgram.Source withShader(IShader shader) {
            this.shaderSources.add(shader);
            return this;
        }

        @Override
        public <T> Uniform<T, ?> getUniform(UniformType<T, ?> type, String name) {
            Uniform uniform = new Uniform(type, name);
            this.uniforms.add(uniform);
            return uniform;
        }

        @Override
        public IShaderProgram compile() {
            ShaderProgramImpl program = new ShaderProgramImpl(this.shaderSources, this.uniforms);
            program.compile();
            validShaders.add(program);
            return program;
        }
    }

    private static class ShaderProgramImpl
    implements IShaderProgram {
        private final List<IShader> shaderSources;
        private final List<Uniform<?, ?>> uniforms;
        private final int[] shaderIds;
        private int programId = -1;
        private final TObjectIntMap<Uniform<?, ?>> unifMapping = new TObjectIntHashMap();

        ShaderProgramImpl(List<IShader> shaderSources, List<Uniform<?, ?>> uniforms) {
            this.shaderSources = shaderSources;
            this.uniforms = uniforms;
            this.shaderIds = new int[shaderSources.size()];
        }

        @Override
        public IShaderProgram use() {
            if (this.programId != -1) {
                GL20.glUseProgram((int)this.programId);
            }
            return this;
        }

        @Override
        public <T> IShaderProgram setUniform(Uniform<T, ?> uniform, T value) {
            if (this.programId != -1) {
                ShaderProgramImpl.setUniform0(uniform, this.unifMapping.get(uniform), value);
            }
            return this;
        }

        private static <T, C> void setUniform0(Uniform<T, C> uniform, int location, T value) {
            uniform.getType().set(location, value, uniform.getContext());
        }

        void compile() {
            this.programId = GL20.glCreateProgram();
            for (int i = 0; i < this.shaderSources.size(); ++i) {
                String source = this.shaderSources.get(i).getSource();
                if (source.isEmpty()) continue;
                int shaderId = this.shaderIds[i] = GL20.glCreateShader((int)this.shaderSources.get(i).getType().getGlConstant());
                GL20.glShaderSource((int)shaderId, (CharSequence)source);
                GL20.glCompileShader((int)shaderId);
                if (GL20.glGetShaderi((int)shaderId, (int)35713) == 0) {
                    LibNine.LOGGER.warn("Compilation failed for one or more shaders! Ignoring...\n{}", (Object)GL20.glGetShaderInfoLog((int)shaderId, (int)GL20.glGetShaderi((int)shaderId, (int)35716)));
                    continue;
                }
                GL20.glAttachShader((int)this.programId, (int)shaderId);
            }
            GL20.glLinkProgram((int)this.programId);
            if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
                LibNine.LOGGER.warn("Compilation failed for shader program! Ignoring...\n{}", (Object)GL20.glGetProgramInfoLog((int)this.programId, (int)GL20.glGetProgrami((int)this.programId, (int)35716)));
                this.programId = -1;
            } else {
                for (Uniform<?, ?> unif : this.uniforms) {
                    this.unifMapping.put(unif, unif.computeLocation(this.programId));
                }
            }
        }

        void clean() {
            if (this.programId != -1) {
                for (int shaderId : this.shaderIds) {
                    GL20.glDeleteShader((int)shaderId);
                }
                GL20.glDeleteProgram((int)this.programId);
                this.programId = -1;
                this.unifMapping.clear();
            }
        }
    }

    private static class NoopShader
    implements IShader {
        static final NoopShader INSTANCE = new NoopShader();

        private NoopShader() {
        }

        @Override
        public ShaderType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ShaderImpl
    implements IShader {
        private final ShaderType type;
        private final Supplier<String> source;

        ShaderImpl(ShaderType type, Supplier<String> source) {
            this.type = type;
            this.source = source;
        }

        @Override
        public ShaderType getType() {
            return this.type;
        }

        @Override
        public String getSource() {
            return this.source.get();
        }
    }
}

