/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.render.BakedArea;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.util.JsonUtils;

public class Area {
    public static final JsonDeserializer<Area> DESERIALISER = Area::deserialise;
    public final String x;
    public final String y;
    public final String width;
    public final String height;

    public Area(double x, double y, double width, double height) {
        this.x = Double.toString(x);
        this.y = Double.toString(y);
        this.width = Double.toString(width);
        this.height = Double.toString(height);
    }

    public Area(String x, String y, String width, String height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "Area [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public BakedArea bake(FunctionContext context) throws InvalidExpressionException {
        if (this.width == null) {
            throw new InvalidExpressionException("Missing 'width'!");
        }
        if (this.height == null) {
            throw new InvalidExpressionException("Missing 'height'!");
        }
        return new BakedArea(this.x == null ? "0" : this.x, this.y == null ? "0" : this.y, this.width, this.height, context);
    }

    private static Area deserialise(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected an object, but got " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        String x = JsonUtils.func_151219_a((JsonObject)obj, (String)"x", null);
        String y = JsonUtils.func_151219_a((JsonObject)obj, (String)"y", null);
        String width = JsonUtils.func_151219_a((JsonObject)obj, (String)"width", null);
        String height = JsonUtils.func_151219_a((JsonObject)obj, (String)"height", null);
        return new Area(x, y, width, height);
    }
}

