/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.block;

import elucent.simplytea.SimplyTea;
import elucent.simplytea.block.IItemBlock;
import elucent.simplytea.core.Config;
import elucent.simplytea.core.IModeledObject;
import elucent.simplytea.core.Util;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTeaTrunk
extends Block
implements IModeledObject,
IItemBlock {
    public static final PropertyEnum<TrunkType> TYPE = PropertyEnum.func_177709_a((String)"type", TrunkType.class);
    public static final PropertyBool CLIPPED = PropertyBool.func_177716_a((String)"clipped");
    public static final AxisAlignedBB BOUNDS_STUMP = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    public static final AxisAlignedBB[] BOUNDS_UNCLIPPED = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875), new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.75), new AxisAlignedBB(0.25, 0.125, 0.125, 1.0, 0.875, 0.875), new AxisAlignedBB(0.125, 0.125, 0.25, 0.875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.125, 0.125, 0.75, 0.875, 0.875)};
    public static final AxisAlignedBB[] BOUNDS_CLIPPED = new AxisAlignedBB[]{new AxisAlignedBB(0.40625, 0.0, 0.40625, 0.59375, 1.0, 0.59375), new AxisAlignedBB(0.40625, 0.0, 0.40625, 0.59375, 1.0, 0.59375), new AxisAlignedBB(0.40625, 0.0, 0.40625, 0.59375, 0.5, 0.59375), new AxisAlignedBB(0.40625, 0.40625, 0.0, 0.59375, 0.59375, 0.5), new AxisAlignedBB(0.5, 0.40625, 0.40625, 1.0, 0.59375, 0.59375), new AxisAlignedBB(0.40625, 0.40625, 0.5, 0.59375, 0.59375, 1.0), new AxisAlignedBB(0.0, 0.40625, 0.40625, 0.5, 0.59375, 0.59375)};
    private Item itemBlock = null;

    public BlockTeaTrunk(String name) {
        super(Material.field_151575_d);
        this.itemBlock = Util.init(this, name, false);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", -1);
        this.func_149711_c(1.8f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)TrunkType.STUMP)).func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149653_t() {
        return true;
    }

    public boolean func_149698_L() {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue() && (double)rand.nextFloat() < Config.tree.leaf_growth_chance) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)));
            worldIn.func_184138_a(pos, state, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)), 8);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(SimplyTea.tea_sapling, 1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() != this || ((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue() || state.func_177229_b(TYPE) == TrunkType.STUMP) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        Item item = heldItem.func_77973_b();
        if (item instanceof ItemShears || item.getToolClasses(heldItem).contains("shears")) {
            ItemStack stack = heldItem.func_77946_l();
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_184611_a(hand, stack);
            NonNullList<ItemStack> drops = this.addTeaDrops((NonNullList<ItemStack>)NonNullList.func_191196_a(), state);
            for (ItemStack drop : drops) {
                BlockTeaTrunk.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
            world.func_184138_a(pos, state, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
            world.func_184133_a(player, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return BOUNDS_STUMP;
        }
        TrunkType type = (TrunkType)((Object)state.func_177229_b(TYPE));
        if (type == TrunkType.STUMP) {
            return BOUNDS_STUMP;
        }
        return ((Boolean)state.func_177229_b((IProperty)CLIPPED) != false ? BOUNDS_CLIPPED : BOUNDS_UNCLIPPED)[type.getMeta() - 1];
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        TrunkType type = (TrunkType)((Object)state.func_177229_b(TYPE));
        if (side == EnumFacing.DOWN && type == TrunkType.TOP) {
            return BlockFaceShape.CENTER;
        }
        if (side.func_176740_k().func_176720_b() && (type == TrunkType.BOTTOM || type == TrunkType.MIDDLE || type == TrunkType.STUMP)) {
            return BlockFaceShape.CENTER;
        }
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, CLIPPED});
    }

    public int func_176201_c(IBlockState state) {
        return ((TrunkType)((Object)state.func_177229_b(TYPE))).getMeta() + ((Boolean)state.func_177229_b((IProperty)CLIPPED) != false ? 8 : 0);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)TrunkType.fromMeta(meta % 8))).func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(meta >= 8));
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        this.addTeaDrops(drops, state);
        drops.add((Object)new ItemStack(SimplyTea.tea_stick, Util.randomCount(RANDOM, Config.tree.max_sticks)));
    }

    private NonNullList<ItemStack> addTeaDrops(NonNullList<ItemStack> drops, IBlockState state) {
        if (state.func_177229_b(TYPE) != TrunkType.STUMP && !((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue()) {
            drops.add((Object)new ItemStack(SimplyTea.leaf_tea, Util.randomCount(RANDOM, Config.tree.max_leaves)));
            if ((double)RANDOM.nextFloat() < Config.tree.sapling_chance) {
                drops.add((Object)new ItemStack(SimplyTea.tea_sapling, 1));
            }
        }
        return drops;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }

    public static enum TrunkType implements IStringSerializable
    {
        STUMP,
        BOTTOM,
        MIDDLE,
        TOP,
        NORTH,
        EAST,
        SOUTH,
        WEST;

        private int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public static TrunkType fromMeta(int meta) {
            if (meta < 0 || meta >= TrunkType.values().length) {
                meta = 0;
            }
            return TrunkType.values()[meta];
        }
    }
}

