/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.item;

import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponent;
import net.malisis.core.item.MalisisItem;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.renderer.icon.provider.IItemIconProvider;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.multiblock.AABBMultiBlock;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.block.Forcefield;
import net.malisis.doors.tileentity.ForcefieldTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForcefieldItem
extends MalisisItem {
    public static AxisAlignedBB lastAABB;

    public ForcefieldItem() {
        this.setName("forcefieldItem");
        this.func_77637_a((CreativeTabs)MalisisDoors.tab);
        this.func_77656_e(0);
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)this.getIconProvider());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return new ForcefieldItemIconProvider();
    }

    public int getEnergy(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e("energy");
    }

    public void setEnergy(ItemStack itemStack, int energy) {
        if (energy < 0) {
            energy = 0;
        } else if (energy > this.getMaxEnergy()) {
            energy = this.getMaxEnergy();
        }
        this.getNBT(itemStack).func_74768_a("energy", energy);
    }

    public void drainEnergy(ItemStack itemStack, int energy) {
        this.setEnergy(itemStack, this.getEnergy(itemStack) - energy);
    }

    protected int getMaxEnergy() {
        return 2000;
    }

    protected NBTTagCompound getNBT(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        pos = pos.func_177972_a(side);
        if (!this.isStartSet(itemStack)) {
            return this.setStartPosition(itemStack, pos, world.func_82737_E());
        }
        BlockPos start = this.getStartPosition(itemStack);
        AxisAlignedBB aabb = ForcefieldItem.getBoundingBox(start, pos);
        pos = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        int size = this.getDoorSize(aabb);
        if (size <= 0 || this.getEnergy(itemStack) < size * 20) {
            return this.clearStartPosition(itemStack);
        }
        if (!player.func_175151_a(pos, side, itemStack)) {
            return this.clearStartPosition(itemStack);
        }
        Forcefield block = MalisisDoors.Blocks.forcefieldDoor;
        if (!world.func_190527_a((Block)block, pos, false, side, (Entity)player)) {
            return this.clearStartPosition(itemStack);
        }
        IBlockState state = block.func_176223_P().func_177226_a((IProperty)MultiBlockComponent.ORIGIN, (Comparable)Boolean.valueOf(true));
        if (!world.func_180501_a(pos, state, 3)) {
            return this.clearStartPosition(itemStack);
        }
        state = world.func_180495_p(pos);
        if (state.func_177230_c() != block) {
            return this.clearStartPosition(itemStack);
        }
        AABBMultiBlock multiBlock = new AABBMultiBlock(block.func_176223_P(), aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())));
        multiBlock.setBulkProcess(true, true);
        ForcefieldTileEntity te = (ForcefieldTileEntity)((Object)TileEntityUtils.getTileEntity(ForcefieldTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te != null) {
            te.setMultiBlock(multiBlock);
        }
        block.func_180633_a(world, pos, state.func_177226_a((IProperty)MultiBlockComponent.ORIGIN, (Comparable)Boolean.valueOf(false)), (EntityLivingBase)player, itemStack);
        this.drainEnergy(itemStack, size * 20);
        return this.clearStartPosition(itemStack);
    }

    private static AxisAlignedBB getBoundingBox(BlockPos start, BlockPos end) {
        return new AxisAlignedBB(start, end).func_72317_d(0.5, 0.5, 0.5).func_72314_b(0.5, 0.5, 0.5);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    protected boolean isStartSet(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74764_b("start");
    }

    protected EnumActionResult setStartPosition(ItemStack itemStack, BlockPos pos, long time) {
        this.getNBT(itemStack).func_74772_a("start", pos.func_177986_g());
        this.getNBT(itemStack).func_74772_a("time", time);
        return EnumActionResult.SUCCESS;
    }

    protected BlockPos getStartPosition(ItemStack itemStack) {
        return BlockPos.func_177969_a((long)this.getNBT(itemStack).func_74763_f("start"));
    }

    protected EnumActionResult clearStartPosition(ItemStack itemStack) {
        this.getNBT(itemStack).func_82580_o("start");
        this.getNBT(itemStack).func_82580_o("time");
        return EnumActionResult.SUCCESS;
    }

    public int getDoorSize(AxisAlignedBB aabb) {
        int diffX = (int)(aabb.field_72336_d - aabb.field_72340_a);
        int diffY = (int)(aabb.field_72337_e - aabb.field_72338_b);
        int diffZ = (int)(aabb.field_72334_f - aabb.field_72339_c);
        if (diffX == 1 && diffZ != 1) {
            return diffY * diffZ;
        }
        if (diffY == 1) {
            return diffX * diffZ;
        }
        if (diffZ == 1 && diffX != 1) {
            return diffX * diffY;
        }
        return -1;
    }

    public boolean toggleForcefield(ItemStack itemStack, AxisAlignedBB aabb) {
        int size = this.getDoorSize(aabb);
        if (this.getEnergy(itemStack) < size * 5) {
            return false;
        }
        this.drainEnergy(itemStack, size * 5);
        return true;
    }

    public boolean destroyForcefield(ItemStack itemStack, AxisAlignedBB aabb) {
        int size = this.getDoorSize(aabb);
        if (this.getEnergy(itemStack) < size * 20) {
            return false;
        }
        this.drainEnergy(itemStack, size * 20);
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isStartSet(itemStack) && world.func_82737_E() - this.getNBT(itemStack).func_74763_f("time") > 100L) {
            this.clearStartPosition(itemStack);
        }
        if (this.getEnergy(itemStack) >= this.getMaxEnergy()) {
            return;
        }
        int energy = this.getEnergy(itemStack) + 5;
        if (((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            energy += 15;
        }
        this.setEnergy(itemStack, energy);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - (double)this.getEnergy(itemStack) / (double)this.getMaxEnergy();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    public class ForcefieldItemIconProvider
    implements IItemIconProvider {
        protected Icon itemIcon = Icon.from((String)"malisisdoors:items/forcefielditem");
        protected Icon yellowIcon = Icon.from((String)"malisisdoors:items/forcefielditem_yellow");
        protected Icon redIcon = Icon.from((String)"malisisdoors:items/forcefielditem_red");
        protected Icon greenIcon = Icon.from((String)"malisisdoors:items/forcefielditem_green");
        protected Icon disabledIcon = Icon.from((String)"malisisdoors:items/forcefielditem_disabled");

        public Icon getIcon() {
            return this.itemIcon;
        }

        public Icon getIcon(ItemStack itemStack) {
            if (!ForcefieldItem.this.isStartSet(itemStack)) {
                return this.itemIcon;
            }
            RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
            if (result.field_72313_a != RayTraceResult.Type.BLOCK) {
                return this.yellowIcon;
            }
            BlockPos pos = result.func_178782_a().func_177972_a(result.field_178784_b);
            BlockPos start = ForcefieldItem.this.getStartPosition(itemStack);
            AxisAlignedBB aabb = ForcefieldItem.getBoundingBox(start, pos);
            int size = ForcefieldItem.this.getDoorSize(aabb);
            if (size <= 0 || ForcefieldItem.this.getEnergy(itemStack) < size * 20) {
                return this.redIcon;
            }
            return this.greenIcon;
        }
    }
}

