/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine2.world.gen.noise;

import asmodeuscore.core.utils.worldengine2.util.WE_Interpolation;
import asmodeuscore.core.utils.worldengine2.world.gen.noise.WE_NoiseTemplate;

public class WE_PerlinNoise
extends WE_NoiseTemplate {
    public WE_PerlinNoise(long gSeed, double gPersistence, int numOfOctaves, double scl_x, double scl_y, double scl_z, int sum, byte interpolation) {
        super(gSeed, gPersistence, numOfOctaves, scl_x, scl_y, scl_z, sum, interpolation);
        this.rand.makeSmartForVectors();
    }

    public Double dot2D(Double[] vec1, Double[] vec2) {
        return vec1[0] * vec2[0] + vec1[1] * vec2[1];
    }

    @Override
    public double noiseOctave2D(double x, double z) {
        long squareStartX = (long)x;
        long squareStartZ = (long)z;
        long xs = 1L;
        long zs = 1L;
        if (Math.abs(x) != x) {
            xs = -1L;
        }
        if (Math.abs(z) != z) {
            zs = -1L;
        }
        double pointInQuadX = Math.abs(x) - (double)Math.abs(squareStartX);
        double pointInQuadZ = Math.abs(z) - (double)Math.abs(squareStartZ);
        Double[] topLeft = this.rand.smartVec.get(squareStartX, squareStartZ);
        Double[] topRight = this.rand.smartVec.get(squareStartX + xs, squareStartZ);
        Double[] bottomLeft = this.rand.smartVec.get(squareStartX, squareStartZ + zs);
        Double[] bottomRight = this.rand.smartVec.get(squareStartX + xs, squareStartZ + zs);
        Double[] distanceToTopLeft = new Double[]{(double)xs * pointInQuadX, (double)zs * pointInQuadZ};
        Double[] distanceToTopRight = new Double[]{(double)xs * pointInQuadX - (double)xs, (double)zs * pointInQuadZ};
        Double[] distanceToBottomLeft = new Double[]{(double)xs * pointInQuadX, (double)zs * pointInQuadZ - (double)zs};
        Double[] distanceToBottomRight = new Double[]{(double)xs * pointInQuadX - (double)xs, (double)zs * pointInQuadZ - (double)zs};
        Double dotTopLeft = this.dot2D(topLeft, distanceToTopLeft);
        Double dotTopRight = this.dot2D(topRight, distanceToTopRight);
        Double dotBottomLeft = this.dot2D(bottomLeft, distanceToBottomLeft);
        Double dotBottomRight = this.dot2D(bottomRight, distanceToBottomRight);
        return WE_Interpolation.bilinearInterpolation2D(dotTopLeft, dotTopRight, dotBottomLeft, dotBottomRight, pointInQuadX, pointInQuadZ, this.iType);
    }
}

