/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.block;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseMod;
import gcewing.sg.SGCraft;
import gcewing.sg.block.SGBaseBlock;
import gcewing.sg.block.SGBlock;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.tileentity.SGRingTE;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGRingBlock
extends SGBlock<SGRingTE> {
    static final int numSubBlocks = 2;
    public static IProperty<Integer> VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)1);
    static String[] textures = new String[]{"stargateblock", "stargatering", "stargatechevron"};
    static BaseMod.ModelSpec[] models = new BaseMod.ModelSpec[]{new BaseMod.ModelSpec("block/sg_ring_block.smeg", "stargateblock", "stargatering"), new BaseMod.ModelSpec("block/sg_ring_block.smeg", "stargateblock", "stargatechevron")};
    static String[] subBlockTitles = new String[]{"Stargate Ring Block", "Stargate Chevron Block"};

    public SGRingBlock() {
        super(Material.field_151576_e, SGRingTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(VARIANT);
    }

    @Override
    public int getNumSubtypes() {
        return VARIANT.func_177700_c().size();
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return models[(Integer)state.func_177229_b(VARIANT)];
    }

    @Override
    protected String getRendererClassName() {
        return "gcewing.sg.client.renderer.SGRingBlockRenderer";
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return SGCraft.canHarvestSGRingBlock;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float cx, float cy, float cz) {
        IBlockState baseState;
        Block block;
        SGRingTE te = (SGRingTE)this.getTileEntity((IBlockAccess)world, pos);
        if (te.isMerged && (block = (baseState = world.func_180495_p(te.basePos)).func_177230_c()) instanceof SGBaseBlock) {
            return block.func_180639_a(world, te.basePos, baseState, player, hand, side, cx, cy, cz);
        }
        return false;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess world, BlockPos pos) {
        SGRingTE rte = (SGRingTE)this.getTileEntity(world, pos);
        if (rte != null) {
            return rte.getBaseTE();
        }
        return null;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 2; ++i) {
            ItemStack item = new ItemStack((Block)this, 1, i);
            list.add((Object)item);
        }
    }

    @Override
    public boolean isMerged(IBlockAccess world, BlockPos pos) {
        SGRingTE te = (SGRingTE)this.getTileEntity(world, pos);
        return te != null && te.isMerged;
    }

    public void mergeWith(World world, BlockPos pos, BlockPos basePos) {
        SGRingTE te = (SGRingTE)this.getTileEntity((IBlockAccess)world, pos);
        te.isMerged = true;
        te.basePos = basePos;
        BaseBlockUtils.markBlockForUpdate(world, pos);
    }

    public void unmergeFrom(World world, BlockPos pos, BlockPos basePos) {
        SGRingTE te = (SGRingTE)this.getTileEntity((IBlockAccess)world, pos);
        if (te.isMerged && te.basePos.equals((Object)basePos)) {
            te.isMerged = false;
            te.markBlockChanged();
        }
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.onBlockAdded: at %s\n", pos);
        }
        SGRingTE te = (SGRingTE)this.getTileEntity((IBlockAccess)world, pos);
        this.updateBaseBlocks(world, pos, te);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        SGRingTE te = (SGRingTE)this.getTileEntity((IBlockAccess)world, pos);
        super.func_180663_b(world, pos, state);
        if (te != null && te.isMerged) {
            this.updateBaseBlocks(world, pos, te);
        }
    }

    void updateBaseBlocks(World world, BlockPos pos, SGRingTE te) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.updateBaseBlocks: merged = %s, base = %s\n", te.isMerged, te.basePos);
        }
        for (int i = -5; i <= 5; ++i) {
            for (int j = -4; j <= 0; ++j) {
                for (int k = -5; k <= 5; ++k) {
                    BlockPos bp = pos.func_177982_a(i, j, k);
                    Block block = world.func_180495_p(bp).func_177230_c();
                    if (!(block instanceof SGBaseBlock)) continue;
                    if (SGBaseBlock.debugMerge) {
                        System.out.printf("SGRingBlock.updateBaseBlocks: found base at %s\n", bp);
                    }
                    SGBaseBlock base = (SGBaseBlock)block;
                    if (!te.isMerged) {
                        base.checkForVerticalMerge(world, bp);
                        if (te.isMerged) continue;
                        base.checkForHorizontalMerge(world, bp);
                        continue;
                    }
                    if (!te.basePos.equals((Object)bp)) continue;
                    base.unmerge(world, bp);
                }
            }
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return SGCraft.canHarvestSGRingBlock;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

