/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.variant;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.property.IUnlistedProperty;

public class VariantModelState {
    public static final String DEFAULT_MARKER = "<default>";
    public static final IUnlistedProperty<VariantModelState> PROPERTY = new IUnlistedProperty<VariantModelState>(){

        public String valueToString(VariantModelState value) {
            return value.selectors.toString();
        }

        public boolean isValid(VariantModelState value) {
            return true;
        }

        public Class<VariantModelState> getType() {
            return VariantModelState.class;
        }

        public String getName() {
            return "selectors";
        }
    };
    public static final VariantModelState EMPTY = new VariantModelState();
    private final Map<String, String> selectors;

    private VariantModelState(Map<String, String> selectors) {
        this.selectors = ImmutableMap.copyOf(selectors);
    }

    private VariantModelState() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public static VariantModelState create() {
        return EMPTY;
    }

    public static VariantModelState create(Map<String, String> selectors) {
        return new VariantModelState(selectors);
    }

    public VariantModelState withKey(String key, String value) {
        HashMap copy = Maps.newHashMap(this.selectors);
        copy.put(key, value);
        return new VariantModelState(copy);
    }

    public VariantModelState withKey(String key) {
        return this.withKey(key, DEFAULT_MARKER);
    }

    public VariantModelState withKeys(Set<String> keys) {
        HashMap copy = Maps.newHashMap(this.selectors);
        for (String key : keys) {
            copy.put(key, DEFAULT_MARKER);
        }
        return new VariantModelState(copy);
    }

    Map<String, String> getSelectors() {
        return this.selectors;
    }
}

