/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.CableUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineFluidTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityTurbineValve
extends TileEntityTurbineCasing
implements IFluidHandlerWrapper,
IEnergyWrapper,
IComputerIntegration,
IComparatorSupport {
    private static final String[] methods = new String[]{"isFormed", "getSteam", "getFlowRate", "getMaxFlow", "getSteamInput"};
    public boolean ic2Registered = false;
    public TurbineFluidTank fluidTank;
    private CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration> teslaManager = new CapabilityWrapperManager(IEnergyWrapper.class, TeslaIntegration.class);
    private CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration> forgeEnergyManager = new CapabilityWrapperManager(IEnergyWrapper.class, ForgeEnergyIntegration.class);
    private int currentRedstoneLevel;

    public TileEntityTurbineValve() {
        super("TurbineValve");
        this.fluidTank = new TurbineFluidTank(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
        if (!this.field_145850_b.field_72995_K) {
            int newRedstoneLevel;
            if (this.structure != null) {
                CableUtils.emit((IEnergyWrapper)this);
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public boolean sideIsOutput(EnumFacing side) {
        if (this.structure != null) {
            return !((SynchronizedTurbineData)this.structure).locations.contains(Coord4D.get((TileEntity)this).offset(side));
        }
        return false;
    }

    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public void register() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != this) {
            if (registered != null && this.ic2Registered) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
                this.ic2Registered = false;
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="ic2")
    public void deregister() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != null && this.ic2Registered) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
            this.ic2Registered = false;
        }
    }

    public double getMaxOutput() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).getEnergyCapacity() : 0.0;
    }

    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.sideIsOutput(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.current().general.FROM_RF.val()));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return MekanismUtils.clampToInt((double)(toSend * MekanismConfig.current().general.TO_RF.val()));
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.structure != null;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return MekanismUtils.clampToInt((double)(this.getEnergy() * MekanismConfig.current().general.TO_RF.val()));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return MekanismUtils.clampToInt((double)(this.getMaxEnergy() * MekanismConfig.current().general.TO_RF.val()));
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public int addEnergy(int amount) {
        return 0;
    }

    @Optional.Method(modid="ic2")
    public boolean isTeleporterCompatible(EnumFacing side) {
        return this.canOutputEnergy(side);
    }

    public boolean canOutputEnergy(EnumFacing side) {
        return this.sideIsOutput(side);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return this.sideIsOutput(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="ic2")
    public int getStored() {
        return MekanismUtils.clampToInt((double)(this.getEnergy() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.current().general.FROM_IC2.val());
    }

    @Optional.Method(modid="ic2")
    public int getCapacity() {
        return MekanismUtils.clampToInt((double)(this.getMaxEnergy() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public int getOutput() {
        return MekanismUtils.clampToInt((double)(this.getMaxOutput() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.current().general.TO_IC2.val();
    }

    public boolean canReceiveEnergy(EnumFacing side) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.current().general.TO_IC2.val();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing direction, double amount, double voltage) {
        return amount;
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        if (this.structure != null) {
            double toDraw = Math.min(amount * MekanismConfig.current().general.FROM_IC2.val(), this.getMaxOutput());
            this.setEnergy(Math.max(this.getEnergy() - toDraw, 0.0));
        }
    }

    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        return 0.0;
    }

    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        double toGive = Math.min(this.getEnergy(), amount);
        if (toGive < 1.0E-4 || side != null && !this.sideIsOutput(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() - toGive);
        }
        return toGive;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fluidTank.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        int filled = this.fluidTank.fill(resource, doFill);
        if (doFill) {
            ((SynchronizedTurbineData)this.structure).newSteamInput += filled;
        }
        if (filled < ((SynchronizedTurbineData)this.structure).getFluidCapacity() && ((SynchronizedTurbineData)this.structure).dumpMode != TileEntityGasTank.GasMode.IDLE) {
            filled = Math.min(((SynchronizedTurbineData)this.structure).getFluidCapacity(), resource.amount);
        }
        return filled;
    }

    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (fluid.getFluid() == FluidRegistry.getFluid((String)"steam")) {
            return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
        }
        return false;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize((String)"gui.industrialTurbine");
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (method == 0) {
            return new Object[]{this.structure != null};
        }
        if (this.structure == null) {
            return new Object[]{"Unformed"};
        }
        switch (method) {
            case 1: {
                return new Object[]{((SynchronizedTurbineData)this.structure).fluidStored != null ? ((SynchronizedTurbineData)this.structure).fluidStored.amount : 0};
            }
            case 2: {
                return new Object[]{((SynchronizedTurbineData)this.structure).clientFlow};
            }
            case 3: {
                double rate = (double)((SynchronizedTurbineData)this.structure).lowerVolume * ((double)((SynchronizedTurbineData)this.structure).clientDispersers * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
                rate = Math.min(rate, (double)((SynchronizedTurbineData)this.structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
                return new Object[]{rate};
            }
            case 4: {
                return new Object[]{((SynchronizedTurbineData)this.structure).lastSteamInput};
            }
        }
        throw new NoSuchMethodException();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY || capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(this.facing) || capability == CapabilityEnergy.ENERGY)) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY) {
                return (T)((Object)this);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper((IFluidHandlerWrapper)this, side));
            }
            if (capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(this.facing)) {
                return (T)this.teslaManager.getWrapper((Object)this, this.facing);
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast(this.forgeEnergyManager.getWrapper((Object)this, this.facing));
            }
        }
        return (T)super.getCapability(capability, side);
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((double)this.fluidTank.getFluidAmount(), (double)this.fluidTank.getCapacity());
    }
}

