/*
 * Decompiled with CFR 0.152.
 */
package bq_rf.core;

import bq_rf.core.BQRF;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegEventHandler {
    public static final List<Item> ALL_ITEMS = new ArrayList<Item>();
    public static final List<Block> ALL_BLOCKS = new ArrayList<Block>();
    public static final List<IRecipe> ALL_RECIPES = new ArrayList<IRecipe>();
    private static boolean setupRecipes = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModelEvent(ModelRegistryEvent event) {
        BQRF.proxy.registerRenderers();
    }

    @SubscribeEvent
    public static void registerBlockEvent(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ALL_BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void registerItemEvent(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ALL_ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerRecipeEvent(RegistryEvent.Register<IRecipe> event) {
        if (!setupRecipes) {
            RegEventHandler.initRecipes();
        }
        IRecipe[] tmp = ALL_RECIPES.toArray(new IRecipe[0]);
        event.getRegistry().registerAll((IForgeRegistryEntry[])tmp);
    }

    private static void registerBlock(Block b, String name) {
        ResourceLocation res = new ResourceLocation("bq_rf:" + name);
        ALL_BLOCKS.add((Block)b.setRegistryName(res));
        ALL_ITEMS.add((Item)new ItemBlock(b).setRegistryName(res));
    }

    private static void addShapedRecipe(String name, String group, ItemStack stack, Object ... ing) {
        ResourceLocation rName = new ResourceLocation("bq_rf", name);
        ResourceLocation rGroup = new ResourceLocation("bq_rf", group);
        ALL_RECIPES.add((IRecipe)new ShapedOreRecipe(rGroup, stack, ing).setRegistryName(rName));
    }

    private static void initRecipes() {
        RegEventHandler.addShapedRecipe("rf_station", "questing", new ItemStack(BQRF.rfStation), "IRI", "RSR", "IRI", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('S'), new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("betterquesting:submit_station"))));
        setupRecipes = true;
    }

    static {
        RegEventHandler.registerBlock(BQRF.rfStation, "rf_station");
    }
}

