/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.Lists;
import exter.foundry.fluid.FluidLiquidMetal;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.block.BlockFluidBase;
import thelm.jaopca.api.fluid.FluidProperties;
import thelm.jaopca.api.fluid.IFluidWithProperty;
import thelm.jaopca.api.utils.Utils;

public class ModuleFoundry
extends ModuleBase {
    public static final ArrayList<String> BLACKLIST = Lists.newArrayList((Object[])new String[]{"Iron", "Gold", "Copper", "Tin", "Bronze", "Electrum", "Invar", "Nickel", "Zinc", "Brass", "Silver", "Steel", "Cupronickel", "Lead", "Platinum", "Aluminium", "Alumina", "Chromium", "Signalum", "Lumium", "Enderium", "Osmium", "Manasteel", "Terrasteel", "ElvenElementium", "RedstoneAlloy", "EnergeticAlloy", "VibrantAlloy", "DarkSteel", "PulsatingIron", "ElectricalSteel", "Soularium"});
    public static final FluidProperties LIQUID_PROPERTIES = new FluidProperties().setDensityFunc(entry -> 2000).setTemperatureFunc(entry -> MathHelper.func_76125_a((int)((int)(750.0 * entry.getEnergyModifier()) + 750), (int)1500, (int)4000)).setLuminosityFunc(entry -> 15).setFillSound(SoundEvents.field_187633_N).setEmptySound(SoundEvents.field_187627_L).setMaterial(Material.field_151587_i).setFluidClass(FluidLiquidMetalBase.class).setBlockFluidClass(BlockFluidLiquidMetalBase.class);
    public static final ItemEntry LIQUID_ENTRY = new ItemEntry(EnumEntryType.FLUID, "liquid", new ModelResourceLocation("jaopca:fluids/liquid#normal"), BLACKLIST).setProperties(LIQUID_PROPERTIES).setOreTypes(EnumOreType.INGOTS);

    @Override
    public String getName() {
        return "foundry";
    }

    public List<ItemEntry> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntry[]{LIQUID_ENTRY});
    }

    @Override
    public void preInit() {
        Map registry;
        try {
            Class registryClass = ReflectionHelper.getClass((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"exter.foundry.fluid.LiquidMetalRegistry", "exter.foundry.fluid.FoundryFluidRegistry"});
            Field registryField = ReflectionHelper.findField((Class)registryClass, (String)"registry", (String)"map");
            registryField.setAccessible(true);
            Field instanceField = registryClass.getDeclaredField("INSTANCE");
            Object instance = instanceField.get(null);
            registry = (Map)registryField.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException | ReflectionHelper.UnableToFindClassException | ReflectionHelper.UnableToFindFieldException e) {
            e.printStackTrace();
            return;
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"liquid")) {
            registry.put(entry.getOreName(), (FluidLiquidMetal)JAOPCAApi.FLUIDS_TABLE.get((Object)"liquid", (Object)entry.getOreName()));
        }
    }

    public static class BlockFluidLiquidMetalBase
    extends BlockFluidBase {
        private IBlockState solidState;

        public BlockFluidLiquidMetalBase(IFluidWithProperty fluid, Material material) {
            super(fluid, material);
        }

        public void checkForHarden(World world, BlockPos pos, IBlockState state) {
            if (this.isSourceBlock((IBlockAccess)world, pos)) {
                if (this.solidState == null) {
                    ItemStack item = Utils.getPreferredStack(Utils.getOres("block" + this.getOreEntry().getOreName()).stream().filter(stack -> Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a).collect(Collectors.toList()));
                    if (!item.func_190926_b()) {
                        this.solidState = this.getBlockStateFromItemStack(item);
                    } else {
                        return;
                    }
                }
                if (this.tryToHarden(world, pos, pos.func_177982_a(-1, 0, 0))) {
                    return;
                }
                if (this.tryToHarden(world, pos, pos.func_177982_a(1, 0, 0))) {
                    return;
                }
                if (this.tryToHarden(world, pos, pos.func_177982_a(0, -1, 0))) {
                    return;
                }
                if (this.tryToHarden(world, pos, pos.func_177982_a(0, 1, 0))) {
                    return;
                }
                if (this.tryToHarden(world, pos, pos.func_177982_a(0, 0, -1))) {
                    return;
                }
                if (this.tryToHarden(world, pos, pos.func_177982_a(0, 0, 1))) {
                    return;
                }
            }
        }

        private IBlockState getBlockStateFromItemStack(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                int meta = stack.func_77960_j();
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    if (state == null || block.func_180651_a(state) != meta) continue;
                    return state;
                }
            }
            return null;
        }

        public boolean canDisplace(IBlockAccess world, BlockPos pos) {
            return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.canDisplace(world, pos);
        }

        public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return 300;
        }

        public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return 0;
        }

        public boolean displaceIfPossible(World world, BlockPos pos) {
            return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.displaceIfPossible(world, pos);
        }

        public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
            super.func_189540_a(state, world, pos, block, fromPos);
            this.checkForHarden(world, pos, state);
        }

        public void func_176213_c(World world, BlockPos pos, IBlockState state) {
            super.func_176213_c(world, pos, state);
            this.checkForHarden(world, pos, state);
        }

        public void func_180634_a(World wWorld, BlockPos pos, IBlockState state, Entity entity) {
            if (entity instanceof EntityLivingBase) {
                entity.field_70159_w *= 0.5;
                entity.field_70179_y *= 0.5;
            }
            if (!entity.func_70045_F()) {
                if (!(entity instanceof EntityItem)) {
                    entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                }
                entity.func_70015_d(15);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
            if (this.temperature < 1200) {
                return;
            }
            if (world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_185914_p()) {
                if (rand.nextInt(100) == 0) {
                    double dx = (float)pos.func_177958_n() + rand.nextFloat();
                    double dy = (double)pos.func_177956_o() + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
                    double dz = (float)pos.func_177952_p() + rand.nextFloat();
                    world.func_175688_a(EnumParticleTypes.LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
                    world.func_184134_a(dx, dy, dz, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
                if (rand.nextInt(200) == 0) {
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
            }
            BlockPos down = pos.func_177977_b();
            if (rand.nextInt(10) == 0 && world.func_180495_p(down).isSideSolid((IBlockAccess)world, down, EnumFacing.UP) && !world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_185904_a().func_76230_c()) {
                double dx = (float)pos.func_177958_n() + rand.nextFloat();
                double dy = (double)pos.func_177956_o() - 1.05;
                double dz = (float)pos.func_177952_p() + rand.nextFloat();
                world.func_175688_a(EnumParticleTypes.DRIP_LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
            }
        }

        private boolean tryToHarden(World world, BlockPos pos, BlockPos npos) {
            if (world.func_180495_p(npos).func_185904_a() == Material.field_151586_h) {
                world.func_175656_a(pos, this.solidState);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, false);
                for (int i = 0; i < 8; ++i) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
                return true;
            }
            return false;
        }
    }

    public static class FluidLiquidMetalBase
    extends FluidLiquidMetal
    implements IFluidWithProperty {
        public final IOreEntry oreEntry;
        public final ItemEntry itemEntry;
        protected int opacity = 255;

        public FluidLiquidMetalBase(ItemEntry itemEntry, IOreEntry oreEntry) {
            super(itemEntry.prefix + '_' + Utils.to_under_score(oreEntry.getOreName()), new ResourceLocation("jaopca:fluids/" + Utils.to_under_score(itemEntry.name) + "_still"), new ResourceLocation("jaopca:fluids/" + Utils.to_under_score(itemEntry.name) + "_flowing"), 0, false, 0, 0);
            this.setUnlocalizedName("jaopca." + itemEntry.name);
            this.oreEntry = oreEntry;
            this.itemEntry = itemEntry;
        }

        @Override
        public IOreEntry getOreEntry() {
            return this.oreEntry;
        }

        @Override
        public ItemEntry getItemEntry() {
            return this.itemEntry;
        }

        @Override
        public FluidLiquidMetalBase setLuminosity(int luminosity) {
            super.setLuminosity(luminosity);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setDensity(int density) {
            super.setDensity(density);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setTemperature(int temperature) {
            super.setTemperature(temperature);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setViscosity(int viscosity) {
            super.setViscosity(viscosity);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setGaseous(boolean isGaseous) {
            super.setGaseous(isGaseous);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setRarity(EnumRarity rarity) {
            super.setRarity(rarity);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setFillSound(SoundEvent fillSound) {
            super.setFillSound(fillSound);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setEmptySound(SoundEvent emptySound) {
            super.setEmptySound(emptySound);
            return this;
        }

        @Override
        public FluidLiquidMetalBase setOpacity(int opacity) {
            this.opacity = opacity;
            return this;
        }

        public int getColor() {
            return new Color(this.oreEntry.getColor()).brighter().brighter().getRGB() & 0xFFFFFF | this.opacity << 24;
        }

        public String getLocalizedName(FluidStack stack) {
            return Utils.smartLocalize(this.getUnlocalizedName(), this.getUnlocalizedName() + ".%s", this.getOreEntry());
        }
    }
}

