/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network;

import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRotateMirror
implements IMessage {
    private Operation operation;

    public PacketRotateMirror() {
    }

    public PacketRotateMirror(Operation operation) {
        this.operation = operation;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.operation = Operation.values()[buf.readInt()];
        }
    }

    public void toBytes(ByteBuf buf) {
        boolean hasOperation = this.operation != null;
        buf.writeBoolean(hasOperation);
        if (hasOperation) {
            buf.writeInt(this.operation.ordinal());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketRotateMirror, IMessage> {
        public IMessage onMessage(PacketRotateMirror message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                Operation operation;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack stack = GadgetGeneric.getGadget((EntityPlayer)player);
                Operation operation2 = message.operation != null ? message.operation : (operation = player.func_70093_af() ? Operation.MIRROR : Operation.ROTATE);
                if (stack.func_77973_b() instanceof GadgetBuilding || stack.func_77973_b() instanceof GadgetExchanger) {
                    GadgetUtils.rotateOrMirrorToolBlock(stack, (EntityPlayer)player, operation);
                } else if (stack.func_77973_b() instanceof GadgetCopyPaste) {
                    GadgetCopyPaste.rotateOrMirrorBlocks(stack, (EntityPlayer)player, operation);
                }
            });
            return null;
        }
    }

    public static enum Operation {
        ROTATE,
        MIRROR;

    }
}

