/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.portal;

import WayofTime.bloodmagic.teleport.PortalLocation;
import WayofTime.bloodmagic.util.BMLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.DimensionManager;

public class LocationsHandler
implements Serializable {
    public static final long serialVersionUID = 10102001L;
    private static final String fileName = String.valueOf(DimensionManager.getCurrentSaveRootDirectory()) + "/" + "bloodmagic" + "/PortalLocations.dat";
    private static HashMap<String, ArrayList<PortalLocation>> portals;
    private static LocationsHandler locationsHandler;

    private LocationsHandler() {
        portals = new HashMap();
    }

    public boolean addLocation(String name, PortalLocation location) {
        ArrayList<PortalLocation> portalLocations = portals.get(name);
        if (portalLocations == null) {
            portals.put(name, new ArrayList());
            LocationsHandler.updateFile(fileName, portals);
        }
        if (!portals.get(name).isEmpty() && portals.get(name).size() >= 2) {
            BMLog.DEBUG.info("Location {} already exists.", name);
            LocationsHandler.updateFile(fileName, portals);
            return false;
        }
        portals.get(name).add(location);
        BMLog.DEBUG.info("Adding {}", name);
        LocationsHandler.updateFile(fileName, portals);
        return true;
    }

    public boolean removeLocation(String name, PortalLocation location) {
        if (portals.get(name) != null && !portals.get(name).isEmpty()) {
            if (portals.get(name).contains(location)) {
                portals.get(name).remove(location);
                BMLog.DEBUG.info("Removing {}", name);
                LocationsHandler.updateFile(fileName, portals);
                return true;
            }
            BMLog.DEBUG.info("No location matching {}", name);
            LocationsHandler.updateFile(fileName, portals);
            return false;
        }
        return false;
    }

    public ArrayList<PortalLocation> getLinkedLocations(String name) {
        return portals.get(name);
    }

    public static LocationsHandler getLocationsHandler() {
        if (locationsHandler == null || LocationsHandler.loadFile() == null) {
            locationsHandler = new LocationsHandler();
            return locationsHandler;
        }
        portals = LocationsHandler.loadFile();
        return locationsHandler;
    }

    private static HashMap<String, ArrayList<PortalLocation>> loadFile() {
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                if (file.getParentFile().mkdir()) {
                    if (file.createNewFile()) {
                        BMLog.DEBUG.info("Creating {} in {}", fileName, DimensionManager.getCurrentSaveRootDirectory());
                    }
                } else if (file.createNewFile()) {
                    BMLog.DEBUG.info("Creating {} in {}", fileName, DimensionManager.getCurrentSaveRootDirectory());
                }
            }
            FileInputStream fileIn = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            HashMap map = (HashMap)in.readObject();
            in.close();
            fileIn.close();
            return map;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            BMLog.DEFAULT.error("{} was not found in {}", file, DimensionManager.getCurrentSaveRootDirectory());
            return null;
        }
    }

    private static void updateFile(String file, HashMap<String, ArrayList<PortalLocation>> object) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

