/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.command.sub;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;

public class SubCommandOrb
extends CommandTreeBase {
    public SubCommandOrb() {
        this.addSubcommand((ICommand)new Get());
        this.addSubcommand((ICommand)new Set());
        this.addSubcommand((ICommand)new CommandTreeHelp((CommandTreeBase)this));
    }

    public String func_71517_b() {
        return "orb";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "commands.bloodmagic.orb.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    class Set
    extends OrbCommand {
        int maxTier;

        Set() {
            this.maxTier = OrbRegistry.getTierMap().size() - 1;
        }

        @Override
        public String getInfo() {
            return "" + this.maxTier;
        }

        public String func_71517_b() {
            return "set";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            int targetTier;
            super.func_184881_a(server, sender, args);
            if (args.length == 1 && Utils.isInteger(args[0])) {
                targetTier = Integer.parseInt(args[0]);
            } else if (args.length == 2 && Utils.isInteger(args[1])) {
                targetTier = Integer.parseInt(args[1]);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.error.arg.invalid", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
                return;
            }
            if (targetTier < 0) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.error.negative", new Object[0]));
                return;
            }
            if (targetTier > this.maxTier) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.orb.error.tierTooHigh", new Object[]{this.getInfo()}));
                return;
            }
            this.network.setOrbTier(targetTier);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.success", new Object[0]));
        }
    }

    class Get
    extends OrbCommand {
        Get() {
        }

        public String func_71517_b() {
            return "get";
        }

        @Override
        public void subExecute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            super.func_184881_a(server, sender, args);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.orb.currenttier", new Object[]{this.network.getOrbTier()}));
        }
    }

    abstract class OrbCommand
    extends CommandTreeBase {
        public EntityPlayerMP player;
        public String uuid;
        public SoulNetwork network;
        public Object info;

        OrbCommand() {
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.bloodmagic.orb." + this.func_71517_b() + ".usage";
        }

        public String getHelp() {
            return "commands.bloodmagic.orb." + this.func_71517_b() + ".help";
        }

        public String getInfo() {
            return "";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length == 1 && (args[0].equals("?") || args[0].equals("help"))) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.getHelp(), new Object[0]));
                return;
            }
            this.player = args.length < 2 ? OrbCommand.func_71521_c((ICommandSender)sender) : OrbCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            this.uuid = PlayerHelper.getUUIDFromPlayer((EntityPlayer)this.player).toString();
            this.network = NetworkHelper.getSoulNetwork(this.uuid);
            this.subExecute(server, sender, args);
        }

        protected abstract void subExecute(MinecraftServer var1, ICommandSender var2, String ... var3) throws CommandException;
    }
}

