/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.gui;

import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.ItemRouterAmountPacketProcessor;
import WayofTime.bloodmagic.network.ItemRouterButtonPacketProcessor;
import WayofTime.bloodmagic.tile.container.ContainerItemRoutingNode;
import WayofTime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import WayofTime.bloodmagic.util.GhostItemHelper;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiItemRoutingNode
extends GuiContainer {
    private GuiTextField textBox;
    private TileFilteredRoutingNode inventory;
    private ContainerItemRoutingNode container;
    private int left;
    private int top;

    public GuiItemRoutingNode(InventoryPlayer playerInventory, IInventory tileRoutingNode) {
        super((Container)new ContainerItemRoutingNode(playerInventory, tileRoutingNode));
        this.field_146999_f = 201;
        this.field_147000_g = 169;
        this.inventory = (TileFilteredRoutingNode)tileRoutingNode;
        this.container = (ContainerItemRoutingNode)this.field_147002_h;
    }

    private int getCurrentActiveSlotPriority() {
        EnumFacing direction = EnumFacing.func_82600_a((int)this.inventory.currentActiveSlot);
        if (direction != null) {
            return this.inventory.getPriority(direction);
        }
        return 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.left = (this.field_146294_l - this.field_146999_f) / 2;
        this.top = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.left + 176, this.top + 14, 18, 18, "D"));
        this.field_146292_n.add(new GuiButton(1, this.left + 176, this.top + 32, 18, 18, "U"));
        this.field_146292_n.add(new GuiButton(2, this.left + 176, this.top + 50, 18, 18, "N"));
        this.field_146292_n.add(new GuiButton(3, this.left + 176, this.top + 68, 18, 18, "S"));
        this.field_146292_n.add(new GuiButton(4, this.left + 176, this.top + 86, 18, 18, "W"));
        this.field_146292_n.add(new GuiButton(5, this.left + 176, this.top + 104, 18, 18, "E"));
        this.field_146292_n.add(new GuiButton(6, this.left + 160, this.top + 50, 10, 18, ">"));
        this.field_146292_n.add(new GuiButton(7, this.left + 132, this.top + 50, 10, 18, "<"));
        this.disableDirectionalButton(this.inventory.currentActiveSlot);
        this.textBox = new GuiTextField(0, this.field_146289_q, this.left + 94, this.top + 37, 70, 12);
        this.textBox.func_146185_a(false);
        this.textBox.func_146180_a("");
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textBox.func_146201_a(typedChar, keyCode)) {
            if (this.container.lastGhostSlotClicked != -1) {
                String str = this.textBox.func_146179_b();
                int amount = 0;
                if (!str.isEmpty()) {
                    try {
                        Integer testVal = Integer.decode(str);
                        if (testVal != null) {
                            amount = testVal;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.setValueOfGhostItemInSlot(this.container.lastGhostSlotClicked, amount);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private void setValueOfGhostItemInSlot(int ghostItemSlot, int amount) {
        BloodMagicPacketHandler.INSTANCE.sendToServer((IMessage)new ItemRouterAmountPacketProcessor(ghostItemSlot, amount, this.inventory.func_174877_v(), this.inventory.func_145831_w()));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textBox.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.container.lastGhostSlotClicked != -1) {
            Slot slot = this.container.func_75139_a(this.container.lastGhostSlotClicked + 1);
            ItemStack stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                this.textBox.func_146180_a("" + amount);
            } else {
                this.textBox.func_146180_a("");
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.inventory.func_70005_c_(), this.field_146999_f, this.field_147000_g / 4, 0x404040);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            BloodMagicPacketHandler.INSTANCE.sendToServer((IMessage)new ItemRouterButtonPacketProcessor(button.field_146127_k, this.inventory.func_174877_v(), this.inventory.func_145831_w()));
            if (button.field_146127_k < 6) {
                this.inventory.currentActiveSlot = button.field_146127_k;
                this.enableAllDirectionalButtons();
                button.field_146124_l = false;
            }
        }
    }

    private void enableAllDirectionalButtons() {
        for (GuiButton button : this.field_146292_n) {
            button.field_146124_l = true;
        }
    }

    private void disableDirectionalButton(int id) {
        ((GuiButton)this.field_146292_n.get((int)id)).field_146124_l = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ItemStack clickedStack;
        this.field_146289_q.func_78276_b("" + this.getCurrentActiveSlotPriority(), 148, 55, 0xFFFFFF);
        String s = "";
        if (this.container.lastGhostSlotClicked != -1 && !(clickedStack = this.field_147002_h.func_75139_a(1 + this.container.lastGhostSlotClicked).func_75211_c()).func_190926_b()) {
            s = clickedStack.func_82833_r();
        }
        this.field_146289_q.func_175063_a(s.substring(0, Math.min(16, s.length())), 81.0f, 19.0f, 0xFFFFFF);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation soulForgeGuiTextures = new ResourceLocation("bloodmagic:textures/gui/routingNode.png");
        this.field_146297_k.func_110434_K().func_110577_a(soulForgeGuiTextures);
        this.func_73729_b(this.left, this.top, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.textBox.func_146194_f();
    }
}

