/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.ModuleCore;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemRegistryCore;
import forestry.core.items.ItemRegistryFluids;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.Log;
import forestry.modules.BlankForestryModule;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ForestryModule(containerID="forestry", moduleID="fluids", name="Fluids", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.fluids.description")
public class ModuleFluids
extends BlankForestryModule {
    @Nullable
    private static ItemRegistryFluids items;

    private static void createFluid(Fluids fluidDefinition) {
        String fluidName;
        if (fluidDefinition.getFluid() == null && Config.isFluidEnabled(fluidDefinition) && !FluidRegistry.isFluidRegistered((String)(fluidName = fluidDefinition.getTag()))) {
            ResourceLocation[] resources = fluidDefinition.getResources();
            Fluid fluid = new Fluid(fluidName, resources[0], fluidDefinition.flowTextureExists() ? resources[1] : resources[0]);
            fluid.setDensity(fluidDefinition.getDensity());
            fluid.setViscosity(fluidDefinition.getViscosity());
            fluid.setTemperature(fluidDefinition.getTemperature());
            FluidRegistry.registerFluid((Fluid)fluid);
            ModuleFluids.createBlock(fluidDefinition);
        }
    }

    private static void createBlock(Fluids forestryFluid) {
        Fluid fluid = forestryFluid.getFluid();
        Preconditions.checkNotNull((Object)fluid);
        Block fluidBlock = fluid.getBlock();
        if (Config.isBlockEnabled(forestryFluid.getTag())) {
            if (fluidBlock == null) {
                fluidBlock = forestryFluid.makeBlock();
                if (fluidBlock != null) {
                    String name = "fluid." + forestryFluid.getTag();
                    fluidBlock.func_149663_c("forestry." + name);
                    fluidBlock.setRegistryName(name);
                    ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)fluidBlock);
                    ItemBlock itemBlock = new ItemBlock(fluidBlock);
                    itemBlock.setRegistryName(name);
                    ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
                    Proxies.render.registerFluidStateMapper(fluidBlock, forestryFluid);
                    if (forestryFluid.getOtherContainers().isEmpty()) {
                        FluidRegistry.addBucketForFluid((Fluid)fluid);
                    }
                }
            } else {
                ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)fluidBlock);
                Log.warning("Pre-existing {} fluid block detected, deferring to {}:{}, this may cause issues if the server/client have different mod load orders, recommended that you disable all but one instance of {} fluid blocks via your configs.", fluid.getName(), resourceLocation.func_110624_b(), resourceLocation.func_110623_a(), fluid.getName());
            }
        }
    }

    public static ItemRegistryFluids getItems() {
        Preconditions.checkNotNull((Object)items);
        return items;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public void registerItemsAndBlocks() {
        for (Fluids fluidType : Fluids.values()) {
            ModuleFluids.createFluid(fluidType);
        }
        items = new ItemRegistryFluids();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void doInit() {
        FluidStack biomass;
        FluidStack ethanol;
        if (RecipeManagers.squeezerManager != null) {
            ItemRegistryCore itemRegistryCore = ModuleCore.getItems();
            RecipeManagers.squeezerManager.addContainerRecipe(10, ModuleFluids.getItems().canEmpty.getItemStack(), itemRegistryCore.ingotTin.func_77946_l(), 0.05f);
            RecipeManagers.squeezerManager.addContainerRecipe(10, ModuleFluids.getItems().waxCapsuleEmpty.getItemStack(), itemRegistryCore.beeswax.getItemStack(), 0.1f);
            RecipeManagers.squeezerManager.addContainerRecipe(10, ModuleFluids.getItems().refractoryEmpty.getItemStack(), itemRegistryCore.refractoryWax.getItemStack(), 0.1f);
        }
        if ((ethanol = Fluids.BIO_ETHANOL.getFluid(1)) != null) {
            GeneratorFuel ethanolFuel = new GeneratorFuel(ethanol, (int)(32.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.generator")), 4);
            FuelManager.generatorFuel.put(ethanol.getFluid(), ethanolFuel);
        }
        if ((biomass = Fluids.BIOMASS.getFluid(1)) != null) {
            GeneratorFuel biomassFuel = new GeneratorFuel(biomass, (int)(8.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.generator")), 1);
            FuelManager.generatorFuel.put(biomass.getFluid(), biomassFuel);
        }
    }

    @Override
    public void registerRecipes() {
        Fluid milk = Fluids.MILK.getFluid();
        if (milk == null) {
            return;
        }
        for (EnumContainerType containerType : EnumContainerType.values()) {
            if (containerType == EnumContainerType.JAR || containerType == EnumContainerType.GLASS) continue;
            RecipeUtil.addRecipe("cake_" + containerType.getName(), new ItemStack(Items.field_151105_aU), "AAA", "BEB", "CCC", Character.valueOf('A'), items.getContainer(containerType, milk), Character.valueOf('B'), Items.field_151102_aT, Character.valueOf('C'), Items.field_151015_O, Character.valueOf('E'), Items.field_151110_aK);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerTextures(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        for (Fluids fluids : Fluids.values()) {
            Fluid fluid = fluids.getFluid();
            if (fluid == null) continue;
            map.func_174942_a(fluid.getStill());
            map.func_174942_a(fluid.getFlowing());
        }
    }
}

