/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.titan.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TitanBlocks
extends Block
implements ISortableBlock {
    public static final PropertyEnum<EnumTitanBlocks> BASIC_TYPE = PropertyEnum.func_177709_a((String)"type", EnumTitanBlocks.class);

    public TitanBlocks() {
        super(Material.field_151576_e);
        this.func_149663_c("titanblocks");
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumTitanBlocks blockBasic : EnumTitanBlocks.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockBasic.getMeta()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumTitanBlocks type = (EnumTitanBlocks)((Object)state.func_177229_b(BASIC_TYPE));
        switch (type) {
            case TITAN_SAPPHIRE_ORE: {
                return GCItems.itemBasicMoon;
            }
            case TITAN_EMERALD_ORE: {
                return Items.field_151166_bC;
            }
            case TITAN_DIAMOND_ORE: {
                return Items.field_151045_i;
            }
            case TITAN_COAL_ORE: {
                return Items.field_151044_h;
            }
            case TITAN_LAPIS_ORE: {
                return Items.field_151100_aR;
            }
            case TITAN_REDSTONE_ORE: {
                return Items.field_151137_ax;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        EnumTitanBlocks type = (EnumTitanBlocks)((Object)state.func_177229_b(BASIC_TYPE));
        switch (type) {
            case TITAN_SAPPHIRE_ORE: {
                return 2;
            }
            case TITAN_EMERALD_ORE: 
            case TITAN_DIAMOND_ORE: 
            case TITAN_COAL_ORE: 
            case TITAN_REDSTONE_ORE: {
                return 0;
            }
            case TITAN_LAPIS_ORE: {
                return 4;
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int bonus = 0;
        int default_count = 0;
        EnumTitanBlocks type = (EnumTitanBlocks)((Object)state.func_177229_b(BASIC_TYPE));
        if (type == EnumTitanBlocks.TITAN_SAPPHIRE_ORE) {
            bonus = 2;
        }
        if (type == EnumTitanBlocks.TITAN_LAPIS_ORE) {
            bonus = 2;
            default_count = 8;
        }
        if (type == EnumTitanBlocks.TITAN_REDSTONE_ORE) {
            bonus = 2;
            default_count = 4;
        }
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a(state, random, fortune)) {
            int j = random.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return (this.func_149745_a(random) + default_count) * (j + 1) + bonus;
        }
        return this.func_149745_a(random) + default_count + random.nextInt(1 + bonus);
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumTitanBlocks.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumTitanBlocks)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public static enum EnumTitanBlocks implements IStringSerializable
    {
        TITAN_GRUNT(0, "titan_grunt"),
        TITAN_SUBGRUNT(1, "titan_subgrunt"),
        TITAN_STONE(2, "titan_stone"),
        TITAN_SAPPHIRE_ORE(3, "titan_sapphire_ore"),
        TITAN_EMERALD_ORE(4, "titan_emerald_ore"),
        TITAN_DIAMOND_ORE(5, "titan_diamond_ore"),
        TITAN_COAL_ORE(6, "titan_coal_ore"),
        TITAN_LAPIS_ORE(7, "titan_lapis_ore"),
        TITAN_REDSTONE_ORE(8, "titan_redstone_ore");

        private final int meta;
        private final String name;
        private static final EnumTitanBlocks[] values;

        private EnumTitanBlocks(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumTitanBlocks byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumTitanBlocks.values();
        }
    }
}

