/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.blocks;

import galaxyspace.core.GSFluids;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.GSEventHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockFluidGS
extends BlockFluidClassic {
    private boolean isDamaged;
    private boolean isFlammable;

    public BlockFluidGS(Fluid fluid, Material material, boolean isDamage) {
        this(fluid, material, isDamage, false);
    }

    public BlockFluidGS(Fluid fluid, Material material, boolean isDamage, boolean isFlammable) {
        super(fluid, material);
        this.setQuantaPerBlock(fluid.isGaseous() ? 0 : 9);
        this.func_149663_c("block_" + fluid.getName());
        if (this.density <= FluidRegistry.WATER.getDensity()) {
            this.displacements.put(Blocks.field_150355_j, false);
            this.displacements.put(Blocks.field_150358_i, false);
        }
        if (this.density <= FluidRegistry.LAVA.getDensity()) {
            this.displacements.put(Blocks.field_150353_l, false);
            this.displacements.put(Blocks.field_150356_k, false);
        }
        this.isDamaged = isDamage;
        this.isFlammable = isFlammable;
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (this.isFlammable && GSConfigCore.enableGasExplosion) {
            boolean flag = false;
            for (BlockPos around : BlockPos.func_191532_a((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
                if (world.func_180495_p(pos.func_177971_a((Vec3i)around)).func_177230_c() == Blocks.field_150480_ab) {
                    flag = true;
                }
                if (world.func_180495_p(pos.func_177971_a((Vec3i)around)).func_177230_c() == Blocks.field_150478_aa) {
                    flag = true;
                }
                if (world.func_180495_p(pos.func_177971_a((Vec3i)around)).func_177230_c() == Blocks.field_189877_df) {
                    flag = true;
                }
                if (!flag) continue;
                world.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0f, true, true);
                flag = false;
            }
        }
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        return !this.stack.getFluid().isGaseous();
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isDamaged) {
            entity.func_70097_a(DamageSource.field_76377_j, 0.5f);
        }
        if (this.stack.getFluid() == GSFluids.NatureGas) {
            EntityLivingBase living;
            boolean flag = false;
            if (entity instanceof EntityLivingBase && (living = (EntityLivingBase)entity) instanceof EntityPlayerMP && !((EntityPlayerMP)living).field_71075_bZ.field_75098_d) {
                if (!living.func_70644_a(MobEffects.field_76440_q)) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 4));
                }
                if (!OxygenUtil.hasValidOxygenSetup((EntityPlayerMP)((EntityPlayerMP)living)) && !GSEventHandler.isValidOxygenTanks((EntityPlayerMP)living)) {
                    if (!living.func_70644_a(MobEffects.field_76436_u)) {
                        living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 4));
                    }
                } else {
                    GSEventHandler.consumeOxygenFromTank((EntityPlayerMP)living, 1);
                }
            }
        }
    }
}

