/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.login;

import com.mojang.authlib.Agent;
import com.mojang.authlib.UserType;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import com.sintinium.oauth.login.MicrosoftLogin;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LoginUtil {
    public static String lastMojangUsername = null;
    public static boolean needsRefresh = true;
    public static boolean wasOnline = false;
    private static long lastCheck = -1L;
    private static YggdrasilAuthenticationService authService = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
    private static YggdrasilUserAuthentication userAuth = (YggdrasilUserAuthentication)authService.createUserAuthentication(Agent.MINECRAFT);
    private static YggdrasilMinecraftSessionService minecraftSessionService = (YggdrasilMinecraftSessionService)authService.createMinecraftSessionService();

    public static void updateOnlineStatus() {
        needsRefresh = true;
        LoginUtil.isOnline();
    }

    public static boolean isOnline() {
        if (!needsRefresh && System.currentTimeMillis() - lastCheck < 10000L) {
            return wasOnline;
        }
        Session session = Minecraft.func_71410_x().func_110432_I();
        String uuid = UUID.randomUUID().toString();
        needsRefresh = false;
        lastCheck = System.currentTimeMillis();
        try {
            minecraftSessionService.joinServer(session.func_148256_e(), session.func_148254_d(), uuid);
            if (minecraftSessionService.hasJoinedServer(session.func_148256_e(), uuid, null).isComplete()) {
                wasOnline = true;
                return true;
            }
            wasOnline = false;
            return false;
        }
        catch (AuthenticationException e) {
            wasOnline = false;
            return false;
        }
    }

    public static void loginMs(MicrosoftLogin.MinecraftProfile profile) {
        Session session = new Session(profile.name, profile.id, profile.token.accessToken, Session.Type.MOJANG.name());
        LoginUtil.setSession(session);
    }

    public static Optional<Boolean> loginMojangOrLegacy(String username, String password) {
        try {
            if (password.isEmpty()) {
                Session session = new Session(username, UUID.nameUUIDFromBytes(username.getBytes()).toString(), null, UserType.LEGACY.getName());
                LoginUtil.setSession(session);
                return Optional.of(true);
            }
            userAuth.setUsername(username);
            userAuth.setPassword(password);
            userAuth.logIn();
            String name = userAuth.getSelectedProfile().getName();
            String uuid = UUIDTypeAdapter.fromUUID((UUID)userAuth.getSelectedProfile().getId());
            String token = userAuth.getAuthenticatedToken();
            String type = userAuth.getUserType().getName();
            userAuth.logOut();
            Session session = new Session(name, uuid, token, type);
            LoginUtil.setSession(session);
            lastMojangUsername = username;
            return Optional.of(true);
        }
        catch (AuthenticationUnavailableException e) {
            return Optional.empty();
        }
        catch (AuthenticationException e) {
            return Optional.of(false);
        }
    }

    private static void setSession(Session session) {
        needsRefresh = true;
        LoginUtil.updateOnlineStatus();
        Field field = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_71449_j");
        field.setAccessible(true);
        try {
            field.set(Minecraft.func_71410_x(), session);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

