/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.fieldEvents.item;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ObscuratorFieldData
implements INetworkFieldData {
    EnumFacing side;
    Block block;
    IBlockState blockState;
    IBlockState renderState;
    int[] colorMultiplier;
    boolean valid;
    EnumHand hand;

    public ObscuratorFieldData() {
    }

    public ObscuratorFieldData(EnumHand playerHand, EnumFacing facing, IBlockState state, IBlockState render, int[] color) {
        this.hand = playerHand;
        this.side = facing;
        this.block = state.func_177230_c();
        this.blockState = state;
        this.renderState = render;
        this.colorMultiplier = color;
        this.valid = true;
    }

    @Override
    public void read(IInputBuffer buffer) {
        Comparable value;
        IProperty prop;
        int i;
        this.valid = false;
        this.side = EnumFacing.func_82600_a((int)buffer.readByte());
        this.hand = buffer.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.block = (Block)buffer.readForgeRegistryEntry(Block.field_149771_c);
        if (this.block == null) {
            this.block = Blocks.field_150350_a;
            return;
        }
        this.blockState = this.block.func_176223_P();
        this.renderState = this.block.func_176223_P();
        this.colorMultiplier = new int[buffer.readByte()];
        for (int i2 = 0; i2 < this.colorMultiplier.length; ++i2) {
            this.colorMultiplier[i2] = buffer.readInt();
        }
        int size = buffer.readByte();
        for (i = 0; i < size; ++i) {
            prop = this.getProperty(buffer.readString(NetworkField.BitLevel.Bit8));
            if (prop == null) {
                return;
            }
            value = this.getValue(prop, buffer.readString());
            if (value == null) {
                return;
            }
            this.blockState = this.blockState.func_177226_a(prop, value);
        }
        size = buffer.readByte();
        for (i = 0; i < size; ++i) {
            prop = this.getProperty(buffer.readString(NetworkField.BitLevel.Bit8));
            if (prop == null) {
                return;
            }
            value = this.getValue(prop, buffer.readString());
            if (value == null) {
                return;
            }
            this.renderState = this.renderState.func_177226_a(prop, value);
        }
        this.valid = true;
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeByte((byte)this.side.func_176745_a());
        buffer.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        buffer.writeForgeEntry((IForgeRegistryEntry)this.block);
        buffer.writeByte((byte)this.colorMultiplier.length);
        for (int i = 0; i < this.colorMultiplier.length; ++i) {
            buffer.writeInt(this.colorMultiplier[i]);
        }
        Collection list = this.blockState.func_177227_a();
        buffer.writeByte((byte)list.size());
        for (IProperty prop : list) {
            buffer.writeString(prop.func_177701_a(), NetworkField.BitLevel.Bit8);
            buffer.writeString(prop.func_177702_a(this.blockState.func_177229_b(prop)));
        }
        Collection renderList = this.renderState.func_177227_a();
        buffer.writeByte((byte)renderList.size());
        for (IProperty prop : renderList) {
            buffer.writeString(prop.func_177701_a(), NetworkField.BitLevel.Bit8);
            buffer.writeString(prop.func_177702_a(this.renderState.func_177229_b(prop)));
        }
    }

    private Comparable getValue(IProperty prop, String value) {
        for (Object entry : prop.func_177700_c()) {
            if (!prop.func_177702_a((Comparable)entry).equals(value)) continue;
            return (Comparable)entry;
        }
        return null;
    }

    private IProperty getProperty(String key) {
        for (IProperty prop : this.blockState.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals(key)) continue;
            return prop;
        }
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Block getBlock() {
        return this.block;
    }

    public IBlockState getModelState() {
        return this.blockState;
    }

    public IBlockState getRenderState() {
        return this.renderState;
    }

    public int[] getColorMultiplier() {
        return this.colorMultiplier;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public EnumHand getHand() {
        return this.hand;
    }
}

