/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.inv.inventories.ToolBoxInventory;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemToolBox
extends ItemIC2
implements IHandHeldInventory,
IBootable {
    public ItemToolBox() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.toolBox);
        this.func_77625_d(1);
    }

    @Override
    public void onLoad() {
        Ic2Items.carbonBox = new ItemStack((Item)this, 1, 2);
        Ic2Items.iridiumBox = new ItemStack((Item)this, 1, 4);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5);
    }

    @Override
    public int getTextureEntry(int meta) {
        if (meta > 1) {
            return 25 + (meta - 2);
        }
        return 57 - meta;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return Ic2ItemLang.toolBoxFilled;
            }
            case 2: {
                return Ic2ItemLang.carbonBox;
            }
            case 3: {
                return Ic2ItemLang.carbonBoxFilled;
            }
            case 4: {
                return Ic2ItemLang.iridiumBox;
            }
            case 5: {
                return Ic2ItemLang.iridiumBoxFilled;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        int type = stack.func_77960_j() / 2;
        if (type == 1) {
            return new ToolBoxInventory.CarbonBoxInventory(player, this, stack);
        }
        if (type == 2) {
            return new ToolBoxInventory.IridiumBoxInventory(player, this, stack);
        }
        return new ToolBoxInventory(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (IC2.platform.isSimulating()) {
            IC2.platform.launchGui(playerIn, this.getInventory(playerIn, handIn, playerIn.func_184586_b(handIn)), handIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        items.add((Object)new ItemStack((Item)this, 1, 2));
        items.add((Object)new ItemStack((Item)this, 1, 4));
    }
}

